/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.OutParameter;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.StatementConfiguration;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryRunnerTest {
    QueryRunner runner;
    ArrayHandler handler;
    @Mock
    DataSource dataSource;
    @Mock
    Connection conn;
    @Mock
    PreparedStatement prepStmt;
    @Mock
    Statement stmt;
    @Mock
    CallableStatement call;
    @Mock
    ParameterMetaData meta;
    @Mock
    ResultSet results;
    @Mock
    ResultSetMetaData resultsMeta;

    private void callBatchWithException(String sql, Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        boolean caught = false;
        try {
            this.runner.batch(sql, params);
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).getParameterMetaData();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            System.out.println("[TEST] The following exception is expected:");
            System.out.println(e);
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callExecuteWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.query("{call my_proc(?, ?)}", (ResultSetHandler)this.handler, params);
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callExecuteWithResultSetWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.execute("{call my_proc(?, ?)}", (ResultSetHandler)this.handler, params);
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callGoodBatch(Connection conn, Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch(conn, "select * from blah where ? = ?", params);
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).getParameterMetaData();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodBatch(Object[][] params) throws Exception {
        this.callGoodBatch(params, true);
    }

    private void callGoodBatch(Object[][] params, boolean pmdCheck) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch("select * from blah where ? = ?", params);
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)(pmdCheck ? 1 : 0)))).getParameterMetaData();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
    }

    private void callGoodExecute() throws Exception {
        Mockito.when((Object)this.call.execute()).thenReturn((Object)false);
        Mockito.when((Object)this.call.getUpdateCount()).thenReturn((Object)3);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        int result = this.runner.execute("{call my_proc(?, ?)}", new Object[]{"unit", "test"});
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        result = this.runner.execute("{call my_proc()}", new Object[0]);
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)42);
        OutParameter intParam = new OutParameter(4, Integer.class);
        result = this.runner.execute("{?= call my_proc()}", new Object[]{intParam});
        Assert.assertEquals((long)42L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)4242);
        intParam.setValue(null);
        result = this.runner.execute("{?= call my_proc(?, ?)}", new Object[]{intParam, "unit", "test"});
        Assert.assertEquals((long)4242L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)4))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)24);
        Mockito.when((Object)this.call.getObject(3)).thenReturn((Object)"out");
        intParam.setValue(null);
        OutParameter stringParam = new OutParameter(12, String.class, (Object)"in");
        result = this.runner.execute("{?= call my_proc(?, ?)}", new Object[]{intParam, "test", stringParam});
        Assert.assertEquals((long)24L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((Object)"out", (Object)stringParam.getValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)5))).close();
    }

    private void callGoodExecute(Connection conn) throws Exception {
        Mockito.when((Object)this.call.execute()).thenReturn((Object)false);
        Mockito.when((Object)this.call.getUpdateCount()).thenReturn((Object)3);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        int result = this.runner.execute(conn, "{call my_proc(?, ?)}", new Object[]{"unit", "test"});
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        result = this.runner.execute(conn, "{call my_proc()}", new Object[0]);
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)42);
        OutParameter intParam = new OutParameter(4, Integer.class);
        result = this.runner.execute(conn, "{?= call my_proc()}", new Object[]{intParam});
        Assert.assertEquals((long)42L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)4242);
        intParam.setValue(null);
        result = this.runner.execute(conn, "{?= call my_proc(?, ?)}", new Object[]{intParam, "unit", "test"});
        Assert.assertEquals((long)4242L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)24);
        Mockito.when((Object)this.call.getObject(3)).thenReturn((Object)"out");
        intParam.setValue(null);
        OutParameter stringParam = new OutParameter(12, String.class, (Object)"in");
        result = this.runner.execute(conn, "{?= call my_proc(?, ?)}", new Object[]{intParam, "test", stringParam});
        Assert.assertEquals((long)24L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((Object)"out", (Object)stringParam.getValue());
        Assert.assertEquals((long)3L, (long)result);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).execute();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodExecuteWithResultSet() throws Exception {
        Mockito.when((Object)this.call.execute()).thenReturn((Object)true);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.execute("{call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.execute("{call my_proc()}", (ResultSetHandler)this.handler, new Object[0]);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)42);
        OutParameter intParam = new OutParameter(4, Integer.class);
        this.runner.execute("{?= call my_proc()}", (ResultSetHandler)this.handler, new Object[]{intParam});
        Assert.assertEquals((long)42L, (long)((Integer)intParam.getValue()).intValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)3))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)4242);
        intParam.setValue(null);
        this.runner.execute("{?= call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{intParam, "unit", "test"});
        Assert.assertEquals((long)4242L, (long)((Integer)intParam.getValue()).intValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)4))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)4))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)24);
        Mockito.when((Object)this.call.getObject(3)).thenReturn((Object)"out");
        intParam.setValue(null);
        OutParameter stringParam = new OutParameter(12, String.class, (Object)"in");
        this.runner.execute("{?= call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{intParam, "test", stringParam});
        Assert.assertEquals((long)24L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((Object)"out", (Object)stringParam.getValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)5))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)5))).close();
    }

    private void callGoodExecuteWithResultSet(Connection conn) throws Exception {
        Mockito.when((Object)this.call.execute()).thenReturn((Object)true);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.execute(conn, "{call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.execute(conn, "{call my_proc()}", (ResultSetHandler)this.handler, new Object[0]);
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)42);
        OutParameter intParam = new OutParameter(4, Integer.class);
        this.runner.execute(conn, "{?= call my_proc()}", (ResultSetHandler)this.handler, new Object[]{intParam});
        Assert.assertEquals((long)42L, (long)((Integer)intParam.getValue()).intValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)3))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)4242);
        intParam.setValue(null);
        this.runner.execute(conn, "{?= call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{intParam, "unit", "test"});
        Assert.assertEquals((long)4242L, (long)((Integer)intParam.getValue()).intValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)4))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)4))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        Mockito.when((Object)this.call.getObject(1)).thenReturn((Object)24);
        Mockito.when((Object)this.call.getObject(3)).thenReturn((Object)"out");
        intParam.setValue(null);
        OutParameter stringParam = new OutParameter(12, String.class, (Object)"in");
        this.runner.execute(conn, "{?= call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{intParam, "test", stringParam});
        Assert.assertEquals((long)24L, (long)((Integer)intParam.getValue()).intValue());
        Assert.assertEquals((Object)"out", (Object)stringParam.getValue());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)5))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)5))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "select * from blah where ? = ?";
        this.runner.query(sql, (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        sql = "select * from blah";
        this.runner.query(sql, (ResultSetHandler)this.handler);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery(sql);
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
    }

    private void callGoodQuery(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "select * from blah where ? = ?";
        this.runner.query(conn, sql, (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        sql = "select * from blah";
        this.runner.query(conn, sql, (ResultSetHandler)this.handler);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery(sql);
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodUpdate() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "update blah set ? = ?";
        this.runner.update(sql, new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        sql = "update blah set unit = test";
        this.runner.update(sql);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate(sql);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        sql = "update blah set unit = ?";
        this.runner.update(sql, (Object)"test");
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).close();
    }

    private void callGoodUpdate(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.update(conn, "update blah set ? = ?", new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        String sql = "update blah set unit = test";
        this.runner.update(conn, "update blah set unit = test");
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate("update blah set unit = test");
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        this.runner.update(conn, "update blah set unit = ?", (Object)"test");
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callQueryWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            String sql = "select * from blah where ? = ?";
            this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, params);
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.never())).close();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callUpdateWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            String sql = "select * from blah where ? = ?";
            this.runner.update("select * from blah where ? = ?", params);
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.conn.prepareStatement((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.prepStmt);
        Mockito.when((Object)this.prepStmt.getParameterMetaData()).thenReturn((Object)this.meta);
        Mockito.when((Object)this.prepStmt.executeQuery()).thenReturn((Object)this.results);
        Mockito.when((Object)this.conn.createStatement()).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.stmt.executeQuery((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.results);
        Mockito.when((Object)this.conn.prepareCall((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.call);
        Mockito.when((Object)this.call.getParameterMetaData()).thenReturn((Object)this.meta);
        Mockito.when((Object)this.call.getResultSet()).thenReturn((Object)this.results);
        Mockito.when((Object)this.call.getMoreResults()).thenReturn((Object)false);
        Mockito.when((Object)this.results.next()).thenReturn((Object)false);
        this.handler = new ArrayHandler();
        this.runner = new QueryRunner(this.dataSource);
    }

    @Test
    public void testAddBatchExceptionOnAdd() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.prepStmt)).addBatch();
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test(expected=SQLException.class)
    public void testBadPrepareConnection() throws Exception {
        this.runner = new QueryRunner();
        this.runner.update("update blah set unit = test");
    }

    @Test
    public void testExecuteBatchExceptionOnExec() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.prepStmt)).executeBatch();
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testExecuteException() throws Exception {
        this.callExecuteWithException(this.handler, "unit", "test");
    }

    @Test
    public void testExecuteQueryException() throws Exception {
        this.callQueryWithException(this.handler, "unit", "test");
    }

    @Test
    public void testExecuteUpdateException() throws Exception {
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.prepStmt)).executeUpdate();
        this.callUpdateWithException("unit", "test");
    }

    @Test
    public void testExecuteWithMultipleResultSets() throws Exception {
        Mockito.when((Object)this.call.execute()).thenReturn((Object)true);
        Mockito.when((Object)this.call.getMoreResults()).thenAnswer((Answer)new Answer<Boolean>(){
            int count = 1;

            public Boolean answer(InvocationOnMock invocation) {
                return ++this.count <= 3;
            }
        });
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        List objects = this.runner.execute("{call my_proc()}", (ResultSetHandler)this.handler, new Object[0]);
        Assert.assertEquals((long)3L, (long)objects.size());
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).execute();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)3))).close();
        ((CallableStatement)Mockito.verify((Object)this.call, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testExecuteWithResultSetException() throws Exception {
        this.callExecuteWithResultSetWithException(this.handler, "unit", "test");
    }

    @Test
    public void testFillStatementWithBean() throws Exception {
        MyBean bean = new MyBean();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        this.runner.fillStatementWithBean(this.prepStmt, (Object)bean, new String[]{"a", "b", "c"});
    }

    @Test(expected=NullPointerException.class)
    public void testFillStatementWithBeanNullNames() throws Exception {
        MyBean bean = new MyBean();
        this.runner.fillStatementWithBean(this.prepStmt, (Object)bean, new String[]{"a", "b", null});
    }

    @Test
    public void testGoodBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params);
    }

    @Test
    public void testGoodBatchDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(this.conn, params);
    }

    @Test
    public void testGoodBatchInsert() throws Exception {
        this.results = (ResultSet)Mockito.mock(ResultSet.class);
        this.resultsMeta = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Mockito.when((Object)this.conn.prepareStatement((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((int)1))).thenReturn((Object)this.prepStmt);
        Mockito.when((Object)this.prepStmt.getGeneratedKeys()).thenReturn((Object)this.results);
        Mockito.when((Object)this.results.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        ResultSetHandler handler = rs -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            while (rs.next()) {
                objects.add(new Object());
            }
            return objects;
        };
        Object[][] params = new Object[2][2];
        params[0][0] = "Test";
        params[0][1] = "Blah";
        params[1][0] = "Test2";
        params[1][1] = "Blah2";
        List generatedKeys = (List)this.runner.insertBatch("INSERT INTO blah(col1, col2) VALUES(?,?)", handler, params);
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertEquals((long)2L, (long)generatedKeys.size());
    }

    @Test
    public void testGoodBatchPmdTrue() throws Exception {
        this.runner = new QueryRunner(this.dataSource, true);
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params, false);
    }

    @Test
    public void testGoodExecute() throws Exception {
        this.callGoodExecute();
    }

    @Test
    public void testGoodExecuteDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodExecute(this.conn);
    }

    @Test
    public void testGoodExecutePmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodExecute(this.conn);
    }

    @Test
    public void testGoodExecuteWithResultSet() throws Exception {
        this.callGoodExecuteWithResultSet();
    }

    @Test
    public void testGoodExecuteWithResultSetDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodExecuteWithResultSet(this.conn);
    }

    @Test
    public void testGoodExecuteWithResultSetPmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodExecuteWithResultSet(this.conn);
    }

    @Test
    public void testGoodInsert() throws Exception {
        this.results = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Mockito.when((Object)this.conn.prepareStatement((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((int)1))).thenReturn((Object)this.prepStmt);
        Mockito.when((Object)this.prepStmt.getGeneratedKeys()).thenReturn((Object)this.results);
        Mockito.when((Object)this.results.next()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)this.results.getObject(1)).thenReturn((Object)1L);
        Long generatedKey = (Long)this.runner.insert("INSERT INTO blah(col1, col2) VALUES(?,?)", (ResultSetHandler)new ScalarHandler(), new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertEquals((long)1L, (long)generatedKey);
    }

    @Test
    public void testGoodQuery() throws Exception {
        this.callGoodQuery();
    }

    @Test
    public void testGoodQueryDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodQuery(this.conn);
    }

    @Test
    public void testGoodQueryPmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodQuery(this.conn);
    }

    @Test
    public void testGoodUpdate() throws Exception {
        this.callGoodUpdate();
    }

    @Test
    public void testGoodUpdateDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodUpdate(this.conn);
    }

    @Test
    public void testGoodUpdatePmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodUpdate(this.conn);
    }

    @Test
    public void testNoParamsExecute() throws Exception {
        this.callGoodExecute();
    }

    @Test
    public void testNoParamsExecuteWithResultSet() throws Exception {
        this.callExecuteWithResultSetWithException(new Object[0]);
    }

    @Test
    public void testNoParamsQuery() throws Exception {
        this.callGoodQuery();
    }

    @Test
    public void testNoParamsUpdate() throws Exception {
        this.callGoodUpdate();
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.batch("select * from blah where ? = ?", params);
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionExecute() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.execute("{call my_proc(?, ?)}", new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionExecuteWithResultSet() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.execute("{call my_proc(?, ?)}", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionQuery() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionUpdate() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.update("select * from blah where ? = ?", new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullHandlerExecute() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.execute("{call my_proc(?, ?)}", new Object[0]);
    }

    @Test(expected=SQLException.class)
    public void testNullHandlerExecuteWithResultSet() throws Exception {
        this.runner.execute("{call my_proc(?, ?)}", (ResultSetHandler)null, new Object[0]);
    }

    @Test(expected=SQLException.class)
    public void testNullHandlerQuery() throws Exception {
        this.runner.query("select * from blah where ? = ?", null);
    }

    @Test(expected=SQLException.class)
    public void testNullParamsArgBatch() throws Exception {
        this.runner.batch("select * from blah where ? = ?", null);
    }

    @Test
    public void testNullParamsBatch() throws Exception {
        Object[][] params = new String[][]{{null, "unit"}, {"test", null}};
        this.callGoodBatch(params);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.runner.batch(null, params);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlExecute() throws Exception {
        this.runner.execute(null, new Object[0]);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlExecuteWithResultSet() throws Exception {
        this.runner.execute(null, (ResultSetHandler)this.handler, new Object[0]);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlQuery() throws Exception {
        this.runner.query(null, (ResultSetHandler)this.handler);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlUpdate() throws Exception {
        this.runner.update(null);
    }

    @Test
    public void testStatementConfiguration() throws Exception {
        StatementConfiguration stmtConfig = new StatementConfiguration(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));
        QueryRunner queryRunner = new QueryRunner(stmtConfig);
        queryRunner.prepareStatement(this.conn, "select 1");
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt)).setFetchDirection(ArgumentMatchers.eq((int)1));
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt)).setFetchSize(ArgumentMatchers.eq((int)2));
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt)).setMaxFieldSize(ArgumentMatchers.eq((int)3));
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt)).setMaxRows(ArgumentMatchers.eq((int)4));
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt)).setQueryTimeout(ArgumentMatchers.eq((int)5));
    }

    @Test
    public void testTooFewParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit"}, {"test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testTooFewParamsExecute() throws Exception {
        this.callExecuteWithException("unit");
    }

    @Test
    public void testTooFewParamsExecuteWithResultSet() throws Exception {
        this.callExecuteWithResultSetWithException("unit");
    }

    @Test
    public void testTooFewParamsQuery() throws Exception {
        this.callQueryWithException("unit");
    }

    @Test
    public void testTooFewParamsUpdate() throws Exception {
        this.callUpdateWithException("unit");
    }

    @Test
    public void testTooManyParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit", "unit"}, {"test", "test", "test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testTooManyParamsExecute() throws Exception {
        this.callExecuteWithException("unit", "test", "fail");
    }

    @Test
    public void testTooManyParamsExecuteWithResultSet() throws Exception {
        this.callExecuteWithResultSetWithException("unit", "test", "fail");
    }

    @Test
    public void testTooManyParamsQuery() throws Exception {
        this.callQueryWithException("unit", "test", "fail");
    }

    @Test
    public void testTooManyParamsUpdate() throws Exception {
        this.callUpdateWithException("unit", "test", "fail");
    }

    class MyBean {
        private int a;
        private double b;
        private String c;

        MyBean() {
        }

        public int getA() {
            return this.a;
        }

        public double getB() {
            return this.b;
        }

        public String getC() {
            return this.c;
        }

        public void setA(int a) {
            this.a = a;
        }

        public void setB(double b) {
            this.b = b;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}

