/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.AbstractKeyedHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class BeanMapHandler<K, V>
extends AbstractKeyedHandler<K, V> {
    private final Class<V> type;
    private final RowProcessor convert;
    private final int columnIndex;
    private final String columnName;

    public BeanMapHandler(Class<V> type) {
        this(type, ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public BeanMapHandler(Class<V> type, int columnIndex) {
        this(type, ArrayHandler.ROW_PROCESSOR, columnIndex, null);
    }

    public BeanMapHandler(Class<V> type, RowProcessor convert) {
        this(type, convert, 1, null);
    }

    private BeanMapHandler(Class<V> type, RowProcessor convert, int columnIndex, String columnName) {
        this.type = type;
        this.convert = convert;
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    public BeanMapHandler(Class<V> type, String columnName) {
        this(type, ArrayHandler.ROW_PROCESSOR, 1, columnName);
    }

    @Override
    protected K createKey(ResultSet resultSet) throws SQLException {
        return (K)(this.columnName == null ? resultSet.getObject(this.columnIndex) : resultSet.getObject(this.columnName));
    }

    @Override
    protected V createRow(ResultSet resultSet) throws SQLException {
        return this.convert.toBean(resultSet, this.type);
    }
}

