/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.apache.commons.crypto.cipher.CryptoCipher;

class JceCipher
implements CryptoCipher {
    private final Cipher cipher;

    public JceCipher(Properties props, String transformation) throws GeneralSecurityException {
        String provider = props.getProperty("commons.crypto.cipher.jce.provider", "");
        this.cipher = provider.isEmpty() ? Cipher.getInstance(transformation) : Cipher.getInstance(transformation, provider);
    }

    @Override
    public void close() {
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    public int doFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(inBuffer, outBuffer);
    }

    @Override
    public String getAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    @Override
    public final int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void init(int mode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(params, "params");
        this.cipher.init(mode, key, params);
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    public int update(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        return this.cipher.update(inBuffer, outBuffer);
    }

    @Override
    public void updateAAD(byte[] aad) {
        this.cipher.updateAAD(aad);
    }

    @Override
    public void updateAAD(ByteBuffer aad) {
        this.cipher.updateAAD(aad);
    }
}

