/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXPathTest {
    protected static final String ATTR_NAME = "counter";
    protected static final String CHILD_NAME1 = "subNode";
    protected static final String CHILD_NAME2 = "childNode";
    protected static final int CHILD_COUNT = 5;
    protected static final int LEVEL_COUNT = 3;
    protected ConfigurationNode root;

    @Before
    public void setUp() throws Exception {
        this.root = this.constructHierarchy(3);
    }

    @After
    public void tearDown() throws Exception {
        this.root = null;
    }

    protected ConfigurationNode constructHierarchy(int levels) {
        DefaultConfigurationNode result = new DefaultConfigurationNode();
        this.createLevel((ConfigurationNode)result, levels);
        return result;
    }

    protected int iteratorSize(NodeIterator iterator) {
        boolean ok;
        int cnt = 0;
        do {
            if (!(ok = iterator.setPosition(cnt + 1))) continue;
            ++cnt;
        } while (ok);
        return cnt;
    }

    protected List<ConfigurationNode> iterationElements(NodeIterator iterator) {
        ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>();
        int pos = 1;
        while (iterator.setPosition(pos)) {
            result.add((ConfigurationNode)iterator.getNodePointer().getNode());
            ++pos;
        }
        return result;
    }

    private void createLevel(ConfigurationNode parent, int level) {
        if (level >= 0) {
            String prefix = parent.getValue() == null ? "" : parent.getValue() + ".";
            for (int i = 1; i <= 5; ++i) {
                DefaultConfigurationNode child = new DefaultConfigurationNode(i % 2 == 0 ? CHILD_NAME1 : CHILD_NAME2, (Object)(prefix + i));
                parent.addChild((ConfigurationNode)child);
                child.addAttribute((ConfigurationNode)new DefaultConfigurationNode(ATTR_NAME, (Object)String.valueOf(i)));
                this.createLevel((ConfigurationNode)child, level - 1);
            }
        }
    }
}

