/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junitx.framework.ArrayAssert;
import junitx.framework.ListAssert;
import junitx.framework.ObjectAssert;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.plist.ParseException;
import org.apache.commons.configuration.plist.PropertyListConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPropertyListConfiguration {
    private PropertyListConfiguration config;
    private String testProperties = ConfigurationAssert.getTestFile("test.plist").getAbsolutePath();

    @Before
    public void setUp() throws Exception {
        this.config = new PropertyListConfiguration();
        this.config.setFileName(this.testProperties);
        this.config.load();
    }

    @Test
    public void testLoad() {
        Assert.assertFalse((String)"the configuration is empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testLoadWithError() {
        this.config = new PropertyListConfiguration();
        try {
            this.config.load((Reader)new StringReader(""));
            Assert.fail((String)"No exception thrown on loading an empty file");
        }
        catch (ConfigurationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testString() {
        Assert.assertEquals((String)"simple-string", (Object)"string1", (Object)this.config.getProperty("simple-string"));
    }

    @Test
    public void testQuotedString() {
        Assert.assertEquals((String)"quoted-string", (Object)"string2", (Object)this.config.getProperty("quoted-string"));
        Assert.assertEquals((String)"quoted-string2", (Object)"this is a string", (Object)this.config.getProperty("quoted-string2"));
        Assert.assertEquals((String)"complex-string", (Object)"this is a \"complex\" string {(=,;)}", (Object)this.config.getProperty("complex-string"));
    }

    @Test
    public void testEmptyArray() {
        String key = "empty-array";
        Assert.assertNotNull((String)"array null", (Object)this.config.getProperty(key));
        List list = (List)this.config.getProperty(key);
        Assert.assertTrue((String)"array is not empty", (boolean)list.isEmpty());
    }

    @Test
    public void testArray() {
        String key = "array";
        Assert.assertNotNull((String)"array null", (Object)this.config.getProperty(key));
        List list = (List)this.config.getProperty(key);
        Assert.assertFalse((String)"array is empty", (boolean)list.isEmpty());
        Assert.assertEquals((String)"1st value", (Object)"value1", list.get(0));
        Assert.assertEquals((String)"2nd value", (Object)"value2", list.get(1));
        Assert.assertEquals((String)"3rd value", (Object)"value3", list.get(2));
    }

    @Test
    public void testNestedArrays() {
        String key = "nested-arrays";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(0));
        List list1 = (List)list.get(0);
        Assert.assertFalse((String)"nested array 1 is empty", (boolean)list1.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list1.size());
        Assert.assertEquals((String)"1st element", (Object)"a", list1.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"b", list1.get(1));
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(1));
        List list2 = (List)list.get(1);
        Assert.assertFalse((String)"nested array 2 is empty", (boolean)list2.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"1st element", (Object)"c", list2.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"d", list2.get(1));
    }

    @Test
    public void testDictionary() {
        Assert.assertEquals((String)"1st element in dictionary", (Object)"bar1", (Object)this.config.getProperty("dictionary.foo1"));
        Assert.assertEquals((String)"2nd element in dictionary", (Object)"bar2", (Object)this.config.getProperty("dictionary.foo2"));
    }

    @Test
    public void testDictionaryArray() {
        String key = "dictionary-array";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(0));
        Configuration conf1 = (Configuration)list.get(0);
        Assert.assertFalse((String)"configuration 1 is empty", (boolean)conf1.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"bar", (Object)conf1.getProperty("foo"));
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(1));
        Configuration conf2 = (Configuration)list.get(1);
        Assert.assertFalse((String)"configuration 2 is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"value", (Object)conf2.getProperty("key"));
    }

    @Test
    public void testNestedDictionaries() {
        Assert.assertEquals((String)"nested property", (Object)"value", (Object)this.config.getString("nested-dictionaries.foo.bar.key"));
    }

    @Test
    public void testData() {
        ObjectAssert.assertInstanceOf((String)"data", new byte[0].getClass(), (Object)this.config.getProperty("data"));
        ArrayAssert.assertEquals((String)"data", (byte[])"foo bar".getBytes(), (byte[])((byte[])this.config.getProperty("data")));
    }

    @Test
    public void testDate() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 2, 22, 11, 30, 0);
        cal.setTimeZone(TimeZone.getTimeZone("GMT+0100"));
        Date date = cal.getTime();
        Assert.assertEquals((String)"date", (Object)date, (Object)this.config.getProperty("date"));
    }

    @Test
    public void testSave() throws Exception {
        File savedFile = new File("target/testsave.plist");
        if (savedFile.exists()) {
            Assert.assertTrue((boolean)savedFile.delete());
        }
        String filename = savedFile.getAbsolutePath();
        this.config.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        PropertyListConfiguration checkConfig = new PropertyListConfiguration(new File(filename));
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("The saved configuration doesn't contain the key '" + key + "'"), (boolean)checkConfig.containsKey(key));
            Object value = checkConfig.getProperty(key);
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                ArrayAssert.assertEquals((String)("Value of the '" + key + "' property"), (byte[])((byte[])this.config.getProperty(key)), (byte[])array);
                continue;
            }
            if (value instanceof List) {
                List list1 = (List)this.config.getProperty(key);
                List list2 = (List)value;
                Assert.assertEquals((String)("The size of the list for the key '" + key + "' doesn't match"), (long)list1.size(), (long)list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    Object value1 = list1.get(i);
                    Object value2 = list2.get(i);
                    if (value1 instanceof Configuration) {
                        StrictConfigurationComparator comparator = new StrictConfigurationComparator();
                        Assert.assertTrue((String)("The dictionnary at index " + i + " for the key '" + key + "' doesn't match"), (boolean)comparator.compare((Configuration)value1, (Configuration)value2));
                        continue;
                    }
                    Assert.assertEquals((String)("Element at index " + i + " for the key '" + key + "'"), value1, value2);
                }
                ListAssert.assertEquals((String)("Value of the '" + key + "' property"), (List)((List)this.config.getProperty(key)), (List)list1);
                continue;
            }
            Assert.assertEquals((String)("Value of the '" + key + "' property"), (Object)this.config.getProperty(key), (Object)checkConfig.getProperty(key));
        }
    }

    @Test
    public void testSaveEmptyDictionary() throws Exception {
        File savedFile = new File("target/testsave.plist");
        if (savedFile.exists()) {
            Assert.assertTrue((boolean)savedFile.delete());
        }
        String filename = savedFile.getAbsolutePath();
        this.config.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        PropertyListConfiguration checkConfig = new PropertyListConfiguration(new File(filename));
        Assert.assertFalse((boolean)this.config.getRootNode().getChildren("empty-dictionary").isEmpty());
        Assert.assertFalse((boolean)checkConfig.getRootNode().getChildren("empty-dictionary").isEmpty());
    }

    @Test
    public void testQuoteString() {
        Assert.assertEquals((String)"null string", null, (Object)this.config.quoteString(null));
        Assert.assertEquals((String)"simple string", (Object)"abcd", (Object)this.config.quoteString("abcd"));
        Assert.assertEquals((String)"string with a space", (Object)"\"ab cd\"", (Object)this.config.quoteString("ab cd"));
        Assert.assertEquals((String)"string with a quote", (Object)"\"foo\\\"bar\"", (Object)this.config.quoteString("foo\"bar"));
        Assert.assertEquals((String)"string with a special char", (Object)"\"foo;bar\"", (Object)this.config.quoteString("foo;bar"));
    }

    @Test
    public void testSetDataProperty() throws Exception {
        byte[] expected = new byte[]{1, 2, 3, 4};
        PropertyListConfiguration config = new PropertyListConfiguration();
        config.setProperty("foo", (Object)expected);
        config.save("target/testdata.plist");
        PropertyListConfiguration config2 = new PropertyListConfiguration("target/testdata.plist");
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testAddDataProperty() throws Exception {
        byte[] expected = new byte[]{1, 2, 3, 4};
        PropertyListConfiguration config = new PropertyListConfiguration();
        config.addProperty("foo", (Object)expected);
        config.save("target/testdata.plist");
        PropertyListConfiguration config2 = new PropertyListConfiguration("target/testdata.plist");
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testInitCopy() {
        PropertyListConfiguration copy = new PropertyListConfiguration((HierarchicalConfiguration)this.config);
        Assert.assertFalse((String)"Nothing was copied", (boolean)copy.isEmpty());
    }

    @Test(expected=ParseException.class)
    public void testParseDateNoNumber() throws ParseException {
        PropertyListConfiguration.parseDate((String)"<*D2002-03-22 1c:30:00 +0100>");
    }

    @Test(expected=ParseException.class)
    public void testParseDateTooShort() throws ParseException {
        PropertyListConfiguration.parseDate((String)"<*D2002-03-22 11:3>");
    }

    @Test(expected=ParseException.class)
    public void testParseDateInvalidChar() throws ParseException {
        PropertyListConfiguration.parseDate((String)"<*D2002+03-22 11:30:00 +0100>");
    }

    @Test(expected=ParseException.class)
    public void testParseDateNull() throws ParseException {
        PropertyListConfiguration.parseDate(null);
    }

    @Test
    public void testFormatDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 9, 29, 23, 4, 30);
        cal.setTimeZone(TimeZone.getTimeZone("GMT-0230"));
        Assert.assertEquals((String)"Wrong date literal (1)", (Object)"<*D2007-10-29 23:04:30 -0230>", (Object)PropertyListConfiguration.formatDate((Calendar)cal));
        cal.clear();
        cal.set(2007, 9, 30, 22, 2, 15);
        cal.setTimeZone(TimeZone.getTimeZone("GMT+1111"));
        Assert.assertEquals((String)"Wrong date literal (2)", (Object)"<*D2007-10-30 22:02:15 +1111>", (Object)PropertyListConfiguration.formatDate((Calendar)cal));
    }
}

