/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Compress700Test {
    private static final Path PATH = Paths.get("src/test/resources/org/apache/commons/compress/COMPRESS-700/flutter_awesome_buttons-0.1.0.tar", new String[0]);

    Compress700Test() {
    }

    @Test
    void testFirstTarArchiveEntry() throws Exception {
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(PATH, new OpenOption[0])));){
            TarArchiveEntry entry = inputStream.getNextEntry();
            Assertions.assertNull((Object)entry.getCreationTime());
            Assertions.assertEquals((long)-1L, (long)entry.getDataOffset());
            Assertions.assertEquals((int)0, (int)entry.getDevMajor());
            Assertions.assertEquals((int)0, (int)entry.getDevMinor());
            Assertions.assertEquals(Collections.emptyMap(), (Object)entry.getExtraPaxHeaders());
            Assertions.assertEquals((int)0, (int)entry.getGroupId());
            Assertions.assertEquals((Object)"", (Object)entry.getGroupName());
            Assertions.assertNull((Object)entry.getLastAccessTime());
            Assertions.assertEquals((long)Date.parse("Tue Dec 03 05:08:42 EST 2019"), (long)entry.getLastModifiedDate().getTime());
            Assertions.assertEquals((Object)FileTime.from(Instant.parse("2019-12-03T10:08:42Z")), (Object)entry.getLastModifiedTime());
            Assertions.assertEquals((int)48, (int)entry.getLinkFlag());
            Assertions.assertEquals((Object)"", (Object)entry.getLinkName());
            Assertions.assertEquals((long)0L, (long)entry.getLongGroupId());
            Assertions.assertEquals((long)0L, (long)entry.getLongUserId());
            Assertions.assertEquals((int)33279, (int)entry.getMode());
            Assertions.assertEquals((long)Date.parse("Tue Dec 03 05:08:42 EST 2019"), (long)entry.getModTime().getTime());
            Assertions.assertEquals((Object)"build/app.dill", (Object)entry.getName());
            Assertions.assertNull((Object)entry.getPath());
            Assertions.assertEquals((long)0L, (long)entry.getRealSize());
            Assertions.assertEquals((long)0L, (long)entry.getSize());
            Assertions.assertNull((Object)entry.getStatusChangeTime());
            Assertions.assertEquals((int)0, (int)entry.getUserId());
            Assertions.assertEquals((Object)"", (Object)entry.getUserName());
            Assertions.assertTrue((boolean)entry.isFile());
            Assertions.assertFalse((boolean)entry.isBlockDevice());
            Assertions.assertFalse((boolean)entry.isCharacterDevice());
            Assertions.assertTrue((boolean)entry.isCheckSumOK());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isExtended());
            Assertions.assertFalse((boolean)entry.isFIFO());
            Assertions.assertFalse((boolean)entry.isGlobalPaxHeader());
            Assertions.assertFalse((boolean)entry.isGNULongLinkEntry());
            Assertions.assertFalse((boolean)entry.isGNULongNameEntry());
            Assertions.assertFalse((boolean)entry.isGNUSparse());
            Assertions.assertFalse((boolean)entry.isLink());
            Assertions.assertFalse((boolean)entry.isOldGNUSparse());
            Assertions.assertFalse((boolean)entry.isPaxGNU1XSparse());
            Assertions.assertFalse((boolean)entry.isPaxGNUSparse());
            Assertions.assertFalse((boolean)entry.isPaxHeader());
            Assertions.assertFalse((boolean)entry.isSparse());
            Assertions.assertFalse((boolean)entry.isStarSparse());
            Assertions.assertTrue((boolean)entry.isStreamContiguous());
            Assertions.assertFalse((boolean)entry.isSymbolicLink());
            Assertions.assertTrue((boolean)entry.isTypeFlagUstar());
        }
    }

    @Test
    void testListEntries() throws IOException {
        List<Object[]> list = Arrays.asList({0, "build/app.dill"}, {105, "CHANGELOG.md"}, {2119, "example/android/app/build.gradle"}, {339, "example/android/app/src/debug/AndroidManifest.xml"}, {1745, "example/android/app/src/main/AndroidManifest.xml"}, {559, "example/android/app/src/main/java/io/flutter/plugins/GeneratedPluginRegistrant.java"}, {353, "example/android/app/src/main/kotlin/com/example/test_package/MainActivity.kt"}, {446, "example/android/app/src/main/res/drawable/launch_background.xml"}, {544, "example/android/app/src/main/res/mipmap-hdpi/ic_launcher.png"}, {442, "example/android/app/src/main/res/mipmap-mdpi/ic_launcher.png"}, {721, "example/android/app/src/main/res/mipmap-xhdpi/ic_launcher.png"}, {1031, "example/android/app/src/main/res/mipmap-xxhdpi/ic_launcher.png"}, {1443, "example/android/app/src/main/res/mipmap-xxxhdpi/ic_launcher.png"}, {369, "example/android/app/src/main/res/values/styles.xml"}, {339, "example/android/app/src/profile/AndroidManifest.xml"}, {613, "example/android/build.gradle"}, {32, "example/android/gradle.properties"}, {4971, "example/android/gradlew"}, {2404, "example/android/gradlew.bat"}, {53636, "example/android/gradle/wrapper/gradle-wrapper.jar"}, {240, "example/android/gradle/wrapper/gradle-wrapper.properties"}, {150, "example/android/local.properties"}, {499, "example/android/settings.gradle"}, {1630, "example/android/test_package_android.iml"}, {820, "example/ios/Flutter/AppFrameworkInfo.plist"}, {31, "example/ios/Flutter/Debug.xcconfig"}, {461, "example/ios/Flutter/flutter_export_environment.sh"}, {380, "example/ios/Flutter/Generated.xcconfig"}, {31, "example/ios/Flutter/Release.xcconfig"}, {21606, "example/ios/Runner.xcodeproj/project.pbxproj"}, {159, "example/ios/Runner.xcodeproj/project.xcworkspace/contents.xcworkspacedata"}, {3382, "example/ios/Runner.xcodeproj/xcshareddata/xcschemes/Runner.xcscheme"}, {159, "example/ios/Runner.xcworkspace/contents.xcworkspacedata"}, {417, "example/ios/Runner/AppDelegate.swift"}, {2641, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Contents.json"}, {10932, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-1024x1024@1x.png"}, {564, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-20x20@1x.png"}, {1283, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-20x20@2x.png"}, {1588, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-20x20@3x.png"}, {1025, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-29x29@1x.png"}, {1716, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-29x29@2x.png"}, {1920, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-29x29@3x.png"}, {1283, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-40x40@1x.png"}, {1895, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-40x40@2x.png"}, {2665, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-40x40@3x.png"}, {2665, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-60x60@2x.png"}, {3831, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-60x60@3x.png"}, {1888, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-76x76@1x.png"}, {3294, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-76x76@2x.png"}, {3612, "example/ios/Runner/Assets.xcassets/AppIcon.appiconset/Icon-App-83.5x83.5@2x.png"}, {414, "example/ios/Runner/Assets.xcassets/LaunchImage.imageset/Contents.json"}, {68, "example/ios/Runner/Assets.xcassets/LaunchImage.imageset/LaunchImage.png"}, {68, "example/ios/Runner/Assets.xcassets/LaunchImage.imageset/LaunchImage@2x.png"}, {68, "example/ios/Runner/Assets.xcassets/LaunchImage.imageset/LaunchImage@3x.png"}, {340, "example/ios/Runner/Assets.xcassets/LaunchImage.imageset/README.md"}, {2414, "example/ios/Runner/Base.lproj/LaunchScreen.storyboard"}, {1631, "example/ios/Runner/Base.lproj/Main.storyboard"}, {310, "example/ios/Runner/GeneratedPluginRegistrant.h"}, {204, "example/ios/Runner/GeneratedPluginRegistrant.m"}, {1576, "example/ios/Runner/Info.plist"}, {37, "example/ios/Runner/Runner-Bridging-Header.h"}, {8996, "example/lib/main.dart"}, {2759, "example/pubspec.yaml"}, {9879, "example/README.md"}, {1081, "example/test/widget_test.dart"}, {913, "example/test_package.iml"}, {1000, "flutter_buttons.iml"}, {36861, "lib/flutter_awesome_buttons.dart"}, {30, "LICENSE"}, {1751, "pubspec.yaml"}, {9879, "README.md"}, {433, "test/flutter_buttons_test.dart"});
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(PATH, new OpenOption[0])));){
            AtomicInteger i = new AtomicInteger();
            for (Object[] pair : list) {
                TarArchiveEntry entry = inputStream.getNextEntry();
                Assertions.assertNotNull((Object)entry, (String)entry.getName());
                String name = (String)pair[1];
                Assertions.assertEquals((Object)name, (Object)entry.getName(), () -> String.format("[%d] %s", i.get(), entry));
                int size = (Integer)pair[0];
                Assertions.assertEquals((long)size, (long)entry.getSize(), () -> String.format("[%d] %s", i.get(), entry));
                Assertions.assertEquals((long)size, (long)entry.getRealSize(), () -> String.format("[%d] %s", i.get(), entry));
                i.incrementAndGet();
            }
        }
    }

    @Test
    void testTarArchive() throws Exception {
        try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(PATH, new OpenOption[0]));){
            Assertions.assertEquals((Object)"tar", (Object)ArchiveStreamFactory.detect((InputStream)fileInputStream));
        }
    }
}

