/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.UnmodifiableSortedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeFullMap() {
        TreeMap m = new TreeMap();
        this.addSampleMappings(m);
        return UnmodifiableSortedMap.unmodifiableSortedMap(m);
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return UnmodifiableSortedMap.unmodifiableSortedMap(new TreeMap());
    }

    @Test
    public void testDecorateFactory() {
        Map map = this.makeFullMap();
        Assertions.assertSame((Object)map, (Object)UnmodifiableSortedMap.unmodifiableSortedMap((SortedMap)map));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableSortedMap.unmodifiableSortedMap(null));
    }

    @Test
    public void testHeadMap() {
        Map map = this.makeFullMap();
        TreeMap m = new TreeMap();
        Assertions.assertSame((Object)m.isEmpty(), (Object)map.headMap("again").isEmpty());
        Assertions.assertSame((Object)18, (Object)map.size());
        Assertions.assertSame((Object)17, (Object)map.headMap("you").size());
        Assertions.assertSame((Object)16, (Object)map.headMap("we'll").size());
    }

    @Test
    public void testSubMap() {
        Map map = this.makeFullMap();
        Assertions.assertSame((Object)18, (Object)map.size());
        Assertions.assertSame((Object)17, (Object)map.subMap("again", "you").size());
        Assertions.assertSame((Object)16, (Object)map.subMap("again", "we'll").size());
        Assertions.assertSame((Object)0, (Object)map.subMap("again", "again").size());
        Assertions.assertSame((Object)map.headMap("you").size(), (Object)map.subMap("again", "you").size());
    }

    @Test
    public void testTailMap() {
        Map map = this.makeFullMap();
        Assertions.assertSame((Object)18, (Object)map.size());
        Assertions.assertSame((Object)1, (Object)map.tailMap("you").size());
        Assertions.assertSame((Object)2, (Object)map.tailMap("we'll").size());
        Assertions.assertSame((Object)18, (Object)map.tailMap("again").size());
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }
}

