/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.cli.help.Util;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class UtilTest {
    UtilTest() {
    }

    public static Stream<Arguments> charArgs() {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        char[] whitespace = new char[]{' ', '\t', '\n', '\f', '\r', '\f', '\r', '\u000e', '\u000b', '\u001c', '\u001d', '\u001e', '\u001f'};
        char[] nonBreakingSpace = new char[]{'\u00a0', '\u2007', '\u202f'};
        for (char c : whitespace) {
            lst.add(Arguments.of((Object[])new Object[]{Character.valueOf(c), Boolean.TRUE}));
        }
        for (char c : nonBreakingSpace) {
            lst.add(Arguments.of((Object[])new Object[]{Character.valueOf(c), Boolean.FALSE}));
        }
        return lst.stream();
    }

    @Test
    void testFindNonWhitespacePos() {
        Assertions.assertEquals((int)-1, (int)Util.indexOfNonWhitespace(null, (int)0));
        Assertions.assertEquals((int)-1, (int)Util.indexOfNonWhitespace((CharSequence)"", (int)0));
    }

    @ParameterizedTest
    @MethodSource(value={"charArgs"})
    void testFindNonWhitespacePos(Character c, boolean isWhitespace) {
        String text = String.format("%cWorld", c);
        Assertions.assertEquals((int)(isWhitespace ? 1 : 0), (int)Util.indexOfNonWhitespace((CharSequence)text, (int)0));
        text = String.format("%c%c%c", c, c, c);
        Assertions.assertEquals((int)(isWhitespace ? -1 : 0), (int)Util.indexOfNonWhitespace((CharSequence)text, (int)0));
    }

    @Test
    void testIsEmpty() {
        String str = null;
        Assertions.assertTrue((boolean)Util.isEmpty(str), (String)"null string should be empty");
        str = "";
        Assertions.assertTrue((boolean)Util.isEmpty((CharSequence)str), (String)"empty string should be empty");
        str = " ";
        Assertions.assertFalse((boolean)Util.isEmpty((CharSequence)str), (String)"string with whitespace should not be empty");
    }

    @ParameterizedTest
    @MethodSource(value={"charArgs"})
    void testRtrim(Character c, boolean isWhitespace) {
        if (isWhitespace) {
            Assertions.assertEquals((Object)"worx", (Object)Util.rtrim((String)String.format("worx%s", c)), () -> String.format("Did not process character 0x%x", c.charValue()));
        } else {
            Assertions.assertNotEquals((Object)"worx", (Object)Util.rtrim((String)String.format("worx%s", c)), () -> String.format("Did not process character 0x%x", c.charValue()));
        }
        String text = String.format("%c%c%c", c, c, c);
        Assertions.assertEquals((Object)(isWhitespace ? "" : text), (Object)Util.ltrim((String)text));
    }
}

