/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.LocaleConvertUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class LocaleConvertUtilsTest {
    private char decimalSeparator;

    private void checkIntegerArray(Object value, int[] intArray) {
        Assertions.assertNotNull((Object)value, (String)"Returned value is not null");
        Assertions.assertEquals(intArray.getClass(), value.getClass(), (String)"Returned value is int[]");
        int[] results = (int[])value;
        Assertions.assertEquals((int)intArray.length, (int)results.length, (String)"Returned array length");
        for (int i = 0; i < intArray.length; ++i) {
            Assertions.assertEquals((int)intArray[i], (int)results[i], (String)("Returned array value " + i));
        }
    }

    private void checkStringArray(Object value, String[] stringArray) {
        Assertions.assertNotNull((Object)value, (String)"Returned value is not null");
        Assertions.assertEquals(stringArray.getClass(), value.getClass(), (String)"Returned value is String[]");
        String[] results = (String[])value;
        Assertions.assertEquals((int)stringArray.length, (int)results.length, (String)"Returned array length");
        for (int i = 0; i < stringArray.length; ++i) {
            Assertions.assertEquals((Object)stringArray[i], (Object)results[i], (String)("Returned array value " + i));
        }
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestNegativeIntegerArray() {
        int[] intArray = new int[]{};
        Object value = LocaleConvertUtils.convert((String)null, intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"a", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ a }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"0,1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ 0, 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestNegativeStringArray() {
        String[] stringArray = new String[]{};
        Object value = LocaleConvertUtils.convert((String)null, stringArray.getClass());
        this.checkStringArray(value, stringArray);
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestObjectToStringArray() {
        int[] intArray0 = new int[]{};
        int[] intArray1 = new int[]{123};
        int[] intArray2 = new int[]{123, 456};
        String[] stringArray0 = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "def"};
        Assertions.assertEquals(null, (Object)LocaleConvertUtils.convert((Object)intArray0), (String)"intArray0");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)intArray1), (String)"intArray1");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)intArray2), (String)"intArray2");
        Assertions.assertEquals(null, (Object)LocaleConvertUtils.convert((Object)stringArray0), (String)"stringArray0");
        Assertions.assertEquals((Object)"abc", (Object)LocaleConvertUtils.convert((Object)stringArray1), (String)"stringArray1");
        Assertions.assertEquals((Object)"abc", (Object)LocaleConvertUtils.convert((Object)stringArray2), (String)"stringArray2");
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestPositiveArray() {
        String[] values1 = new String[]{"10", "20", "30"};
        Object value = LocaleConvertUtils.convert((String[])values1, Integer.TYPE);
        int[] shape = new int[]{};
        Assertions.assertEquals(shape.getClass(), value.getClass());
        int[] results1 = (int[])value;
        Assertions.assertEquals((int)results1[0], (int)10);
        Assertions.assertEquals((int)results1[1], (int)20);
        Assertions.assertEquals((int)results1[2], (int)30);
        String[] values2 = new String[]{"100", "200", "300"};
        value = LocaleConvertUtils.convert((String[])values2, shape.getClass());
        Assertions.assertEquals(shape.getClass(), value.getClass());
        int[] results2 = (int[])value;
        Assertions.assertEquals((int)results2[0], (int)100);
        Assertions.assertEquals((int)results2[1], (int)200);
        Assertions.assertEquals((int)results2[2], (int)300);
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestPositiveIntegerArray() {
        int[] intArray = new int[]{};
        int[] intArray1 = new int[]{0};
        int[] intArray2 = new int[]{0, 10};
        Object value = LocaleConvertUtils.convert((String)"{  }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"0", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)" 0 ", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)"{ 0 }", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)"0,10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"0 10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{0,10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{0 10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{ 0, 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{ 0 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
    }

    @Test
    @Disabled(value="Array conversions not implemented yet.")
    public void fixmetestPositiveStringArray() {
        String[] stringArray = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "de,f"};
        Object value = LocaleConvertUtils.convert((String)"", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)" ", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"{}", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"{  }", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"abc", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{abc}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"\"abc\"", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{\"abc\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"'abc'", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{'abc'}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"abc 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{abc, 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"\"abc\",\"de,f\"", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{\"abc\" 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"'abc' 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{'abc', \"de,f\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
    }

    @BeforeEach
    public void setUp() {
        LocaleConvertUtils.deregister();
        NumberFormat nf = NumberFormat.getNumberInstance();
        String result = nf.format(1.1);
        this.decimalSeparator = result.charAt(1);
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testConvertStringArrayLocaleNull() {
        Object result = LocaleConvertUtils.convert((String[])new String[]{"123"}, Integer[].class, null, (String)"#,###");
        Assertions.assertNotNull((Object)result, (String)"Null Result");
        Assertions.assertEquals(Integer[].class, result.getClass(), (String)"Integer Array Type");
        Assertions.assertEquals((int)1, (int)((Integer[])result).length, (String)"Integer Array Length");
        Assertions.assertEquals((Integer)123, (Integer)((Integer[])result)[0], (String)"Integer Array Value");
    }

    @Test
    public void testConvertStringLocaleNull() {
        Object result = LocaleConvertUtils.convert((String)"123", Integer.class, null, (String)"#,###");
        Assertions.assertNotNull((Object)result, (String)"Null Result");
        Assertions.assertEquals(Integer.class, result.getClass(), (String)"Integer Type");
        Assertions.assertEquals((Object)123, (Object)result, (String)"Integer Value");
    }

    @Test
    public void testDefaultToStringConversionUnsupportedType() {
        Integer value = 20131101;
        Assertions.assertEquals((Object)value.toString(), (Object)LocaleConvertUtils.convert((String)value.toString(), this.getClass()), (String)"Wrong result");
    }

    @Test
    public void testNegativeScalar() {
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Byte.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Byte.class));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Double.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Double.class));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Float.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Float.class));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Integer.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Integer.class));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Byte.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Long.class));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Short.TYPE));
        Assertions.assertThrows(ConversionException.class, () -> LocaleConvertUtils.convert((String)"foo", Short.class));
    }

    @Test
    public void testObjectToStringScalar() {
        Assertions.assertEquals((Object)"false", (Object)LocaleConvertUtils.convert((Object)Boolean.FALSE), (String)"Boolean->String");
        Assertions.assertEquals((Object)"true", (Object)LocaleConvertUtils.convert((Object)Boolean.TRUE), (String)"Boolean->String");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)123), (String)"Byte->String");
        Assertions.assertEquals((Object)"a", (Object)LocaleConvertUtils.convert((Object)Character.valueOf('a')), (String)"Character->String");
        Assertions.assertEquals((Object)("123" + this.decimalSeparator + "4"), (Object)LocaleConvertUtils.convert((Object)123.4), (String)"Double->String");
        Assertions.assertEquals((Object)("123" + this.decimalSeparator + "4"), (Object)LocaleConvertUtils.convert((Object)Float.valueOf(123.4f)), (String)"Float->String");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)123), (String)"Integer->String");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)123L), (String)"Long->String");
        Assertions.assertEquals((Object)"123", (Object)LocaleConvertUtils.convert((Object)123), (String)"Short->String");
        Assertions.assertEquals((Object)"abc", (Object)LocaleConvertUtils.convert((Object)"abc"), (String)"String->String");
        Assertions.assertEquals(null, (Object)LocaleConvertUtils.convert(null), (String)"String->String null");
    }

    @Test
    public void testPositiveScalar() {
        Object value = LocaleConvertUtils.convert((String)"123", Byte.TYPE);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)123);
        value = LocaleConvertUtils.convert((String)"123", Byte.class);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)123);
        value = LocaleConvertUtils.convert((String)("123" + this.decimalSeparator + "456"), Double.TYPE);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = LocaleConvertUtils.convert((String)("123" + this.decimalSeparator + "456"), Double.class);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = LocaleConvertUtils.convert((String)("123" + this.decimalSeparator + "456"), Float.TYPE);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = LocaleConvertUtils.convert((String)("123" + this.decimalSeparator + "456"), Float.class);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = LocaleConvertUtils.convert((String)"123", Integer.TYPE);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)123);
        value = LocaleConvertUtils.convert((String)"123", Integer.class);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)123);
        value = LocaleConvertUtils.convert((String)"123", Long.TYPE);
        Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)((Long)value), (long)123L);
        value = LocaleConvertUtils.convert((String)"123456", Long.class);
        Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)((Long)value), (long)123456L);
        String input = "2002-03-17";
        value = LocaleConvertUtils.convert((String)input, Date.class);
        Assertions.assertInstanceOf(Date.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
        input = "20:30:40";
        value = LocaleConvertUtils.convert((String)input, Time.class);
        Assertions.assertInstanceOf(Time.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
        input = "2002-03-17 20:30:40.0";
        value = LocaleConvertUtils.convert((String)input, Timestamp.class);
        Assertions.assertInstanceOf(Timestamp.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
    }
}

