/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira339Test {
    private static final Log LOG = LogFactory.getLog(Jira339Test.class);

    @BeforeEach
    protected void setUp() throws Exception {
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testIssue_BEANUTILS_331_BeanUtilsBean_populate() throws Exception {
        TestBean bean = new TestBean();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("comparator", null);
        BeanUtils.populate((Object)bean, properties);
        Assertions.assertNull(bean.getComparator(), (String)"TestBean comparator should be null");
    }

    @Test
    public void testIssue_BEANUTILS_339_BeanUtilsBean_setProperty() throws Exception {
        TestBean bean = new TestBean();
        BeanUtils.setProperty((Object)bean, (String)"comparator", null);
        Assertions.assertNull(bean.getComparator(), (String)"TestBean comparator should be null");
    }

    public static class TestBean {
        private Comparator<?> comparator;

        public Comparator<?> getComparator() {
            return this.comparator;
        }

        public void setComparator(Comparator<?> comparator) {
            this.comparator = comparator;
        }
    }
}

