/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
 */

#include <memory>
#include <celix/PushStreamProvider.h>
#include <exception>
#include <iostream>

using celix::PushStreamProvider;

int main() {
    using namespace celix;
    PushStreamProvider psp {};
    std::shared_ptr<celix::PromiseFactory> promiseFactory {std::make_shared<celix::PromiseFactory>()};
    int onClosedReceived{0};
    int onErrorReceived{0};
    auto ses = psp.template createSynchronousEventSource<int>(promiseFactory);
    auto stream = psp.createUnbufferedStream<int>(ses, promiseFactory);
    auto streamEnded = stream->filter([](const int& /*event*/) -> bool {
        return true;
    }).onClose([&](){
        onClosedReceived++;
    }).onError([&](){
        onErrorReceived++;
    }).forEach([&](int /*event*/) {
        throw std::exception();
    });

    ses->publish(1);
    streamEnded.wait();
    std::cout << "onClosedReceived=" << onClosedReceived << " onErrorReceived=" << onErrorReceived << std::endl;
    return 0;
}