/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.quota;

import java.io.Serializable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.quota.Quota;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.DynamicConfig;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0007\u000e\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)1\b\u0001C\u0001y!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005B\u0002%\u0001A\u0003%1\tC\u0003J\u0001\u0011\u0005!\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003m\u0001\u0011%Q\u000eC\u0003v\u0001\u0011%a\u000fC\u0003{\u0001\u0011%1\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0002\r#V|G/Y'b]\u0006<WM\u001d\u0006\u0003\u001d=\tQ!];pi\u0006T!\u0001E\t\u0002\r5\f7\u000f^3s\u0015\t\u00112#\u0001\u0004eKBdw.\u001f\u0006\u0003)U\tqa]3sm&\u001cWM\u0003\u0002\u0017/\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002)+\u000511m\\7n_:L!AK\u0013\u0003\u000f1{wmZ5oO\u0006a1-\u001a7fE>\u0014hnQ8oMB\u0011QFL\u0007\u0002O%\u0011qf\n\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\u000eG>tg-[4TKJ4\u0018nY3\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014AB2p]\u001aLwM\u0003\u0002\u0015m)\u0011\u0001f\u000e\u0006\u0003qU\taa]3sm\u0016\u0014\u0018B\u0001\u001e4\u00055\u0019uN\u001c4jON+'O^5dK\u00061A(\u001b8jiz\"2!P A!\tq\u0004!D\u0001\u000e\u0011\u0015Y3\u00011\u0001-\u0011\u0015\u00014\u00011\u00012\u00035!UIR!V\u0019R{\u0016+V(U\u0003V\t1\t\u0005\u0002E\r6\tQI\u0003\u0002\u000fO%\u0011q)\u0012\u0002\u0006#V|G/Y\u0001\u000f\t\u00163\u0015)\u0016'U?F+v\nV!!\u0003!9W\r^)v_R\fGCA\"L\u0011\u0015ae\u00011\u0001N\u00039)8/\u001a:JI\u0016tG/\u001b4jKJ\u0004\"AT)\u000e\u0003=S!\u0001U\u0014\u0002\u0011%$WM\u001c;jifL!AU(\u0003\u001dU\u001bXM]%eK:$\u0018NZ5fe\u0006A2\r[3dWF+x\u000e^1Ta\u0006\u001cW-\u0011<bS2\f'\r\\3\u0015\u0007U3w\r\u0005\u0003\u001f-b[\u0016BA, \u0005\u0019!V\u000f\u001d7feA\u0011a$W\u0005\u00035~\u0011qAQ8pY\u0016\fg\u000e\u0005\u0002]G:\u0011Q,\u0019\t\u0003=~i\u0011a\u0018\u0006\u0003An\ta\u0001\u0010:p_Rt\u0014B\u00012 \u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t|\u0002\"\u0002'\b\u0001\u0004i\u0005\"\u00025\b\u0001\u0004I\u0017A\u0005:fg>,(oY3SKN,X\u000e\u001d;j_:\u0004\"\u0001\u00126\n\u0005-,%a\u0005*fg>,(oY3D_:\u001cX/\u001c9uS>t\u0017!F2iK\u000e\\G)[:l\u0005f$Xm],sSR$XM\u001c\u000b\u0005+:|G\u000fC\u0003M\u0011\u0001\u0007Q\nC\u0003q\u0011\u0001\u0007\u0011/A\u0003wC2,X\r\u0005\u0002\u001fe&\u00111o\b\u0002\u0005\u0019>tw\rC\u0003\u000f\u0011\u0001\u00071)\u0001\ndQ\u0016\u001c7\u000eR5tW\u001aKG.Z\"pk:$H\u0003B+xqfDQ\u0001T\u0005A\u00025CQ\u0001]\u0005A\u0002EDQAD\u0005A\u0002\r\u000bQc\u00195fG.DEMZ:CsR,7o\u0016:jiR,g\u000e\u0006\u0003Vyvt\b\"\u0002'\u000b\u0001\u0004i\u0005\"\u00029\u000b\u0001\u0004\t\b\"\u0002\b\u000b\u0001\u0004\u0019\u0015AE2iK\u000e\\\u0007\n\u001a4t\r&dWmQ8v]R$r!VA\u0002\u0003\u000b\t9\u0001C\u0003M\u0017\u0001\u0007Q\nC\u0003q\u0017\u0001\u0007\u0011\u000fC\u0003\u000f\u0017\u0001\u00071\t")
public class QuotaManager
implements Logging {
    private final ConfigService configService;
    private final Quota DEFAULT_QUOTA;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        QuotaManager quotaManager = this;
        synchronized (quotaManager) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public Quota DEFAULT_QUOTA() {
        return this.DEFAULT_QUOTA;
    }

    public Quota getQuota(UserIdentifier userIdentifier) {
        if (this.configService != null) {
            DynamicConfig config = this.configService.getTenantUserConfigFromCache(userIdentifier.tenantId(), userIdentifier.name());
            return config.getQuota();
        }
        return this.DEFAULT_QUOTA();
    }

    public Tuple2<Object, String> checkQuotaSpaceAvailable(UserIdentifier userIdentifier, ResourceConsumption resourceResumption) {
        Quota quota = this.getQuota(userIdentifier);
        Seq checkResults = (Seq)new .colon.colon(this.checkDiskBytesWritten(userIdentifier, resourceResumption.diskBytesWritten(), quota), (List)new .colon.colon(this.checkDiskFileCount(userIdentifier, resourceResumption.diskFileCount(), quota), (List)new .colon.colon(this.checkHdfsBytesWritten(userIdentifier, resourceResumption.hdfsBytesWritten(), quota), (List)new .colon.colon(this.checkHdfsFileCount(userIdentifier, resourceResumption.hdfsFileCount(), quota), (List)Nil$.MODULE$))));
        boolean exceed = BoxesRunTime.unboxToBoolean((Object)checkResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)QuotaManager.$anonfun$checkQuotaSpaceAvailable$1(BoxesRunTime.unboxToBoolean((Object)x$1), x$2))));
        String reason = (String)checkResults.foldLeft((Object)"", (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> new StringBuilder(0).append((String)x$3).append(x$4._2()).toString());
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((!exceed ? 1 : 0) != 0), (Object)reason);
    }

    private Tuple2<Object, String> checkDiskBytesWritten(UserIdentifier userIdentifier, long value, Quota quota) {
        boolean exceed = quota.diskBytesWritten() > 0L && value >= quota.diskBytesWritten();
        ObjectRef reason = ObjectRef.create((Object)"");
        if (exceed) {
            reason.elem = new StringBuilder(49).append("User ").append(userIdentifier).append(" used diskBytesWritten (").append(Utils$.MODULE$.bytesToString(value)).append(") ").append("exceeds quota (").append(Utils$.MODULE$.bytesToString(quota.diskBytesWritten())).append("). ").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)reason$1.elem);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exceed), (Object)((String)reason.elem));
    }

    private Tuple2<Object, String> checkDiskFileCount(UserIdentifier userIdentifier, long value, Quota quota) {
        boolean exceed = quota.diskFileCount() > 0L && value >= quota.diskFileCount();
        ObjectRef reason = ObjectRef.create((Object)"");
        if (exceed) {
            reason.elem = new StringBuilder(44).append("User ").append(userIdentifier).append(" used diskFileCount(").append(value).append(") exceeds quota(").append(quota.diskFileCount()).append("). ").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)reason$2.elem);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exceed), (Object)((String)reason.elem));
    }

    private Tuple2<Object, String> checkHdfsBytesWritten(UserIdentifier userIdentifier, long value, Quota quota) {
        boolean exceed = quota.hdfsBytesWritten() > 0L && value >= quota.hdfsBytesWritten();
        ObjectRef reason = ObjectRef.create((Object)"");
        if (exceed) {
            reason.elem = new StringBuilder(47).append("User ").append(userIdentifier).append(" used hdfsBytesWritten(").append(Utils$.MODULE$.bytesToString(value)).append(") ").append("exceeds quota(").append(Utils$.MODULE$.bytesToString(quota.hdfsBytesWritten())).append("). ").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)reason$3.elem);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exceed), (Object)((String)reason.elem));
    }

    private Tuple2<Object, String> checkHdfsFileCount(UserIdentifier userIdentifier, long value, Quota quota) {
        boolean exceed = quota.hdfsFileCount() > 0L && value >= quota.hdfsFileCount();
        ObjectRef reason = ObjectRef.create((Object)"");
        if (exceed) {
            reason.elem = new StringBuilder(44).append("User ").append(userIdentifier).append(" used hdfsFileCount(").append(value).append(") exceeds quota(").append(quota.hdfsFileCount()).append("). ").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)reason$4.elem);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exceed), (Object)((String)reason.elem));
    }

    public static final /* synthetic */ boolean $anonfun$checkQuotaSpaceAvailable$1(boolean x$1, Tuple2 x$2) {
        return x$1 || x$2._1$mcZ$sp();
    }

    public QuotaManager(CelebornConf celebornConf, ConfigService configService) {
        this.configService = configService;
        Logging.$init$((Logging)this);
        this.DEFAULT_QUOTA = new Quota(BoxesRunTime.unboxToLong((Object)celebornConf.get(CelebornConf$.MODULE$.QUOTA_DISK_BYTES_WRITTEN())), BoxesRunTime.unboxToLong((Object)celebornConf.get(CelebornConf$.MODULE$.QUOTA_DISK_FILE_COUNT())), BoxesRunTime.unboxToLong((Object)celebornConf.get(CelebornConf$.MODULE$.QUOTA_HDFS_BYTES_WRITTEN())), BoxesRunTime.unboxToLong((Object)celebornConf.get(CelebornConf$.MODULE$.QUOTA_HDFS_FILE_COUNT())));
    }
}

