/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta.ha;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.service.deploy.master.clustermeta.MetaUtil;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAMasterMetaManager;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HARaftServer;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MasterClusterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MetaHandler.class);
    private final HAMasterMetaManager metaSystem;

    public MetaHandler(HAMasterMetaManager metaSystem) {
        this.metaSystem = metaSystem;
    }

    public void setUpMasterRatisServer(CelebornConf conf, MasterClusterInfo masterClusterInfo) throws IOException {
        this.metaSystem.setRatisServer(HARaftServer.newMasterRatisServer(this, conf, masterClusterInfo.localNode(), masterClusterInfo.peerNodes()));
        this.metaSystem.getRatisServer().start();
    }

    public static ResourceProtos.ResourceResponse.Builder getMasterMetaResponseBuilder(ResourceProtos.ResourceRequest request) {
        return ResourceProtos.ResourceResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(ResourceProtos.Status.OK).setSuccess(true);
    }

    public ResourceProtos.ResourceResponse handleReadRequest(ResourceProtos.ResourceRequest request) {
        ResourceProtos.Type cmdType = request.getCmdType();
        ResourceProtos.ResourceResponse.Builder responseBuilder = MetaHandler.getMasterMetaResponseBuilder(request);
        try {
            switch (cmdType) {
                default: 
            }
            throw new IOException("Can not parse this command!" + request);
        }
        catch (IOException e) {
            LOG.warn("Handle meta read request {} failed!", (Object)cmdType, (Object)e);
            responseBuilder.setSuccess(false);
            responseBuilder.setStatus(ResourceProtos.Status.INTERNAL_ERROR);
            if (e.getMessage() != null) {
                responseBuilder.setMessage(e.getMessage());
            }
            return responseBuilder.build();
        }
    }

    public ResourceProtos.ResourceResponse handleWriteRequest(ResourceProtos.ResourceRequest request) {
        ResourceProtos.ResourceResponse.Builder responseBuilder;
        block19: {
            ResourceProtos.Type cmdType = request.getCmdType();
            responseBuilder = MetaHandler.getMasterMetaResponseBuilder(request);
            try {
                HashMap<String, Long> estimatedAppDiskUsage = new HashMap<String, Long>();
                switch (cmdType) {
                    case RequestSlots: {
                        String shuffleKey = request.getRequestSlotsRequest().getShuffleKey();
                        LOG.debug("Handle request slots for {}", (Object)shuffleKey);
                        this.metaSystem.updateRequestSlotsMeta(shuffleKey, request.getRequestSlotsRequest().getHostName(), new HashMap<String, Map<String, Integer>>());
                        break;
                    }
                    case ReleaseSlots: {
                        break;
                    }
                    case UnRegisterShuffle: {
                        String shuffleKey = request.getUnregisterShuffleRequest().getShuffleKey();
                        LOG.debug("Handle unregister shuffle for {}", (Object)shuffleKey);
                        this.metaSystem.updateUnregisterShuffleMeta(shuffleKey);
                        break;
                    }
                    case AppHeartbeat: {
                        String appId = request.getAppHeartbeatRequest().getAppId();
                        LOG.debug("Handle app heartbeat for {}", (Object)appId);
                        long time = request.getAppHeartbeatRequest().getTime();
                        long totalWritten = request.getAppHeartbeatRequest().getTotalWritten();
                        long fileCount = request.getAppHeartbeatRequest().getFileCount();
                        this.metaSystem.updateAppHeartbeatMeta(appId, time, totalWritten, fileCount);
                        break;
                    }
                    case AppLost: {
                        String appId = request.getAppLostRequest().getAppId();
                        LOG.debug("Handle app lost for {}", (Object)appId);
                        this.metaSystem.updateAppLostMeta(appId);
                        break;
                    }
                    case WorkerExclude: {
                        List<ResourceProtos.WorkerAddress> addAddresses = request.getWorkerExcludeRequest().getWorkersToAddList();
                        List<ResourceProtos.WorkerAddress> removeAddresses = request.getWorkerExcludeRequest().getWorkersToRemoveList();
                        List<WorkerInfo> workersToAdd = addAddresses.stream().map(MetaUtil::addrToInfo).collect(Collectors.toList());
                        List<WorkerInfo> workersToRemove = removeAddresses.stream().map(MetaUtil::addrToInfo).collect(Collectors.toList());
                        this.metaSystem.updateWorkerExcludeMeta(workersToAdd, workersToRemove);
                        break;
                    }
                    case WorkerLost: {
                        String host = request.getWorkerLostRequest().getHost();
                        int rpcPort = request.getWorkerLostRequest().getRpcPort();
                        int pushPort = request.getWorkerLostRequest().getPushPort();
                        int fetchPort = request.getWorkerLostRequest().getFetchPort();
                        int replicatePort = request.getWorkerLostRequest().getReplicatePort();
                        LOG.debug("Handle worker lost for {} {}", (Object)host, (Object)pushPort);
                        this.metaSystem.updateWorkerLostMeta(host, rpcPort, pushPort, fetchPort, replicatePort);
                        break;
                    }
                    case WorkerRemove: {
                        String host = request.getWorkerRemoveRequest().getHost();
                        int rpcPort = request.getWorkerRemoveRequest().getRpcPort();
                        int pushPort = request.getWorkerRemoveRequest().getPushPort();
                        int fetchPort = request.getWorkerRemoveRequest().getFetchPort();
                        int replicatePort = request.getWorkerRemoveRequest().getReplicatePort();
                        LOG.debug("Handle worker remove for {} {}", (Object)host, (Object)pushPort);
                        this.metaSystem.updateWorkerRemoveMeta(host, rpcPort, pushPort, fetchPort, replicatePort);
                        break;
                    }
                    case WorkerHeartbeat: {
                        String host = request.getWorkerHeartbeatRequest().getHost();
                        int rpcPort = request.getWorkerHeartbeatRequest().getRpcPort();
                        int pushPort = request.getWorkerHeartbeatRequest().getPushPort();
                        int fetchPort = request.getWorkerHeartbeatRequest().getFetchPort();
                        Map<String, DiskInfo> diskInfos = MetaUtil.fromPbDiskInfos(request.getWorkerHeartbeatRequest().getDisksMap());
                        Map<UserIdentifier, ResourceConsumption> userResourceConsumption = MetaUtil.fromPbUserResourceConsumption(request.getWorkerHeartbeatRequest().getUserResourceConsumptionMap());
                        estimatedAppDiskUsage.putAll(request.getWorkerHeartbeatRequest().getEstimatedAppDiskUsageMap());
                        int replicatePort = request.getWorkerHeartbeatRequest().getReplicatePort();
                        boolean highWorkload = request.getWorkerHeartbeatRequest().getHighWorkload();
                        WorkerStatus workerStatus = request.getWorkerHeartbeatRequest().hasWorkerStatus() ? MetaUtil.fromPbWorkerStatus(request.getWorkerHeartbeatRequest().getWorkerStatus()) : WorkerStatus.normalWorkerStatus();
                        LOG.debug("Handle worker heartbeat for {} {} {} {} {} {} {}", new Object[]{host, rpcPort, pushPort, fetchPort, replicatePort, diskInfos, userResourceConsumption});
                        this.metaSystem.updateWorkerHeartbeatMeta(host, rpcPort, pushPort, fetchPort, replicatePort, diskInfos, userResourceConsumption, estimatedAppDiskUsage, request.getWorkerHeartbeatRequest().getTime(), workerStatus, highWorkload);
                        break;
                    }
                    case RegisterWorker: {
                        String host = request.getRegisterWorkerRequest().getHost();
                        int rpcPort = request.getRegisterWorkerRequest().getRpcPort();
                        int pushPort = request.getRegisterWorkerRequest().getPushPort();
                        int fetchPort = request.getRegisterWorkerRequest().getFetchPort();
                        int replicatePort = request.getRegisterWorkerRequest().getReplicatePort();
                        String networkLocation = request.getRegisterWorkerRequest().getNetworkLocation();
                        int internalPort = request.getRegisterWorkerRequest().getInternalPort();
                        Map<String, DiskInfo> diskInfos = MetaUtil.fromPbDiskInfos(request.getRegisterWorkerRequest().getDisksMap());
                        Map<UserIdentifier, ResourceConsumption> userResourceConsumption = MetaUtil.fromPbUserResourceConsumption(request.getRegisterWorkerRequest().getUserResourceConsumptionMap());
                        LOG.debug("Handle worker register for {} {} {} {} {} {} {} {}", new Object[]{host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, diskInfos, userResourceConsumption});
                        this.metaSystem.updateRegisterWorkerMeta(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, networkLocation, diskInfos, userResourceConsumption);
                        break;
                    }
                    case ReportWorkerUnavailable: {
                        List<ResourceProtos.WorkerAddress> failedAddress = request.getReportWorkerUnavailableRequest().getUnavailableList();
                        List<WorkerInfo> failedWorkers = failedAddress.stream().map(MetaUtil::addrToInfo).collect(Collectors.toList());
                        this.metaSystem.updateMetaByReportWorkerUnavailable(failedWorkers);
                        break;
                    }
                    case UpdatePartitionSize: {
                        this.metaSystem.updatePartitionSize();
                        break;
                    }
                    case RemoveWorkersUnavailableInfo: {
                        List<ResourceProtos.WorkerAddress> unavailableList = request.getRemoveWorkersUnavailableInfoRequest().getUnavailableList();
                        List<WorkerInfo> unavailableWorkers = unavailableList.stream().map(MetaUtil::addrToInfo).collect(Collectors.toList());
                        this.metaSystem.removeWorkersUnavailableInfoMeta(unavailableWorkers);
                        break;
                    }
                    case WorkerEvent: {
                        List<ResourceProtos.WorkerAddress> workerAddresses = request.getWorkerEventRequest().getWorkerAddressList();
                        List<WorkerInfo> workerInfoList = workerAddresses.stream().map(MetaUtil::addrToInfo).collect(Collectors.toList());
                        this.metaSystem.updateWorkerEventMeta(request.getWorkerEventRequest().getWorkerEventType().getNumber(), workerInfoList);
                        break;
                    }
                    case ApplicationMeta: {
                        String appId = request.getApplicationMetaRequest().getAppId();
                        String secret = request.getApplicationMetaRequest().getSecret();
                        this.metaSystem.updateApplicationMeta(new ApplicationMeta(appId, secret));
                        break;
                    }
                    default: {
                        throw new IOException("Can not parse this command!" + request);
                    }
                }
                responseBuilder.setStatus(ResourceProtos.Status.OK);
            }
            catch (IOException e) {
                LOG.warn("Handle meta write request {} failed!", (Object)cmdType, (Object)e);
                responseBuilder.setSuccess(false);
                responseBuilder.setStatus(ResourceProtos.Status.INTERNAL_ERROR);
                if (e.getMessage() == null) break block19;
                responseBuilder.setMessage(e.getMessage());
            }
        }
        return responseBuilder.build();
    }

    public void writeToSnapShot(File file) throws IOException {
        try {
            this.metaSystem.writeMetaInfoToFile(file);
        }
        catch (RuntimeException e) {
            throw new IOException(e.getCause());
        }
    }

    public void loadSnapShot(File file) throws IOException {
        try {
            this.metaSystem.restoreMetaFromFile(file);
        }
        catch (RuntimeException e) {
            throw new IOException(e.getCause());
        }
    }
}

