/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.client.MasterClient;
import org.apache.celeborn.common.exception.CelebornRuntimeException;
import org.apache.celeborn.common.network.ssl.SSLFactory;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAHelper;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MasterNode;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MetaHandler;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.StateMachine;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class HARaftServer {
    public static final Logger LOG = LoggerFactory.getLogger(HARaftServer.class);
    public static final UUID CELEBORN_UUID = UUID.nameUUIDFromBytes("CELEBORN".getBytes(StandardCharsets.UTF_8));
    public static final RaftGroupId RAFT_GROUP_ID = RaftGroupId.valueOf((UUID)CELEBORN_UUID);
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private final MasterNode localNode;
    private final InetSocketAddress ratisAddr;
    private final String rpcEndpoint;
    private final String internalRpcEndpoint;
    private final RaftServer server;
    private final RaftGroup raftGroup;
    private final RaftPeerId raftPeerId;
    private final ClientId clientId = ClientId.randomId();
    private final MetaHandler metaHandler;
    private final StateMachine masterStateMachine;
    private final ScheduledExecutorService scheduledRoleChecker = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"master-ratis-role-checker");
    private long roleCheckIntervalMs;
    private final ReentrantReadWriteLock roleCheckLock = new ReentrantReadWriteLock();
    private Optional<RaftProtos.RaftPeerRole> cachedPeerRole = Optional.empty();
    private Optional<LeaderPeerEndpoints> cachedLeaderPeerRpcEndpoints = Optional.empty();
    private final CelebornConf conf;
    private long workerTimeoutDeadline;
    private long appTimeoutDeadline;

    static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private HARaftServer(MetaHandler metaHandler, CelebornConf conf, RaftPeerId localRaftPeerId, MasterNode localNode, List<RaftPeer> raftPeers) throws IOException {
        this.metaHandler = metaHandler;
        this.localNode = localNode;
        this.ratisAddr = localNode.ratisAddr();
        this.rpcEndpoint = localNode.rpcEndpoint();
        this.internalRpcEndpoint = localNode.internalRpcEndpoint();
        this.raftPeerId = localRaftPeerId;
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)RAFT_GROUP_ID, raftPeers);
        this.masterStateMachine = this.getStateMachine();
        this.conf = conf;
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)conf.haMasterRatisRpcType());
        RaftProperties serverProperties = this.newRaftProperties(conf, (RpcType)rpc);
        Parameters sslParameters = localNode.sslEnabled() ? this.configureSsl(conf, serverProperties, (RpcType)rpc) : null;
        this.setDeadlineTime(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.server = RaftServer.newBuilder().setServerId(this.raftPeerId).setGroup(this.raftGroup).setProperties(serverProperties).setParameters(sslParameters).setStateMachine((org.apache.ratis.statemachine.StateMachine)this.masterStateMachine).setOption(RaftStorage.StartupOption.valueOf((String)conf.haMasterRatisStorageStartupOption())).build();
        StringBuilder raftPeersStr = new StringBuilder();
        for (RaftPeer peer : raftPeers) {
            raftPeersStr.append(", ").append(peer.getAddress());
        }
        LOG.info("Ratis server started with GroupID: {} and Raft Peers: {}.", (Object)RAFT_GROUP_ID, (Object)raftPeersStr.substring(2));
        this.scheduledRoleChecker.scheduleWithFixedDelay(() -> {
            if (this.cachedPeerRole.isPresent() && this.cachedPeerRole.get() == RaftProtos.RaftPeerRole.LEADER) {
                this.updateServerRole();
            }
        }, this.roleCheckIntervalMs, this.roleCheckIntervalMs, TimeUnit.MILLISECONDS);
    }

    public static HARaftServer newMasterRatisServer(MetaHandler metaHandler, CelebornConf conf, MasterNode localNode, List<MasterNode> peerNodes) throws IOException {
        String nodeId = localNode.nodeId();
        RaftPeerId localRaftPeerId = RaftPeerId.getRaftPeerId((String)nodeId);
        InetSocketAddress ratisAddr = localNode.ratisAddr();
        RaftPeer localRaftPeer = RaftPeer.newBuilder().setId(localRaftPeerId).setAddress(ratisAddr).setClientAddress(localNode.rpcEndpoint()).setAdminAddress(localNode.internalRpcEndpoint()).build();
        ArrayList<RaftPeer> raftPeers = new ArrayList<RaftPeer>();
        raftPeers.add(localRaftPeer);
        peerNodes.forEach(peer -> {
            RaftPeer raftPeer;
            String peerNodeId = peer.nodeId();
            RaftPeerId raftPeerId = RaftPeerId.valueOf((String)peerNodeId);
            if (peer.isRatisHostUnresolved()) {
                raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peer.ratisEndpoint()).setClientAddress(peer.rpcEndpoint()).setAdminAddress(peer.internalRpcEndpoint()).build();
            } else {
                InetSocketAddress peerRatisAddr = peer.ratisAddr();
                raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peerRatisAddr).setClientAddress(peer.rpcEndpoint()).setAdminAddress(peer.internalRpcEndpoint()).build();
            }
            raftPeers.add(raftPeer);
        });
        return new HARaftServer(metaHandler, conf, localRaftPeerId, localNode, raftPeers);
    }

    public ResourceProtos.ResourceResponse submitRequest(ResourceProtos.ResourceRequest request) throws CelebornRuntimeException {
        RaftClientReply raftClientReply;
        String requestId = request.getRequestId();
        Tuple2 decoded = MasterClient.decodeRequestId((String)requestId);
        if (decoded == null) {
            throw new CelebornRuntimeException("RequestId:" + requestId + " invalid, should be: uuid#callId.");
        }
        ClientId clientId = ClientId.valueOf((UUID)UUID.fromString((String)decoded._1));
        long callId = (Long)decoded._2;
        RaftClientRequest raftClientRequest = new RaftClientRequest.Builder().setClientId(clientId).setServerId(this.server.getId()).setGroupId(RAFT_GROUP_ID).setCallId(callId).setType(RaftClientRequest.writeRequestType()).setMessage(Message.valueOf((ByteString)HAHelper.convertRequestToByteString(request))).build();
        try {
            raftClientReply = (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get();
        }
        catch (Exception ex) {
            throw new CelebornRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        if (!raftClientReply.isSuccess()) {
            RaftException exception = raftClientReply.getException();
            throw new CelebornRuntimeException(exception == null ? "Encounter raft exception." : exception.getMessage());
        }
        try {
            byte[] bytes = raftClientReply.getMessage().getContent().toByteArray();
            return ResourceProtos.ResourceResponse.newBuilder(ResourceProtos.ResourceResponse.parseFrom(bytes)).build();
        }
        catch (InvalidProtocolBufferException ex) {
            throw new CelebornRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void start() throws IOException {
        LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.ratisAddr.getPort()});
        this.server.start();
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RaftProperties newRaftProperties(CelebornConf conf, RpcType rpc) {
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpc);
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.ratisAddr.getPort());
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.ratisAddr.getPort());
        }
        String storageDir = conf.haMasterRatisStorageDir();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(new File(storageDir)));
        long raftSegmentSize = conf.haMasterRatisLogSegmentSizeMax();
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        RaftServerConfigKeys.Log.setPurgeUptoSnapshotIndex((RaftProperties)properties, (boolean)true);
        long raftSegmentPreallocatedSize = conf.haMasterRatisLogPreallocatedSize();
        long raftSegmentWriteBufferSize = conf.haMasterRatisLogWriteBufferSize();
        int logAppenderQueueNumElements = conf.haMasterRatisLogAppenderQueueNumElements();
        long logAppenderQueueByteLimit = conf.haMasterRatisLogAppenderQueueBytesLimit();
        if (raftSegmentWriteBufferSize < logAppenderQueueByteLimit + 8L) {
            throw new IllegalArgumentException(CelebornConf.HA_MASTER_RATIS_LOG_WRITE_BUFFER_SIZE().key() + " (= " + raftSegmentWriteBufferSize + ") is less than " + CelebornConf.HA_MASTER_RATIS_LOG_APPENDER_QUEUE_BYTE_LIMIT().key() + " + 8 (= " + (logAppenderQueueByteLimit + 8L) + ")");
        }
        boolean shouldInstallSnapshot = conf.haMasterRatisLogInstallSnapshotEnabled();
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentWriteBufferSize));
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)shouldInstallSnapshot);
        int logPurgeGap = conf.haMasterRatisLogPurgeGap();
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)logPurgeGap);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        TimeDuration serverRequestTimeout = TimeDuration.valueOf((long)conf.haMasterRatisRpcRequestTimeout(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)serverRequestTimeout);
        TimeDuration retryCacheExpiryTime = TimeDuration.valueOf((long)conf.haMasterRatisRetryCacheExpiryTime(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheExpiryTime);
        TimeDuration rpcTimeoutMin = TimeDuration.valueOf((long)conf.haMasterRatisRpcTimeoutMin(), (TimeUnit)TimeUnit.SECONDS);
        TimeDuration rpcTimeoutMax = TimeDuration.valueOf((long)conf.haMasterRatisRpcTimeoutMax(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)rpcTimeoutMin);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)rpcTimeoutMax);
        TimeDuration firstElectionTimeoutMin = TimeDuration.valueOf((long)conf.haMasterRatisFirstElectionTimeoutMin(), (TimeUnit)TimeUnit.SECONDS);
        TimeDuration firstElectionTimeoutMax = TimeDuration.valueOf((long)conf.haMasterRatisFirstElectionTimeoutMax(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMin((RaftProperties)properties, (TimeDuration)firstElectionTimeoutMin);
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMax((RaftProperties)properties, (TimeDuration)firstElectionTimeoutMax);
        TimeDuration clientRpcTimeout = TimeDuration.valueOf((long)conf.haMasterRatisClientRpcTimeout(), (TimeUnit)TimeUnit.SECONDS);
        TimeDuration clientRpcWatchTimeout = TimeDuration.valueOf((long)conf.haMasterRatisClientRpcWatchTimeout(), (TimeUnit)TimeUnit.SECONDS);
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)clientRpcTimeout);
        RaftClientConfigKeys.Rpc.setWatchRequestTimeout((RaftProperties)properties, (TimeDuration)clientRpcWatchTimeout);
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
        TimeDuration noLeaderTimeout = TimeDuration.valueOf((long)conf.haMasterRatisNotificationNoLeaderTimeout(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.Notification.setNoLeaderTimeout((RaftProperties)properties, (TimeDuration)noLeaderTimeout);
        TimeDuration slownessTimeout = TimeDuration.valueOf((long)conf.haMasterRatisRpcSlownessTimeout(), (TimeUnit)TimeUnit.SECONDS);
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)slownessTimeout);
        this.roleCheckIntervalMs = conf.haMasterRatisRoleCheckInterval();
        int numSnapshotRetentionFileNum = conf.haMasterRatisSnapshotRetentionFileNum();
        RaftServerConfigKeys.Snapshot.setRetentionFileNum((RaftProperties)properties, (int)numSnapshotRetentionFileNum);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)conf.haMasterRatisSnapshotAutoTriggerEnabled());
        long snapshotAutoTriggerThreshold = conf.haMasterRatisSnapshotAutoTriggerThreshold();
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)snapshotAutoTriggerThreshold);
        for (Map.Entry ratisEntry : conf.haRatisCustomConfigs().entrySet()) {
            properties.set(((String)ratisEntry.getKey()).replace("celeborn.ratis.", ""), (String)ratisEntry.getValue());
        }
        return properties;
    }

    private Parameters configureSsl(CelebornConf conf, RaftProperties properties, RpcType rpc) {
        if (rpc != SupportedRpcType.GRPC) {
            LOG.error("SSL has been disabled for Raft communication between masters. This is only supported when ratis is configured with GRPC");
            return null;
        }
        SSLFactory factory = SSLFactory.createSslFactory((TransportConf)Utils.fromCelebornConf((CelebornConf)conf, (String)"rpc_service", (int)1));
        assert (null != factory);
        assert (factory.hasKeyManagers());
        assert (!factory.getTrustManagers().isEmpty());
        TrustManager trustManager = (TrustManager)factory.getTrustManagers().get(0);
        KeyManager keyManager = (KeyManager)factory.getKeyManagers().get(0);
        Parameters params = new Parameters();
        GrpcConfigKeys.TLS.setEnabled((RaftProperties)properties, (boolean)true);
        GrpcConfigKeys.TLS.setConf((Parameters)params, (GrpcTlsConfig)new GrpcTlsConfig(keyManager, trustManager, true));
        LOG.info("SSL enabled for ratis communication between masters");
        return params;
    }

    private StateMachine getStateMachine() {
        StateMachine stateMachine = new StateMachine(this);
        stateMachine.setRaftGroupId(RAFT_GROUP_ID);
        return stateMachine;
    }

    public MetaHandler getMetaHandler() {
        return this.metaHandler;
    }

    @VisibleForTesting
    public LifeCycle.State getServerState() {
        return this.server.getLifeCycleState();
    }

    public RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    public StateMachine getMasterStateMachine() {
        return this.masterStateMachine;
    }

    private boolean checkCachedPeerRoleIsLeader() {
        this.roleCheckLock.readLock().lock();
        try {
            boolean bl = this.cachedPeerRole.isPresent() && this.cachedPeerRole.get() == RaftProtos.RaftPeerRole.LEADER;
            return bl;
        }
        finally {
            this.roleCheckLock.readLock().unlock();
        }
    }

    public boolean isLeader() {
        if (this.checkCachedPeerRoleIsLeader()) {
            return true;
        }
        this.updateServerRole();
        return this.checkCachedPeerRoleIsLeader();
    }

    public Optional<LeaderPeerEndpoints> getCachedLeaderPeerRpcEndpoint() {
        this.roleCheckLock.readLock().lock();
        try {
            Optional<LeaderPeerEndpoints> optional = this.cachedLeaderPeerRpcEndpoints;
            return optional;
        }
        finally {
            this.roleCheckLock.readLock().unlock();
        }
    }

    public void updateServerRole() {
        try {
            GroupInfoReply groupInfo = this.getGroupInfo();
            RaftProtos.RoleInfoProto roleInfoProto = groupInfo.getRoleInfoProto();
            RaftProtos.RaftPeerRole thisNodeRole = roleInfoProto.getRole();
            Tuple2 leaderPeerRpcEndpoint = null;
            Tuple2 leaderPeerInternalRpcEndpoint = null;
            if (thisNodeRole.equals((Object)RaftProtos.RaftPeerRole.LEADER)) {
                this.setServerRole(thisNodeRole, (Tuple2<String, String>)Tuple2.apply((Object)this.rpcEndpoint, (Object)this.rpcEndpoint), (Tuple2<String, String>)Tuple2.apply((Object)this.internalRpcEndpoint, (Object)this.internalRpcEndpoint));
            } else if (thisNodeRole.equals((Object)RaftProtos.RaftPeerRole.FOLLOWER)) {
                ByteString leaderNodeId = roleInfoProto.getFollowerInfo().getLeaderInfo().getId().getId();
                if (leaderNodeId != null && !leaderNodeId.isEmpty()) {
                    String clientAddress = roleInfoProto.getFollowerInfo().getLeaderInfo().getId().getClientAddress();
                    leaderPeerRpcEndpoint = Utils.addressToIpHostAddressPair((String)clientAddress);
                    if (this.conf.internalPortEnabled()) {
                        String adminAddress = roleInfoProto.getFollowerInfo().getLeaderInfo().getId().getAdminAddress();
                        leaderPeerInternalRpcEndpoint = Utils.addressToIpHostAddressPair((String)adminAddress);
                    } else {
                        leaderPeerInternalRpcEndpoint = leaderPeerRpcEndpoint;
                    }
                }
                this.setServerRole(thisNodeRole, leaderPeerRpcEndpoint, leaderPeerInternalRpcEndpoint);
            } else {
                this.setServerRole(thisNodeRole, null, null);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve RaftPeerRole. Setting cached role to {} and resetting leader info.", (Object)RaftProtos.RaftPeerRole.UNRECOGNIZED, (Object)e);
            this.setServerRole(null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerRole(RaftProtos.RaftPeerRole currentRole, Tuple2<String, String> leaderPeerRpcEndpoint, Tuple2<String, String> leaderPeerInternalRpcEndpoint) {
        this.roleCheckLock.writeLock().lock();
        try {
            boolean leaderChanged = false;
            if (RaftProtos.RaftPeerRole.LEADER == currentRole && !this.checkCachedPeerRoleIsLeader()) {
                leaderChanged = true;
                this.setDeadlineTime(this.conf.workerHeartbeatTimeout(), this.conf.appHeartbeatTimeoutMs());
            } else if (RaftProtos.RaftPeerRole.LEADER != currentRole && this.checkCachedPeerRoleIsLeader()) {
                leaderChanged = true;
                this.setDeadlineTime(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if (leaderChanged) {
                LOG.warn("Raft Role changed, CurrentNode Role: {}, Leader: {}", (Object)currentRole, leaderPeerRpcEndpoint);
            }
            this.cachedPeerRole = Optional.ofNullable(currentRole);
            this.cachedLeaderPeerRpcEndpoints = null != leaderPeerRpcEndpoint ? Optional.of(new LeaderPeerEndpoints(leaderPeerRpcEndpoint, leaderPeerInternalRpcEndpoint)) : Optional.empty();
        }
        finally {
            this.roleCheckLock.writeLock().unlock();
        }
    }

    public GroupInfoReply getGroupInfo() throws IOException {
        GroupInfoRequest groupInfoRequest = new GroupInfoRequest(this.clientId, this.raftPeerId, RAFT_GROUP_ID, HARaftServer.nextCallId());
        return this.server.getGroupInfo(groupInfoRequest);
    }

    public InetAddress getRaftAddress() {
        return this.ratisAddr.getAddress();
    }

    public int getRaftPort() {
        return this.ratisAddr.getPort();
    }

    public String getRpcEndpoint() {
        return this.rpcEndpoint;
    }

    public String getInternalRpcEndpoint() {
        return this.internalRpcEndpoint;
    }

    void stepDown() {
        try {
            TransferLeadershipRequest request = new TransferLeadershipRequest(this.clientId, this.server.getId(), this.raftGroup.getGroupId(), CallId.getAndIncrement(), null, 60000L);
            RaftClientReply reply = this.server.transferLeadership(request);
            if (reply.isSuccess()) {
                LOG.info("Successfully step down leader {}.", (Object)this.server.getId());
            } else {
                LOG.warn("Step down leader failed!");
            }
        }
        catch (Exception e) {
            LOG.warn("Step down leader failed!", (Throwable)e);
        }
    }

    public void setDeadlineTime(long increaseWorkerTime, long increaseAppTime) {
        this.workerTimeoutDeadline = System.currentTimeMillis() + increaseWorkerTime;
        this.appTimeoutDeadline = System.currentTimeMillis() + increaseAppTime;
    }

    public long getWorkerTimeoutDeadline() {
        return this.workerTimeoutDeadline;
    }

    public long getAppTimeoutDeadline() {
        return this.appTimeoutDeadline;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    public static class LeaderPeerEndpoints {
        public final Tuple2<String, String> rpcEndpoints;
        public final Tuple2<String, String> rpcInternalEndpoints;

        public LeaderPeerEndpoints(Tuple2<String, String> rpcEndpoints, Tuple2<String, String> rpcInternalEndpoints) {
            this.rpcEndpoints = rpcEndpoints;
            this.rpcInternalEndpoints = rpcInternalEndpoints;
        }
    }
}

