/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.quota.ResourceConsumption$;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u00015\u0011!bV8sW\u0016\u0014\u0018J\u001c4p\u0015\t\u0019A!\u0001\u0003nKR\f'BA\u0003\u0007\u0003\u0019\u0019w.\\7p]*\u0011q\u0001C\u0001\tG\u0016dWMY8s]*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u0015/A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"aD\u000b\n\u0005Y\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001eD\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0005Q>\u001cH/F\u0001!!\t\tCE\u0004\u0002\u0010E%\u00111\u0005E\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$!!A\u0001\u0006\u0001B\u0001B\u0003%\u0001%A\u0003i_N$\b\u0005\u0003\u0005+\u0001\t\u0015\r\u0011\"\u0001,\u0003\u001d\u0011\bo\u0019)peR,\u0012\u0001\f\t\u0003\u001f5J!A\f\t\u0003\u0007%sG\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003-\u0003!\u0011\bo\u0019)peR\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0011A,8\u000f\u001b)peRD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\naV\u001c\b\u000eU8si\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taK\u0001\nM\u0016$8\r\u001b)peRD\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000bM\u0016$8\r\u001b)peR\u0004\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u001bI,\u0007\u000f\\5dCR,\u0007k\u001c:u\u0011!a\u0004A!A!\u0002\u0013a\u0013A\u0004:fa2L7-\u0019;f!>\u0014H\u000f\t\u0005\t}\u0001\u0011)\u0019!C\u0001W\u0005a\u0011N\u001c;fe:\fG\u000eU8si\"A\u0001\t\u0001B\u0001B\u0003%A&A\u0007j]R,'O\\1m!>\u0014H\u000f\t\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\u0006Qq\fZ5tW&sgm\\:\u0011\t\u0011K\u0005eS\u0007\u0002\u000b*\u0011aiR\u0001\u0005kRLGNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%aA'baB\u0011A*T\u0007\u0002\u0005%\u0011aJ\u0001\u0002\t\t&\u001c8.\u00138g_\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\r`kN,'OU3t_V\u00148-Z\"p]N,X\u000e\u001d;j_:\u0004B\u0001R%S1B\u00111KV\u0007\u0002)*\u0011Q\u000bB\u0001\tS\u0012,g\u000e^5us&\u0011q\u000b\u0016\u0002\u000f+N,'/\u00133f]RLg-[3s!\tIF,D\u0001[\u0015\tYF!A\u0003rk>$\u0018-\u0003\u0002^5\n\u0019\"+Z:pkJ\u001cWmQ8ogVl\u0007\u000f^5p]\")q\f\u0001C\u0001A\u00061A(\u001b8jiz\"\u0012\"\u00192dI\u00164w\r[5\u0011\u00051\u0003\u0001\"\u0002\u0010_\u0001\u0004\u0001\u0003\"\u0002\u0016_\u0001\u0004a\u0003\"\u0002\u001a_\u0001\u0004a\u0003\"\u0002\u001c_\u0001\u0004a\u0003\"\u0002\u001e_\u0001\u0004a\u0003\"\u0002 _\u0001\u0004a\u0003\"\u0002\"_\u0001\u0004\u0019\u0005\"\u0002)_\u0001\u0004\t\u0006bB6\u0001\u0001\u0004%\t\u0001\\\u0001\u0010]\u0016$xo\u001c:l\u0019>\u001c\u0017\r^5p]V\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002q\u000f\u0006!A.\u00198h\u0013\t)s\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0001;\u0002'9,Go^8sW2{7-\u0019;j_:|F%Z9\u0015\u0005UD\bCA\bw\u0013\t9\bC\u0001\u0003V]&$\bbB=s\u0003\u0003\u0005\r!\\\u0001\u0004q\u0012\n\u0004BB>\u0001A\u0003&Q.\u0001\toKR<xN]6M_\u000e\fG/[8oA!9Q\u0010\u0001a\u0001\n\u0003q\u0018!\u00047bgRDU-\u0019:uE\u0016\fG/F\u0001\u0000!\ry\u0011\u0011A\u0005\u0004\u0003\u0007\u0001\"\u0001\u0002'p]\u001eD\u0011\"a\u0002\u0001\u0001\u0004%\t!!\u0003\u0002#1\f7\u000f\u001e%fCJ$(-Z1u?\u0012*\u0017\u000fF\u0002v\u0003\u0017A\u0001\"_A\u0003\u0003\u0003\u0005\ra \u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003\u0000\u00039a\u0017m\u001d;IK\u0006\u0014HOY3bi\u0002B\u0011\"a\u0005\u0001\u0001\u0004%\t!!\u0006\u0002\u0019]|'o[3s'R\fG/^:\u0016\u0005\u0005]\u0001c\u0001'\u0002\u001a%\u0019\u00111\u0004\u0002\u0003\u0019]{'o[3s'R\fG/^:\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012\u0001E<pe.,'o\u0015;biV\u001cx\fJ3r)\r)\u00181\u0005\u0005\ns\u0006u\u0011\u0011!a\u0001\u0003/A\u0001\"a\n\u0001A\u0003&\u0011qC\u0001\u000eo>\u00148.\u001a:Ti\u0006$Xo\u001d\u0011\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0012!\u00033jg.LeNZ8t+\t\ty\u0003\u0005\u0004\u00022\u0005]\u0002eS\u0007\u0003\u0003gQ1!!\u000eF\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003s\t\u0019DA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBD\u0001\"!\u0010\u0001A\u0003%\u0011qF\u0001\u000bI&\u001c8.\u00138g_N\u0004\u0003\"CA!\u0001\t\u0007I\u0011AA\"\u0003])8/\u001a:SKN|WO]2f\u0007>t7/^7qi&|g.\u0006\u0002\u0002FA1\u0011\u0011GA\u001c%bC\u0001\"!\u0013\u0001A\u0003%\u0011QI\u0001\u0019kN,'OU3t_V\u00148-Z\"p]N,X\u000e\u001d;j_:\u0004\u0003\"CA'\u0001\u0001\u0007I\u0011AA(\u0003!)g\u000e\u001a9pS:$XCAA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,\t\u0005\u0019!\u000f]2\n\t\u0005m\u0013Q\u000b\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011%\ty\u0006\u0001a\u0001\n\u0003\t\t'\u0001\u0007f]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000fF\u0002v\u0003GB\u0011\"_A/\u0003\u0003\u0005\r!!\u0015\t\u0011\u0005\u001d\u0004\u0001)Q\u0005\u0003#\n\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\t\r}\u0003A\u0011AA6)-\t\u0017QNA8\u0003c\n\u0019(!\u001e\t\ry\tI\u00071\u0001!\u0011\u0019Q\u0013\u0011\u000ea\u0001Y!1!'!\u001bA\u00021BaANA5\u0001\u0004a\u0003B\u0002\u001e\u0002j\u0001\u0007A\u0006\u0003\u0004`\u0001\u0011\u0005\u0011\u0011\u0010\u000b\u000eC\u0006m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\t\ry\t9\b1\u0001!\u0011\u0019Q\u0013q\u000fa\u0001Y!1!'a\u001eA\u00021BaANA<\u0001\u0004a\u0003B\u0002\u001e\u0002x\u0001\u0007A\u0006\u0003\u0004?\u0003o\u0002\r\u0001\f\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003!I7/Q2uSZ,WCAAG!\ry\u0011qR\u0005\u0004\u0003#\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+\u0003A\u0011AAL\u0003%)8/\u001a3TY>$8\u000fF\u0001\u0000\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000bQ\"\u00197m_\u000e\fG/Z*m_R\u001cH#B;\u0002 \u0006\r\u0006bBAQ\u00033\u0003\r\u0001I\u0001\u000bg\",hM\u001a7f\u0017\u0016L\b\u0002CAS\u00033\u0003\r!a*\u0002\u0019Mdw\u000e^:QKJ$\u0015n]6\u0011\u000b\u0011K\u0005%!+\u0011\u00079\fY+C\u0002\u0002.>\u0014q!\u00138uK\u001e,'\u000fC\u0004\u00022\u0002!\t!a-\u0002\u0019I,G.Z1tKNcw\u000e^:\u0015\u000bU\f),a.\t\u000f\u0005\u0005\u0016q\u0016a\u0001A!A\u0011\u0011XAX\u0001\u0004\t9+A\u0003tY>$8\u000fC\u0004\u00022\u0002!\t!!0\u0015\u0007U\fy\fC\u0004\u0002\"\u0006m\u0006\u0019\u0001\u0011\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006\u0001r-\u001a;TQV4g\r\\3LKf\u001cV\r^\u000b\u0003\u0003\u000f\u0004B\u0001RAeA%\u0019\u00111Z#\u0003\u000f!\u000b7\u000f[*fi\"9\u0011q\u001a\u0001\u0005\u0002\u0005\u0015\u0017aE4fi\u0006\u0003\b\u000f\\5dCRLwN\\%e'\u0016$\bbBAj\u0001\u0011\u0005\u0011Q[\u0001\u0010Q\u0006\u001c8+Y7f\u0013:4wnV5uQR!\u0011QRAl\u0011\u001d\tI.!5A\u0002\u0005\fQa\u001c;iKJDq!!8\u0001\t\u0003\ty.A\u0007tKR,\b/\u00128ea>Lg\u000e\u001e\u000b\u0004k\u0006\u0005\b\u0002CAr\u00037\u0004\r!!\u0015\u0002\u0017\u0015tG\r]8j]R\u0014VM\u001a\u0005\b\u0003O\u0004A\u0011AAu\u0003=\u0011X-\u00193bE2,\u0017\t\u001a3sKN\u001cH#\u0001\u0011\t\u000f\u00055\b\u0001\"\u0001\u0002j\u0006QAo\\+oSF,X-\u00133\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006i1\u000f\\8u\u0003Z\f\u0017\u000e\\1cY\u0016$\"!!$\t\u000f\u0005]\b\u0001\"\u0001\u0002\u0018\u0006iq-\u001a;U_R\fGn\u00157piNDq!a?\u0001\t\u0003\ti0A\bhKR<vN]6feN#\u0018\r^;t)\t\t9\u0002C\u0004\u0003\u0002\u0001!\tAa\u0001\u0002\u001fM,GoV8sW\u0016\u00148\u000b^1ukN$2!\u001eB\u0003\u0011!\t\u0019\"a@A\u0002\u0005]\u0001b\u0002B\u0005\u0001\u0011\u0005!1B\u0001\u0013kB$\u0017\r^3ESN\\W*\u0019=TY>$8\u000fF\u0002v\u0005\u001bAqAa\u0004\u0003\b\u0001\u0007q0\u0001\ffgRLW.\u0019;fIB\u000b'\u000f^5uS>t7+\u001b>f\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003/\u000b1\u0003^8uC2\fe/Y5mC\ndWm\u00157piNDqAa\u0006\u0001\t\u0003\t9*\u0001\u0006u_R\fGn\u00159bG\u0016DqAa\u0007\u0001\t\u0003\t9*\u0001\fu_R\fG.Q2uk\u0006dWk]1cY\u0016\u001c\u0006/Y2f\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\ta#\u001e9eCR,G\u000b[3o\u000f\u0016$H)[:l\u0013:4wn\u001d\u000b\u0006\u0007\n\r\"q\u0005\u0005\b\u0005K\u0011i\u00021\u0001D\u00031qWm\u001e#jg.LeNZ8t\u0011)\u0011yA!\b\u0011\u0002\u0003\u0007!\u0011\u0006\t\u0005\u001f\t-r0C\u0002\u0003.A\u0011aa\u00149uS>t\u0007b\u0002B\u0019\u0001\u0011\u0005!1G\u0001%kB$\u0017\r^3UQ\u0016tw)\u001a;Vg\u0016\u0014(+Z:pkJ\u001cWmQ8ogVl\u0007\u000f^5p]R\u0019\u0011K!\u000e\t\u000f\t]\"q\u0006a\u0001#\u0006!\"/Z:pkJ\u001cWmQ8ogVl\u0007\u000f^5p]NDqAa\u000f\u0001\t\u0003\nI/\u0001\u0005u_N#(/\u001b8h\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003\na!Z9vC2\u001cH\u0003BAG\u0005\u0007B\u0001\"!7\u0003>\u0001\u0007!Q\t\t\u0004\u001f\t\u001d\u0013b\u0001B%!\t\u0019\u0011I\\=\t\u000f\t5\u0003\u0001\"\u0011\u0003P\u0005A\u0001.Y:i\u0007>$W\rF\u0001-\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003g\f\u0001\u0002[1wK\u0012K7o\u001b\u0005\n\u0005/\u0002\u0011\u0013!C\u0001\u00053\n\u0001%\u001e9eCR,G\u000b[3o\u000f\u0016$H)[:l\u0013:4wn\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\f\u0016\u0005\u0005S\u0011if\u000b\u0002\u0003`A!!\u0011\rB6\u001b\t\u0011\u0019G\u0003\u0003\u0003f\t\u001d\u0014!C;oG\",7m[3e\u0015\r\u0011I\u0007E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B7\u0005G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u0011\tH\u0001E\u0001\u0005g\n!bV8sW\u0016\u0014\u0018J\u001c4p!\ra%Q\u000f\u0004\u0007\u0003\tA\tAa\u001e\u0014\t\tUd\u0002\u0006\u0005\b?\nUD\u0011\u0001B>)\t\u0011\u0019\b\u0003\u0005\u0003\u0000\tUD\u0011\u0001BA\u000311'o\\7V]&\fX/Z%e)\r\t'1\u0011\u0005\b\u0005\u000b\u0013i\b1\u0001!\u0003\tIG\r\u0003\u0006\u0003\n\nU\u0014\u0011!C\u0005\u0005\u0017\u000b1B]3bIJ+7o\u001c7wKR\u0011!Q\u0012\t\u0004]\n=\u0015b\u0001BI_\n1qJ\u00196fGR\u0004")
public class WorkerInfo
implements Serializable,
Logging {
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private final int internalPort;
    private String networkLocation;
    private long lastHeartbeat;
    private WorkerStatus workerStatus;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String string) {
        return WorkerInfo$.MODULE$.fromUniqueId(string);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public int internalPort() {
        return this.internalPort;
    }

    public String networkLocation() {
        return this.networkLocation;
    }

    public void networkLocation_$eq(String x$1) {
        this.networkLocation = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public WorkerStatus workerStatus() {
        return this.workerStatus;
    }

    public void workerStatus_$eq(WorkerStatus x$1) {
        this.workerStatus = x$1;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, DiskInfo> x$1) {
                return ((DiskInfo)x$1._2()).activeSlots();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)new Serializable(this, shuffleKey, slotsPerDisk){
            public static final long serialVersionUID = 0L;
            private final String shuffleKey$1;
            private final Map slotsPerDisk$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shuffle ", ", allocations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shuffleKey$1, this.slotsPerDisk$1}));
            }
            {
                this.shuffleKey$1 = shuffleKey$1;
                this.slotsPerDisk$1 = slotsPerDisk$1;
            }
        });
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1)new Serializable(this, shuffleKey){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WorkerInfo $outer;
                private final String shuffleKey$1;

                public final void apply(Tuple2<String, Integer> x0$1) {
                    Tuple2<String, Integer> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String disk = (String)tuple2._1();
                        Integer slots = (Integer)tuple2._2();
                        DiskInfo diskInfo = this.$outer.diskInfos().get(disk);
                        if (diskInfo == null) {
                            this.$outer.logDebug((Function0<String>)new Serializable(this, disk){
                                public static final long serialVersionUID = 0L;
                                private final String disk$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown disk ", " when allocateSlots"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.disk$1}));
                                }
                                {
                                    this.disk$1 = disk$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            diskInfo.allocateSlots(this.shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.shuffleKey$1 = shuffleKey$1;
                }
            });
            return;
        }
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1)new Serializable(this, shuffleKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkerInfo $outer;
            private final String shuffleKey$2;

            public final void apply(Tuple2<String, Integer> x0$2) {
                Tuple2<String, Integer> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String disk = (String)tuple2._1();
                    Integer slot = (Integer)tuple2._2();
                    if (this.$outer.diskInfos().containsKey(disk)) {
                        this.$outer.diskInfos().get(disk).releaseSlots(this.shuffleKey$2, Predef$.MODULE$.Integer2int(slot));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shuffleKey$2 = shuffleKey$2;
            }
        });
    }

    public synchronized void releaseSlots(String shuffleKey) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1)new Serializable(this, shuffleKey){
            public static final long serialVersionUID = 0L;
            private final String shuffleKey$3;

            public final void apply(Tuple2<String, DiskInfo> x$2) {
                ((DiskInfo)x$2._2()).releaseSlots(this.shuffleKey$3);
            }
            {
                this.shuffleKey$3 = shuffleKey$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public synchronized HashSet<String> getShuffleKeySet() {
        void var1_1;
        HashSet shuffleKeySet = new HashSet();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1)new Serializable(this, shuffleKeySet){
            public static final long serialVersionUID = 0L;
            private final HashSet shuffleKeySet$1;

            public final boolean apply(DiskInfo diskInfo) {
                return this.shuffleKeySet$1.addAll(diskInfo.getShuffleKeySet());
            }
            {
                this.shuffleKeySet$1 = shuffleKeySet$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized HashSet<String> getApplicationIdSet() {
        void var1_1;
        HashSet applicationIdSet = new HashSet();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1)new Serializable(this, applicationIdSet){
            public static final long serialVersionUID = 0L;
            private final HashSet applicationIdSet$1;

            public final boolean apply(DiskInfo diskInfo) {
                return this.applicationIdSet$1.addAll(diskInfo.getApplicationIdSet());
            }
            {
                this.applicationIdSet$1 = applicationIdSet$1;
            }
        });
        return var1_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        if (this.endpoint() == null) {
            this.endpoint_$eq(endpointRef);
        }
    }

    public String readableAddress() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Host:", ":RpcPort:", ":PushPort:", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.rpcPort()), BoxesRunTime.boxToInteger((int)this.pushPort())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FetchPort:", ":ReplicatePort:", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.fetchPort()), BoxesRunTime.boxToInteger((int)this.replicatePort()), BoxesRunTime.boxToInteger((int)this.internalPort())}))).toString();
    }

    public String toUniqueId() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ":", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.rpcPort()), BoxesRunTime.boxToInteger((int)this.pushPort()), BoxesRunTime.boxToInteger((int)this.fetchPort()), BoxesRunTime.boxToInteger((int)this.replicatePort())}));
    }

    public synchronized boolean slotAvailable() {
        return ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, DiskInfo> x0$3) {
                Tuple2<String, DiskInfo> tuple2 = x0$3;
                if (tuple2 != null) {
                    DiskInfo disk = (DiskInfo)tuple2._2();
                    boolean bl = disk.maxSlots() - disk.activeSlots() > 0L;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, DiskInfo> x$3) {
                return ((DiskInfo)x$3._2()).maxSlots();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public WorkerStatus getWorkerStatus() {
        return this.workerStatus();
    }

    public void setWorkerStatus(WorkerStatus workerStatus) {
        this.workerStatus_$eq(workerStatus);
    }

    public synchronized void updateDiskMaxSlots(long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1)new Serializable(this, estimatedPartitionSize){
            public static final long serialVersionUID = 0L;
            private final long estimatedPartitionSize$1;

            public final void apply(Tuple2<String, DiskInfo> x0$4) {
                Tuple2<String, DiskInfo> tuple2 = x0$4;
                if (tuple2 != null) {
                    DiskInfo disk = (DiskInfo)tuple2._2();
                    disk.maxSlots_$eq(disk.actualUsableSpace() / this.estimatedPartitionSize$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.estimatedPartitionSize$1 = estimatedPartitionSize$1;
            }
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, DiskInfo> x$4) {
                return ((DiskInfo)x$4._2()).availableSlots();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, DiskInfo> x$5) {
                return ((DiskInfo)x$5._2()).totalSpace();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalActualUsableSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, DiskInfo> x$6) {
                return ((DiskInfo)x$6._2()).actualUsableSpace();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, Option<Object> estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1)new Serializable(this, estimatedPartitionSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkerInfo $outer;
            private final Option estimatedPartitionSize$2;

            public final DiskInfo apply(DiskInfo newDisk) {
                DiskInfo diskInfo;
                String mountPoint = newDisk.mountPoint();
                DiskInfo curDisk = this.$outer.diskInfos().get(mountPoint);
                if (curDisk == null) {
                    if (this.estimatedPartitionSize$2.nonEmpty()) {
                        StorageInfo.Type type = newDisk.storageType();
                        StorageInfo.Type type2 = StorageInfo.Type.HDFS;
                        if (type == null ? type2 != null : !((Object)((Object)type)).equals((Object)((Object)type2))) {
                            newDisk.maxSlots_$eq(newDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)this.estimatedPartitionSize$2.get()));
                        }
                    }
                    diskInfo = this.$outer.diskInfos().put(mountPoint, newDisk);
                } else {
                    curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                    curDisk.totalSpace_$eq(newDisk.totalSpace());
                    curDisk.activeSlots_$eq(newDisk.activeSlots());
                    curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                    curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                    if (this.estimatedPartitionSize$2.nonEmpty()) {
                        StorageInfo.Type type = curDisk.storageType();
                        StorageInfo.Type type3 = StorageInfo.Type.HDFS;
                        if (type == null ? type3 != null : !((Object)((Object)type)).equals((Object)((Object)type3))) {
                            curDisk.maxSlots_$eq(curDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)this.estimatedPartitionSize$2.get()));
                        }
                    }
                    diskInfo = curDisk.setStatus(newDisk.status());
                }
                return diskInfo;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.estimatedPartitionSize$2 = estimatedPartitionSize$2;
            }
        });
        HashSet nonExistsMountPoints = new HashSet();
        nonExistsMountPoints.addAll(this.diskInfos().keySet());
        nonExistsMountPoints.removeAll(newDiskInfos.keySet());
        if (!nonExistsMountPoints.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WorkerInfo $outer;

                public final DiskInfo apply(String nonExistsMountPoint) {
                    return this.$outer.diskInfos().remove(nonExistsMountPoint);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return JavaUtils.newConcurrentHashMap(this.diskInfos());
    }

    public Option<Object> updateThenGetDiskInfos$default$2() {
        return None$.MODULE$;
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> resourceConsumptions) {
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.userResourceConsumption().keys()).asScala()).filterNot((Function1)new Serializable(this, resourceConsumptions){
            public static final long serialVersionUID = 0L;
            private final Map resourceConsumptions$1;

            public final boolean apply(Object x$1) {
                return this.resourceConsumptions$1.containsKey(x$1);
            }
            {
                this.resourceConsumptions$1 = resourceConsumptions$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkerInfo $outer;

            public final ResourceConsumption apply(UserIdentifier identifier) {
                return this.$outer.userResourceConsumption().put(identifier, new ResourceConsumption(0L, 0L, 0L, 0L, ResourceConsumption$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.userResourceConsumption().putAll(resourceConsumptions);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() == null) {
            tuple22 = BoxedUnit.UNIT;
        } else {
            String str = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<DiskInfo, Object> x0$5) {
                    Tuple2<DiskInfo, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        DiskInfo diskInfo = (DiskInfo)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  DiskInfo", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), diskInfo}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("");
            tuple22 = tuple2 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        }
        if (tuple2 instanceof Tuple2) {
            Tuple2 tuple23;
            Tuple2 tuple24 = tuple2;
            Object diskInfosString = tuple24._1();
            Object slots = tuple24._2();
            Tuple2 tuple25 = tuple23 = new Tuple2(diskInfosString, slots);
            Object diskInfosString2 = tuple25._1();
            Object slots2 = tuple25._2();
            String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() == null ? BoxedUnit.UNIT : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.userResourceConsumption()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<UserIdentifier, ResourceConsumption> x0$6) {
                    Tuple2<UserIdentifier, ResourceConsumption> tuple2 = x0$6;
                    if (tuple2 != null) {
                        UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                        ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  UserIdentifier: ", ", ResourceConsumption: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userIdentifier, resourceConsumption}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(""));
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |Host: ", "\n       |RpcPort: ", "\n       |PushPort: ", "\n       |FetchPort: ", "\n       |ReplicatePort: ", "\n       |InternalPort: ", "\n       |SlotsUsed: ", "\n       |LastHeartbeat: ", "\n       |HeartbeatElapsedSeconds: ", "\n       |Disks: ", "\n       |UserResourceConsumption: ", "\n       |WorkerRef: ", "\n       |WorkerStatus: ", "\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.rpcPort()), BoxesRunTime.boxToInteger((int)this.pushPort()), BoxesRunTime.boxToInteger((int)this.fetchPort()), BoxesRunTime.boxToInteger((int)this.replicatePort()), BoxesRunTime.boxToInteger((int)this.internalPort()), slots2, BoxesRunTime.boxToLong((long)this.lastHeartbeat()), BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastHeartbeat())), diskInfosString2, userResourceConsumptionString, this.endpoint(), this.workerStatus()})))).stripMargin();
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.host().hashCode();
        result = 31 * result + ((Object)BoxesRunTime.boxToInteger((int)this.rpcPort())).hashCode();
        result = 31 * result + ((Object)BoxesRunTime.boxToInteger((int)this.pushPort())).hashCode();
        result = 31 * result + ((Object)BoxesRunTime.boxToInteger((int)this.fetchPort())).hashCode();
        result = 31 * result + ((Object)BoxesRunTime.boxToInteger((int)this.replicatePort())).hashCode();
        return (int)var1_1;
    }

    public boolean haveDisk() {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(DiskInfo p) {
                StorageInfo.Type type = p.storageType();
                StorageInfo.Type type2 = StorageInfo.Type.SSD;
                if (type == null) {
                    if (type2 == null) return true;
                } else if (((Object)((Object)type)).equals((Object)((Object)type2))) return true;
                StorageInfo.Type type3 = p.storageType();
                StorageInfo.Type type4 = StorageInfo.Type.HDD;
                if (type3 != null) {
                    if (!((Object)((Object)type3)).equals((Object)((Object)type4))) return false;
                    return true;
                }
                if (type4 == null) return true;
                return false;
            }
        });
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, Map<String, DiskInfo> _diskInfos, Map<UserIdentifier, ResourceConsumption> _userResourceConsumption) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.internalPort = internalPort;
        Logging$class.$init$(this);
        this.networkLocation = "/default-rack";
        this.lastHeartbeat = 0L;
        this.workerStatus = WorkerStatus.normalWorkerStatus();
        this.diskInfos = _diskInfos == null ? null : JavaUtils.newConcurrentHashMap(_diskInfos);
        this.userResourceConsumption = _userResourceConsumption == null ? null : JavaUtils.newConcurrentHashMap(_userResourceConsumption);
        this.endpoint = null;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, -1, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }
}

