/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol.message;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbApplicationLost;
import org.apache.celeborn.common.protocol.PbApplicationLostResponse;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbApplicationMetaRequest;
import org.apache.celeborn.common.protocol.PbChangeLocationResponse;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeout;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeoutOrBuilder;
import org.apache.celeborn.common.protocol.PbCheckQuota;
import org.apache.celeborn.common.protocol.PbCheckQuotaResponse;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailable;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailableResponse;
import org.apache.celeborn.common.protocol.PbCommitFiles;
import org.apache.celeborn.common.protocol.PbCommitFilesResponse;
import org.apache.celeborn.common.protocol.PbDestroyWorkerSlots;
import org.apache.celeborn.common.protocol.PbDestroyWorkerSlotsResponse;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFileGroup;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroup;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroupResponse;
import org.apache.celeborn.common.protocol.PbGetShuffleId;
import org.apache.celeborn.common.protocol.PbGetShuffleIdResponse;
import org.apache.celeborn.common.protocol.PbHeartbeatFromApplication;
import org.apache.celeborn.common.protocol.PbHeartbeatFromApplicationResponse;
import org.apache.celeborn.common.protocol.PbHeartbeatFromWorker;
import org.apache.celeborn.common.protocol.PbHeartbeatFromWorkerResponse;
import org.apache.celeborn.common.protocol.PbMapperEnd;
import org.apache.celeborn.common.protocol.PbMapperEndResponse;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbPartitionSplit;
import org.apache.celeborn.common.protocol.PbRegisterMapPartitionTask;
import org.apache.celeborn.common.protocol.PbRegisterShuffle;
import org.apache.celeborn.common.protocol.PbRegisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbRegisterWorker;
import org.apache.celeborn.common.protocol.PbRegisterWorkerResponse;
import org.apache.celeborn.common.protocol.PbReleaseSlots;
import org.apache.celeborn.common.protocol.PbReleaseSlotsResponse;
import org.apache.celeborn.common.protocol.PbRemoveWorkersUnavailableInfo;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailure;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailureResponse;
import org.apache.celeborn.common.protocol.PbReportWorkerUnavailable;
import org.apache.celeborn.common.protocol.PbRequestSlots;
import org.apache.celeborn.common.protocol.PbRequestSlotsResponse;
import org.apache.celeborn.common.protocol.PbReserveSlots;
import org.apache.celeborn.common.protocol.PbReserveSlotsResponse;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbRevive;
import org.apache.celeborn.common.protocol.PbSlotInfo;
import org.apache.celeborn.common.protocol.PbStageEnd;
import org.apache.celeborn.common.protocol.PbStageEndResponse;
import org.apache.celeborn.common.protocol.PbStorageInfo;
import org.apache.celeborn.common.protocol.PbUnregisterShuffle;
import org.apache.celeborn.common.protocol.PbUnregisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbWorkerEventRequest;
import org.apache.celeborn.common.protocol.PbWorkerEventResponse;
import org.apache.celeborn.common.protocol.PbWorkerExclude;
import org.apache.celeborn.common.protocol.PbWorkerExcludeResponse;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerLost;
import org.apache.celeborn.common.protocol.PbWorkerLostResponse;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.WorkerEventType;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.ControlMessages$CheckForApplicationTimeOut$;
import org.apache.celeborn.common.protocol.message.ControlMessages$CheckForHDFSExpiredDirsTimeout$;
import org.apache.celeborn.common.protocol.message.ControlMessages$OneWayMessageResponse$;
import org.apache.celeborn.common.protocol.message.ControlMessages$RemoveExpiredShuffle$;
import org.apache.celeborn.common.protocol.message.ControlMessages$RequestSlotsResponse$;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.PbSerDeUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ControlMessages$
implements Logging {
    public static ControlMessages$ MODULE$;
    private final String ZERO_UUID;
    private final PbCheckForWorkerTimeout pbCheckForWorkerTimeout;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ControlMessages$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        ControlMessages$ controlMessages$ = this;
        synchronized (controlMessages$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String ZERO_UUID() {
        return this.ZERO_UUID;
    }

    public PbCheckForWorkerTimeout pbCheckForWorkerTimeout() {
        return this.pbCheckForWorkerTimeout;
    }

    public TransportMessage toTransportMessage(Object message) {
        Object object = message;
        if (object instanceof PbCheckForWorkerTimeoutOrBuilder) {
            return new TransportMessage(MessageType.CHECK_WORKER_TIMEOUT, null);
        }
        if (ControlMessages$CheckForApplicationTimeOut$.MODULE$.equals(object)) {
            return new TransportMessage(MessageType.CHECK_APPLICATION_TIMEOUT, null);
        }
        if (ControlMessages$CheckForHDFSExpiredDirsTimeout$.MODULE$.equals(object)) {
            return new TransportMessage(MessageType.CHECK_FOR_HDFS_EXPIRED_DIRS_TIMEOUT, null);
        }
        if (ControlMessages$RemoveExpiredShuffle$.MODULE$.equals(object)) {
            return new TransportMessage(MessageType.REMOVE_EXPIRED_SHUFFLE, null);
        }
        if (object instanceof PbRegisterWorker) {
            PbRegisterWorker pbRegisterWorker = (PbRegisterWorker)object;
            return new TransportMessage(MessageType.REGISTER_WORKER, pbRegisterWorker.toByteArray());
        }
        if (object instanceof PbGetShuffleId) {
            PbGetShuffleId pbGetShuffleId = (PbGetShuffleId)object;
            return new TransportMessage(MessageType.GET_SHUFFLE_ID, pbGetShuffleId.toByteArray());
        }
        if (object instanceof PbGetShuffleIdResponse) {
            PbGetShuffleIdResponse pbGetShuffleIdResponse = (PbGetShuffleIdResponse)object;
            return new TransportMessage(MessageType.GET_SHUFFLE_ID_RESPONSE, pbGetShuffleIdResponse.toByteArray());
        }
        if (object instanceof PbReportShuffleFetchFailure) {
            PbReportShuffleFetchFailure pbReportShuffleFetchFailure = (PbReportShuffleFetchFailure)object;
            return new TransportMessage(MessageType.REPORT_SHUFFLE_FETCH_FAILURE, pbReportShuffleFetchFailure.toByteArray());
        }
        if (object instanceof PbReportShuffleFetchFailureResponse) {
            PbReportShuffleFetchFailureResponse pbReportShuffleFetchFailureResponse = (PbReportShuffleFetchFailureResponse)object;
            return new TransportMessage(MessageType.REPORT_SHUFFLE_FETCH_FAILURE_RESPONSE, pbReportShuffleFetchFailureResponse.toByteArray());
        }
        if (object instanceof ControlMessages.HeartbeatFromWorker) {
            ControlMessages.HeartbeatFromWorker heartbeatFromWorker = (ControlMessages.HeartbeatFromWorker)object;
            String host = heartbeatFromWorker.host();
            int rpcPort = heartbeatFromWorker.rpcPort();
            int pushPort = heartbeatFromWorker.pushPort();
            int fetchPort = heartbeatFromWorker.fetchPort();
            int replicatePort = heartbeatFromWorker.replicatePort();
            Seq<DiskInfo> disks = heartbeatFromWorker.disks();
            Map<UserIdentifier, ResourceConsumption> userResourceConsumption = heartbeatFromWorker.userResourceConsumption();
            java.util.Set<String> activeShuffleKeys = heartbeatFromWorker.activeShuffleKeys();
            HashMap<String, Long> estimatedAppDiskUsage = heartbeatFromWorker.estimatedAppDiskUsage();
            boolean highWorkload = heartbeatFromWorker.highWorkload();
            WorkerStatus workerStatus = heartbeatFromWorker.workerStatus();
            String requestId = heartbeatFromWorker.requestId();
            java.util.List pbDisks = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)disks.map((Function1 & Serializable & scala.Serializable)diskInfo -> PbSerDeUtils$.MODULE$.toPbDiskInfo((DiskInfo)diskInfo), Seq$.MODULE$.canBuildFrom())).asJava();
            Map<String, PbResourceConsumption> pbUserResourceConsumption = PbSerDeUtils$.MODULE$.toPbUserResourceConsumption(userResourceConsumption);
            byte[] payload = PbHeartbeatFromWorker.newBuilder().setHost(host).setRpcPort(rpcPort).setPushPort(pushPort).setFetchPort(fetchPort).addAllDisks(pbDisks).putAllUserResourceConsumption(pbUserResourceConsumption).setReplicatePort(replicatePort).addAllActiveShuffleKeys(activeShuffleKeys).putAllEstimatedAppDiskUsage(estimatedAppDiskUsage).setHighWorkload(highWorkload).setWorkerStatus(PbSerDeUtils$.MODULE$.toPbWorkerStatus(workerStatus)).setRequestId(requestId).build().toByteArray();
            return new TransportMessage(MessageType.HEARTBEAT_FROM_WORKER, payload);
        }
        if (object instanceof ControlMessages.HeartbeatFromWorkerResponse) {
            ControlMessages.HeartbeatFromWorkerResponse heartbeatFromWorkerResponse = (ControlMessages.HeartbeatFromWorkerResponse)object;
            HashSet<String> expiredShuffleKeys = heartbeatFromWorkerResponse.expiredShuffleKeys();
            boolean registered = heartbeatFromWorkerResponse.registered();
            WorkerEventType workerEventType = heartbeatFromWorkerResponse.workerEvent();
            byte[] payload = PbHeartbeatFromWorkerResponse.newBuilder().addAllExpiredShuffleKeys(expiredShuffleKeys).setRegistered(registered).setWorkerEventType(workerEventType).build().toByteArray();
            return new TransportMessage(MessageType.HEARTBEAT_FROM_WORKER_RESPONSE, payload);
        }
        if (object instanceof PbRegisterShuffle) {
            PbRegisterShuffle pbRegisterShuffle = (PbRegisterShuffle)object;
            return new TransportMessage(MessageType.REGISTER_SHUFFLE, pbRegisterShuffle.toByteArray());
        }
        if (object instanceof PbRegisterMapPartitionTask) {
            PbRegisterMapPartitionTask pbRegisterMapPartitionTask = (PbRegisterMapPartitionTask)object;
            return new TransportMessage(MessageType.REGISTER_MAP_PARTITION_TASK, pbRegisterMapPartitionTask.toByteArray());
        }
        if (object instanceof PbRegisterShuffleResponse) {
            PbRegisterShuffleResponse pbRegisterShuffleResponse = (PbRegisterShuffleResponse)object;
            return new TransportMessage(MessageType.REGISTER_SHUFFLE_RESPONSE, pbRegisterShuffleResponse.toByteArray());
        }
        if (object instanceof ControlMessages.RequestSlots) {
            ControlMessages.RequestSlots requestSlots = (ControlMessages.RequestSlots)object;
            String applicationId = requestSlots.applicationId();
            int shuffleId = requestSlots.shuffleId();
            ArrayList<Integer> partitionIdList = requestSlots.partitionIdList();
            String hostname = requestSlots.hostname();
            boolean shouldReplicate = requestSlots.shouldReplicate();
            boolean shouldRackAware = requestSlots.shouldRackAware();
            UserIdentifier userIdentifier = requestSlots.userIdentifier();
            int maxWorkers = requestSlots.maxWorkers();
            int availableStorageTypes = requestSlots.availableStorageTypes();
            scala.collection.immutable.Set<WorkerInfo> excludedWorkerSet = requestSlots.excludedWorkerSet();
            boolean packed = requestSlots.packed();
            String requestId = requestSlots.requestId();
            byte[] payload = PbRequestSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPartitionIdList(partitionIdList).setHostname(hostname).setShouldReplicate(shouldReplicate).setShouldRackAware(shouldRackAware).setMaxWorkers(maxWorkers).setRequestId(requestId).setAvailableStorageTypes(availableStorageTypes).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).addAllExcludedWorkerSet((Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)excludedWorkerSet.map((Function1 & Serializable & scala.Serializable)x$1 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$1, true, true), Set$.MODULE$.canBuildFrom())).asJava()).setPacked(packed).build().toByteArray();
            return new TransportMessage(MessageType.REQUEST_SLOTS, payload);
        }
        if (object instanceof ControlMessages.ReleaseSlots) {
            ControlMessages.ReleaseSlots releaseSlots = (ControlMessages.ReleaseSlots)object;
            String applicationId = releaseSlots.applicationId();
            int shuffleId = releaseSlots.shuffleId();
            java.util.List<String> workerIds = releaseSlots.workerIds();
            java.util.List<Map<String, Integer>> slots = releaseSlots.slots();
            String requestId = releaseSlots.requestId();
            List pbSlots = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(slots).asScala()).map((Function1 & Serializable & scala.Serializable)slot -> PbSlotInfo.newBuilder().putAllSlot((Map<String, Integer>)slot).build(), Buffer$.MODULE$.canBuildFrom())).toList();
            byte[] payload = PbReleaseSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).setRequestId(requestId).addAllWorkerIds(workerIds).addAllSlots((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pbSlots).asJava()).build().toByteArray();
            return new TransportMessage(MessageType.RELEASE_SLOTS, payload);
        }
        if (object instanceof ControlMessages.ReleaseSlotsResponse) {
            ControlMessages.ReleaseSlotsResponse releaseSlotsResponse = (ControlMessages.ReleaseSlotsResponse)object;
            StatusCode status = releaseSlotsResponse.status();
            byte[] payload = PbReleaseSlotsResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            return new TransportMessage(MessageType.RELEASE_SLOTS_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.RequestSlotsResponse) {
            ControlMessages.RequestSlotsResponse requestSlotsResponse = (ControlMessages.RequestSlotsResponse)object;
            StatusCode status = requestSlotsResponse.status();
            HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource = requestSlotsResponse.workerResource();
            boolean packed = requestSlotsResponse.packed();
            PbRequestSlotsResponse.Builder builder = PbRequestSlotsResponse.newBuilder().setStatus(status.getValue());
            Object object2 = !workerResource.isEmpty() ? (packed ? builder.putAllPackedWorkerResource(PbSerDeUtils$.MODULE$.toPbPackedWorkerResource(workerResource)) : builder.putAllWorkerResource(PbSerDeUtils$.MODULE$.toPbWorkerResource(workerResource))) : BoxedUnit.UNIT;
            byte[] payload = builder.build().toByteArray();
            return new TransportMessage(MessageType.REQUEST_SLOTS_RESPONSE, payload);
        }
        if (object instanceof PbRevive) {
            PbRevive pbRevive = (PbRevive)object;
            return new TransportMessage(MessageType.CHANGE_LOCATION, pbRevive.toByteArray());
        }
        if (object instanceof PbChangeLocationResponse) {
            PbChangeLocationResponse pbChangeLocationResponse = (PbChangeLocationResponse)object;
            return new TransportMessage(MessageType.CHANGE_LOCATION_RESPONSE, pbChangeLocationResponse.toByteArray());
        }
        if (object instanceof ControlMessages.MapperEnd) {
            ControlMessages.MapperEnd mapperEnd = (ControlMessages.MapperEnd)object;
            int shuffleId = mapperEnd.shuffleId();
            int mapId = mapperEnd.mapId();
            int attemptId = mapperEnd.attemptId();
            int numMappers = mapperEnd.numMappers();
            int partitionId = mapperEnd.partitionId();
            byte[] payload = PbMapperEnd.newBuilder().setShuffleId(shuffleId).setMapId(mapId).setAttemptId(attemptId).setNumMappers(numMappers).setPartitionId(partitionId).build().toByteArray();
            return new TransportMessage(MessageType.MAPPER_END, payload);
        }
        if (object instanceof ControlMessages.MapperEndResponse) {
            ControlMessages.MapperEndResponse mapperEndResponse = (ControlMessages.MapperEndResponse)object;
            StatusCode status = mapperEndResponse.status();
            byte[] payload = PbMapperEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            return new TransportMessage(MessageType.MAPPER_END_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.GetReducerFileGroup) {
            ControlMessages.GetReducerFileGroup getReducerFileGroup = (ControlMessages.GetReducerFileGroup)object;
            int shuffleId = getReducerFileGroup.shuffleId();
            byte[] payload = PbGetReducerFileGroup.newBuilder().setShuffleId(shuffleId).build().toByteArray();
            return new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP, payload);
        }
        if (object instanceof ControlMessages.GetReducerFileGroupResponse) {
            ControlMessages.GetReducerFileGroupResponse getReducerFileGroupResponse = (ControlMessages.GetReducerFileGroupResponse)object;
            StatusCode status = getReducerFileGroupResponse.status();
            Map<Integer, java.util.Set<PartitionLocation>> fileGroup = getReducerFileGroupResponse.fileGroup();
            int[] attempts = getReducerFileGroupResponse.attempts();
            java.util.Set<Integer> partitionIds = getReducerFileGroupResponse.partitionIds();
            PbGetReducerFileGroupResponse.Builder builder = PbGetReducerFileGroupResponse.newBuilder().setStatus(status.getValue());
            builder.putAllFileGroups((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileGroup).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Integer partitionId = (Integer)tuple2._1();
                    java.util.Set fileGroup = (java.util.Set)tuple2._2();
                    PbFileGroup.Builder pbFileGroupBuilder = PbFileGroup.newBuilder();
                    pbFileGroupBuilder.setPartitionLocationsPair(PbSerDeUtils$.MODULE$.toPbPackedPartitionLocationsPair((List<PartitionLocation>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(fileGroup).asScala()).toList()));
                    return new Tuple2((Object)partitionId, (Object)pbFileGroupBuilder.build());
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom())).asJava());
            builder.addAllAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(attempts)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava());
            builder.addAllPartitionIds(partitionIds);
            byte[] payload = builder.build().toByteArray();
            return new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP_RESPONSE, payload);
        }
        if (object instanceof PbWorkerExclude) {
            PbWorkerExclude pbWorkerExclude = (PbWorkerExclude)object;
            return new TransportMessage(MessageType.WORKER_EXCLUDE, pbWorkerExclude.toByteArray());
        }
        if (object instanceof PbWorkerExcludeResponse) {
            PbWorkerExcludeResponse pbWorkerExcludeResponse = (PbWorkerExcludeResponse)object;
            return new TransportMessage(MessageType.WORKER_EXCLUDE_RESPONSE, pbWorkerExcludeResponse.toByteArray());
        }
        if (object instanceof PbWorkerLost) {
            PbWorkerLost pbWorkerLost = (PbWorkerLost)object;
            return new TransportMessage(MessageType.WORKER_LOST, pbWorkerLost.toByteArray());
        }
        if (object instanceof PbWorkerLostResponse) {
            PbWorkerLostResponse pbWorkerLostResponse = (PbWorkerLostResponse)object;
            return new TransportMessage(MessageType.WORKER_LOST_RESPONSE, pbWorkerLostResponse.toByteArray());
        }
        if (object instanceof ControlMessages.StageEnd) {
            ControlMessages.StageEnd stageEnd = (ControlMessages.StageEnd)object;
            int shuffleId = stageEnd.shuffleId();
            byte[] payload = PbStageEnd.newBuilder().setShuffleId(shuffleId).build().toByteArray();
            return new TransportMessage(MessageType.STAGE_END, payload);
        }
        if (object instanceof ControlMessages.StageEndResponse) {
            ControlMessages.StageEndResponse stageEndResponse = (ControlMessages.StageEndResponse)object;
            StatusCode status = stageEndResponse.status();
            byte[] payload = PbStageEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            return new TransportMessage(MessageType.STAGE_END_RESPONSE, payload);
        }
        if (object instanceof PbUnregisterShuffle) {
            PbUnregisterShuffle pbUnregisterShuffle = (PbUnregisterShuffle)object;
            return new TransportMessage(MessageType.UNREGISTER_SHUFFLE, pbUnregisterShuffle.toByteArray());
        }
        if (object instanceof PbUnregisterShuffleResponse) {
            PbUnregisterShuffleResponse pbUnregisterShuffleResponse = (PbUnregisterShuffleResponse)object;
            return new TransportMessage(MessageType.UNREGISTER_SHUFFLE_RESPONSE, pbUnregisterShuffleResponse.toByteArray());
        }
        if (object instanceof ControlMessages.ApplicationLost) {
            ControlMessages.ApplicationLost applicationLost = (ControlMessages.ApplicationLost)object;
            String appId = applicationLost.appId();
            String requestId = applicationLost.requestId();
            byte[] payload = PbApplicationLost.newBuilder().setAppId(appId).setRequestId(requestId).build().toByteArray();
            return new TransportMessage(MessageType.APPLICATION_LOST, payload);
        }
        if (object instanceof ControlMessages.ApplicationLostResponse) {
            ControlMessages.ApplicationLostResponse applicationLostResponse = (ControlMessages.ApplicationLostResponse)object;
            StatusCode status = applicationLostResponse.status();
            byte[] payload = PbApplicationLostResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            return new TransportMessage(MessageType.APPLICATION_LOST_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.HeartbeatFromApplication) {
            ControlMessages.HeartbeatFromApplication heartbeatFromApplication = (ControlMessages.HeartbeatFromApplication)object;
            String appId = heartbeatFromApplication.appId();
            long totalWritten = heartbeatFromApplication.totalWritten();
            long fileCount = heartbeatFromApplication.fileCount();
            java.util.List<WorkerInfo> needCheckedWorkerList = heartbeatFromApplication.needCheckedWorkerList();
            String requestId = heartbeatFromApplication.requestId();
            boolean shouldResponse = heartbeatFromApplication.shouldResponse();
            byte[] payload = PbHeartbeatFromApplication.newBuilder().setAppId(appId).setRequestId(requestId).setTotalWritten(totalWritten).setFileCount(fileCount).addAllNeedCheckedWorkerList((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(needCheckedWorkerList).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$2, true, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setShouldResponse(shouldResponse).build().toByteArray();
            return new TransportMessage(MessageType.HEARTBEAT_FROM_APPLICATION, payload);
        }
        if (object instanceof ControlMessages.HeartbeatFromApplicationResponse) {
            ControlMessages.HeartbeatFromApplicationResponse heartbeatFromApplicationResponse = (ControlMessages.HeartbeatFromApplicationResponse)object;
            StatusCode statusCode = heartbeatFromApplicationResponse.statusCode();
            java.util.List<WorkerInfo> excludedWorkers = heartbeatFromApplicationResponse.excludedWorkers();
            java.util.List<WorkerInfo> unknownWorkers = heartbeatFromApplicationResponse.unknownWorkers();
            java.util.List<WorkerInfo> shuttingWorkers = heartbeatFromApplicationResponse.shuttingWorkers();
            byte[] payload = PbHeartbeatFromApplicationResponse.newBuilder().setStatus(statusCode.getValue()).addAllExcludedWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$3, true, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllUnknownWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(unknownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$4, true, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllShuttingWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(shuttingWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$5, true, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).build().toByteArray();
            return new TransportMessage(MessageType.HEARTBEAT_FROM_APPLICATION_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.CheckQuota) {
            ControlMessages.CheckQuota checkQuota = (ControlMessages.CheckQuota)object;
            UserIdentifier userIdentifier = checkQuota.userIdentifier();
            PbCheckQuota.Builder builder = PbCheckQuota.newBuilder().setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier));
            return new TransportMessage(MessageType.CHECK_QUOTA, builder.build().toByteArray());
        }
        if (object instanceof ControlMessages.CheckQuotaResponse) {
            ControlMessages.CheckQuotaResponse checkQuotaResponse = (ControlMessages.CheckQuotaResponse)object;
            boolean available = checkQuotaResponse.isAvailable();
            String reason = checkQuotaResponse.reason();
            byte[] payload = PbCheckQuotaResponse.newBuilder().setAvailable(available).setReason(reason).build().toByteArray();
            return new TransportMessage(MessageType.CHECK_QUOTA_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.ReportWorkerUnavailable) {
            ControlMessages.ReportWorkerUnavailable reportWorkerUnavailable = (ControlMessages.ReportWorkerUnavailable)object;
            java.util.List<WorkerInfo> failed = reportWorkerUnavailable.unavailable();
            String requestId = reportWorkerUnavailable.requestId();
            byte[] payload = PbReportWorkerUnavailable.newBuilder().addAllUnavailable((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(failed).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true, false), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setRequestId(requestId).build().toByteArray();
            return new TransportMessage(MessageType.REPORT_WORKER_FAILURE, payload);
        }
        if (object instanceof PbRemoveWorkersUnavailableInfo) {
            PbRemoveWorkersUnavailableInfo pbRemoveWorkersUnavailableInfo = (PbRemoveWorkersUnavailableInfo)object;
            return new TransportMessage(MessageType.REMOVE_WORKERS_UNAVAILABLE_INFO, pbRemoveWorkersUnavailableInfo.toByteArray());
        }
        if (object instanceof PbWorkerEventRequest) {
            PbWorkerEventRequest pbWorkerEventRequest = (PbWorkerEventRequest)object;
            return new TransportMessage(MessageType.WORKER_EVENT_REQUEST, pbWorkerEventRequest.toByteArray());
        }
        if (object instanceof PbWorkerEventResponse) {
            PbWorkerEventResponse pbWorkerEventResponse = (PbWorkerEventResponse)object;
            return new TransportMessage(MessageType.WORKER_EVENT_RESPONSE, pbWorkerEventResponse.toByteArray());
        }
        if (object instanceof PbRegisterWorkerResponse) {
            PbRegisterWorkerResponse pbRegisterWorkerResponse = (PbRegisterWorkerResponse)object;
            return new TransportMessage(MessageType.REGISTER_WORKER_RESPONSE, pbRegisterWorkerResponse.toByteArray());
        }
        if (object instanceof ControlMessages.ReserveSlots) {
            ControlMessages.ReserveSlots reserveSlots = (ControlMessages.ReserveSlots)object;
            String applicationId = reserveSlots.applicationId();
            int shuffleId = reserveSlots.shuffleId();
            java.util.List<PartitionLocation> primaryLocations = reserveSlots.primaryLocations();
            java.util.List<PartitionLocation> replicaLocations = reserveSlots.replicaLocations();
            long splitThreshold = reserveSlots.splitThreshold();
            PartitionSplitMode splitMode = reserveSlots.splitMode();
            PartitionType partType = reserveSlots.partitionType();
            boolean rangeReadFilter = reserveSlots.rangeReadFilter();
            UserIdentifier userIdentifier = reserveSlots.userIdentifier();
            long pushDataTimeout = reserveSlots.pushDataTimeout();
            boolean partitionSplitEnabled = reserveSlots.partitionSplitEnabled();
            byte[] payload = PbReserveSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).setPartitionLocationsPair(PbSerDeUtils$.MODULE$.toPbPackedPartitionLocationsPair((List<PartitionLocation>)((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).toList().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).toList(), List$.MODULE$.canBuildFrom())))).setSplitThreshold(splitThreshold).setSplitMode(splitMode.getValue()).setPartitionType(partType.getValue()).setRangeReadFilter(rangeReadFilter).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).setPushDataTimeout(pushDataTimeout).setPartitionSplitEnabled(partitionSplitEnabled).build().toByteArray();
            return new TransportMessage(MessageType.RESERVE_SLOTS, payload);
        }
        if (object instanceof ControlMessages.ReserveSlotsResponse) {
            ControlMessages.ReserveSlotsResponse reserveSlotsResponse = (ControlMessages.ReserveSlotsResponse)object;
            StatusCode status = reserveSlotsResponse.status();
            String reason = reserveSlotsResponse.reason();
            byte[] payload = PbReserveSlotsResponse.newBuilder().setStatus(status.getValue()).setReason(reason).build().toByteArray();
            return new TransportMessage(MessageType.RESERVE_SLOTS_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.CommitFiles) {
            ControlMessages.CommitFiles commitFiles = (ControlMessages.CommitFiles)object;
            String applicationId = commitFiles.applicationId();
            int shuffleId = commitFiles.shuffleId();
            java.util.List<String> primaryIds = commitFiles.primaryIds();
            java.util.List<String> replicaIds = commitFiles.replicaIds();
            int[] mapAttempts = commitFiles.mapAttempts();
            long epoch = commitFiles.epoch();
            boolean mockFailure = commitFiles.mockFailure();
            byte[] payload = PbCommitFiles.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPrimaryIds(primaryIds).addAllReplicaIds(replicaIds).addAllMapAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapAttempts)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava()).setEpoch(epoch).setMockFailure(mockFailure).build().toByteArray();
            return new TransportMessage(MessageType.COMMIT_FILES, payload);
        }
        if (object instanceof ControlMessages.CommitFilesResponse) {
            ControlMessages.CommitFilesResponse commitFilesResponse = (ControlMessages.CommitFilesResponse)object;
            StatusCode status = commitFilesResponse.status();
            java.util.List<String> committedPrimaryIds = commitFilesResponse.committedPrimaryIds();
            java.util.List<String> committedReplicaIds = commitFilesResponse.committedReplicaIds();
            java.util.List<String> failedPrimaryIds = commitFilesResponse.failedPrimaryIds();
            java.util.List<String> failedReplicaIds = commitFilesResponse.failedReplicaIds();
            Map<String, StorageInfo> committedPrimaryStorageInfos = commitFilesResponse.committedPrimaryStorageInfos();
            Map<String, StorageInfo> committedReplicaStorageInfos = commitFilesResponse.committedReplicaStorageInfos();
            Map<String, RoaringBitmap> committedMapIdBitMap = commitFilesResponse.committedMapIdBitMap();
            long totalWritten = commitFilesResponse.totalWritten();
            int fileCount = commitFilesResponse.fileCount();
            PbCommitFilesResponse.Builder builder = PbCommitFilesResponse.newBuilder().setStatus(status.getValue());
            builder.addAllCommittedPrimaryIds(committedPrimaryIds);
            builder.addAllCommittedReplicaIds(committedReplicaIds);
            builder.addAllFailedPrimaryIds(failedPrimaryIds);
            builder.addAllFailedReplicaIds(failedReplicaIds);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedPrimaryStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedPrimaryStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedReplicaStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedReplicaStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedMapIdBitMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putMapIdBitmap((String)entry._1(), Utils$.MODULE$.roaringBitmapToByteString((RoaringBitmap)entry._2())));
            builder.setTotalWritten(totalWritten);
            builder.setFileCount(fileCount);
            byte[] payload = builder.build().toByteArray();
            return new TransportMessage(MessageType.COMMIT_FILES_RESPONSE, payload);
        }
        if (object instanceof ControlMessages.DestroyWorkerSlots) {
            ControlMessages.DestroyWorkerSlots destroyWorkerSlots = (ControlMessages.DestroyWorkerSlots)object;
            String shuffleKey = destroyWorkerSlots.shuffleKey();
            java.util.List<String> primaryLocations = destroyWorkerSlots.primaryLocations();
            java.util.List<String> replicaLocations = destroyWorkerSlots.replicaLocations();
            boolean mockFailure = destroyWorkerSlots.mockFailure();
            byte[] payload = PbDestroyWorkerSlots.newBuilder().setShuffleKey(shuffleKey).addAllPrimaryLocations(primaryLocations).addAllReplicaLocation(replicaLocations).setMockFailure(mockFailure).build().toByteArray();
            return new TransportMessage(MessageType.DESTROY, payload);
        }
        if (object instanceof ControlMessages.DestroyWorkerSlotsResponse) {
            ControlMessages.DestroyWorkerSlotsResponse destroyWorkerSlotsResponse = (ControlMessages.DestroyWorkerSlotsResponse)object;
            StatusCode status = destroyWorkerSlotsResponse.status();
            java.util.List<String> failedPrimaries = destroyWorkerSlotsResponse.failedPrimarys();
            java.util.List<String> failedReplicas = destroyWorkerSlotsResponse.failedReplicas();
            PbDestroyWorkerSlotsResponse.Builder builder = PbDestroyWorkerSlotsResponse.newBuilder().setStatus(status.getValue());
            builder.addAllFailedPrimaries(failedPrimaries);
            builder.addAllFailedReplicas(failedReplicas);
            byte[] payload = builder.build().toByteArray();
            return new TransportMessage(MessageType.DESTROY_RESPONSE, payload);
        }
        if (object instanceof PbPartitionSplit) {
            PbPartitionSplit pbPartitionSplit = (PbPartitionSplit)object;
            return new TransportMessage(MessageType.PARTITION_SPLIT, pbPartitionSplit.toByteArray());
        }
        if (ControlMessages$OneWayMessageResponse$.MODULE$.equals(object)) {
            return new TransportMessage(MessageType.ONE_WAY_MESSAGE_RESPONSE, null);
        }
        if (object instanceof PbCheckWorkersAvailable) {
            PbCheckWorkersAvailable pbCheckWorkersAvailable = (PbCheckWorkersAvailable)object;
            return new TransportMessage(MessageType.CHECK_WORKERS_AVAILABLE, pbCheckWorkersAvailable.toByteArray());
        }
        if (object instanceof PbCheckWorkersAvailableResponse) {
            PbCheckWorkersAvailableResponse pbCheckWorkersAvailableResponse = (PbCheckWorkersAvailableResponse)object;
            return new TransportMessage(MessageType.CHECK_WORKERS_AVAILABLE_RESPONSE, pbCheckWorkersAvailableResponse.toByteArray());
        }
        if (object instanceof PbApplicationMeta) {
            PbApplicationMeta pbApplicationMeta = (PbApplicationMeta)object;
            return new TransportMessage(MessageType.APPLICATION_META, pbApplicationMeta.toByteArray());
        }
        if (object instanceof PbApplicationMetaRequest) {
            PbApplicationMetaRequest pbApplicationMetaRequest = (PbApplicationMetaRequest)object;
            return new TransportMessage(MessageType.APPLICATION_META_REQUEST, pbApplicationMetaRequest.toByteArray());
        }
        throw new MatchError(object);
    }

    public Object fromTransportMessage(TransportMessage message) {
        int messageTypeValue;
        int n;
        int n2 = message.getMessageTypeValue();
        switch (n2) {
            case 0: {
                n = message.getType().getNumber();
                break;
            }
            default: {
                n = message.getMessageTypeValue();
                break;
            }
        }
        int n3 = messageTypeValue = n;
        switch (n3) {
            case 0: {
                String msg = new StringBuilder(25).append("received unknown message ").append(message).toString();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new UnsupportedOperationException(msg);
            }
            case 7: {
                PbReleaseSlots pbReleaseSlots = PbReleaseSlots.parseFrom(message.getPayload());
                java.util.List slotsList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReleaseSlots.getSlotsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbSlot -> new HashMap<String, Integer>(pbSlot.getSlotMap()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
                return new ControlMessages.ReleaseSlots(pbReleaseSlots.getApplicationId(), pbReleaseSlots.getShuffleId(), new ArrayList<String>((Collection<String>)pbReleaseSlots.getWorkerIdsList()), new ArrayList<Map<String, Integer>>(slotsList), pbReleaseSlots.getRequestId());
            }
            case 8: {
                PbReleaseSlotsResponse pbReleaseSlotsResponse = PbReleaseSlotsResponse.parseFrom(message.getPayload());
                return new ControlMessages.ReleaseSlotsResponse(Utils$.MODULE$.toStatusCode(pbReleaseSlotsResponse.getStatus()));
            }
            case 1: {
                return PbRegisterWorker.parseFrom(message.getPayload());
            }
            case 2: {
                PbHeartbeatFromWorker pbHeartbeatFromWorker = PbHeartbeatFromWorker.parseFrom(message.getPayload());
                HashMap<String, Long> estimatedAppDiskUsage = new HashMap<String, Long>();
                Map<UserIdentifier, ResourceConsumption> userResourceConsumption = PbSerDeUtils$.MODULE$.fromPbUserResourceConsumption(pbHeartbeatFromWorker.getUserResourceConsumptionMap());
                Seq pbDisks = (Seq)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromWorker.getDisksList()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)pbDiskInfo -> PbSerDeUtils$.MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo), Seq$.MODULE$.canBuildFrom());
                if (!pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap().isEmpty()) {
                    estimatedAppDiskUsage.putAll(pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap());
                }
                HashSet<String> activeShuffleKeys = new HashSet<String>();
                Object object = !pbHeartbeatFromWorker.getActiveShuffleKeysList().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)activeShuffleKeys.addAll((Collection<String>)pbHeartbeatFromWorker.getActiveShuffleKeysList())) : BoxedUnit.UNIT;
                WorkerStatus workerStatus = PbSerDeUtils$.MODULE$.fromPbWorkerStatus(pbHeartbeatFromWorker.getWorkerStatus());
                return new ControlMessages.HeartbeatFromWorker(pbHeartbeatFromWorker.getHost(), pbHeartbeatFromWorker.getRpcPort(), pbHeartbeatFromWorker.getPushPort(), pbHeartbeatFromWorker.getFetchPort(), pbHeartbeatFromWorker.getReplicatePort(), (Seq<DiskInfo>)pbDisks, userResourceConsumption, activeShuffleKeys, estimatedAppDiskUsage, pbHeartbeatFromWorker.getHighWorkload(), workerStatus, pbHeartbeatFromWorker.getRequestId());
            }
            case 3: {
                PbHeartbeatFromWorkerResponse pbHeartbeatFromWorkerResponse = PbHeartbeatFromWorkerResponse.parseFrom(message.getPayload());
                HashSet<String> expiredShuffleKeys = new HashSet<String>();
                Object object = pbHeartbeatFromWorkerResponse.getExpiredShuffleKeysCount() > 0 ? BoxesRunTime.boxToBoolean((boolean)expiredShuffleKeys.addAll((Collection<String>)pbHeartbeatFromWorkerResponse.getExpiredShuffleKeysList())) : BoxedUnit.UNIT;
                return new ControlMessages.HeartbeatFromWorkerResponse(expiredShuffleKeys, pbHeartbeatFromWorkerResponse.getRegistered(), pbHeartbeatFromWorkerResponse.getWorkerEventType());
            }
            case 4: {
                return PbRegisterShuffle.parseFrom(message.getPayload());
            }
            case 48: {
                return PbRegisterMapPartitionTask.parseFrom(message.getPayload());
            }
            case 5: {
                return PbRegisterShuffleResponse.parseFrom(message.getPayload());
            }
            case 6: {
                PbRequestSlots pbRequestSlots = PbRequestSlots.parseFrom(message.getPayload());
                UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbRequestSlots.getUserIdentifier());
                scala.collection.immutable.Set excludedWorkerInfoSet = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbRequestSlots.getExcludedWorkerSetList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toSet();
                return new ControlMessages.RequestSlots(pbRequestSlots.getApplicationId(), pbRequestSlots.getShuffleId(), new ArrayList<Integer>(pbRequestSlots.getPartitionIdListList()), pbRequestSlots.getHostname(), pbRequestSlots.getShouldReplicate(), pbRequestSlots.getShouldRackAware(), userIdentifier, pbRequestSlots.getMaxWorkers(), pbRequestSlots.getAvailableStorageTypes(), (scala.collection.immutable.Set<WorkerInfo>)excludedWorkerInfoSet, pbRequestSlots.getPacked(), pbRequestSlots.getRequestId());
            }
            case 9: {
                PbRequestSlotsResponse pbRequestSlotsResponse = PbRequestSlotsResponse.parseFrom(message.getPayload());
                HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource = pbRequestSlotsResponse.getWorkerResourceMap().isEmpty() ? PbSerDeUtils$.MODULE$.fromPbPackedWorkerResource(pbRequestSlotsResponse.getPackedWorkerResourceMap()) : PbSerDeUtils$.MODULE$.fromPbWorkerResource(pbRequestSlotsResponse.getWorkerResourceMap());
                return new ControlMessages.RequestSlotsResponse(Utils$.MODULE$.toStatusCode(pbRequestSlotsResponse.getStatus()), workerResource, ControlMessages$RequestSlotsResponse$.MODULE$.apply$default$3());
            }
            case 10: {
                return PbRevive.parseFrom(message.getPayload());
            }
            case 11: {
                return PbChangeLocationResponse.parseFrom(message.getPayload());
            }
            case 12: {
                PbMapperEnd pbMapperEnd = PbMapperEnd.parseFrom(message.getPayload());
                return new ControlMessages.MapperEnd(pbMapperEnd.getShuffleId(), pbMapperEnd.getMapId(), pbMapperEnd.getAttemptId(), pbMapperEnd.getNumMappers(), pbMapperEnd.getPartitionId());
            }
            case 13: {
                PbMapperEndResponse pbMapperEndResponse = PbMapperEndResponse.parseFrom(message.getPayload());
                return new ControlMessages.MapperEndResponse(Utils$.MODULE$.toStatusCode(pbMapperEndResponse.getStatus()));
            }
            case 14: {
                PbGetReducerFileGroup pbGetReducerFileGroup = PbGetReducerFileGroup.parseFrom(message.getPayload());
                return new ControlMessages.GetReducerFileGroup(pbGetReducerFileGroup.getShuffleId());
            }
            case 15: {
                PbGetReducerFileGroupResponse pbGetReducerFileGroupResponse = PbGetReducerFileGroupResponse.parseFrom(message.getPayload());
                Map fileGroup = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbGetReducerFileGroupResponse.getFileGroupsMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Integer partitionId = (Integer)tuple2._1();
                        PbFileGroup fileGroup = (PbFileGroup)tuple2._2();
                        return new Tuple2((Object)partitionId, JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)PbSerDeUtils$.MODULE$.fromPbPackedPartitionLocationsPair(fileGroup.getPartitionLocationsPair())._1()).asScala()).toSet()).asJava());
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom())).asJava();
                int[] attempts = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetReducerFileGroupResponse.getAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$6)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                HashSet<Integer> partitionIds = new HashSet<Integer>(pbGetReducerFileGroupResponse.getPartitionIdsList());
                return new ControlMessages.GetReducerFileGroupResponse(Utils$.MODULE$.toStatusCode(pbGetReducerFileGroupResponse.getStatus()), fileGroup, attempts, partitionIds);
            }
            case 69: {
                return message.getParsedPayload();
            }
            case 70: {
                return message.getParsedPayload();
            }
            case 67: {
                return message.getParsedPayload();
            }
            case 68: {
                return message.getParsedPayload();
            }
            case 16: {
                return PbUnregisterShuffle.parseFrom(message.getPayload());
            }
            case 17: {
                return PbUnregisterShuffleResponse.parseFrom(message.getPayload());
            }
            case 18: {
                PbApplicationLost pbApplicationLost = PbApplicationLost.parseFrom(message.getPayload());
                return new ControlMessages.ApplicationLost(pbApplicationLost.getAppId(), pbApplicationLost.getRequestId());
            }
            case 19: {
                PbApplicationLostResponse pbApplicationLostResponse = PbApplicationLostResponse.parseFrom(message.getPayload());
                return new ControlMessages.ApplicationLostResponse(Utils$.MODULE$.toStatusCode(pbApplicationLostResponse.getStatus()));
            }
            case 20: {
                PbHeartbeatFromApplication pbHeartbeatFromApplication = PbHeartbeatFromApplication.parseFrom(message.getPayload());
                return new ControlMessages.HeartbeatFromApplication(pbHeartbeatFromApplication.getAppId(), pbHeartbeatFromApplication.getTotalWritten(), pbHeartbeatFromApplication.getFileCount(), new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplication.getNeedCheckedWorkerListList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbHeartbeatFromApplication.getRequestId(), pbHeartbeatFromApplication.getShouldResponse());
            }
            case 49: {
                PbHeartbeatFromApplicationResponse pbHeartbeatFromApplicationResponse = PbHeartbeatFromApplicationResponse.parseFrom(message.getPayload());
                return new ControlMessages.HeartbeatFromApplicationResponse(Utils$.MODULE$.toStatusCode(pbHeartbeatFromApplicationResponse.getStatus()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getExcludedWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getUnknownWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getShuttingWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
            }
            case 23: {
                PbCheckQuota pbCheckAvailable = PbCheckQuota.parseFrom(message.getPayload());
                return new ControlMessages.CheckQuota(PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbCheckAvailable.getUserIdentifier()));
            }
            case 24: {
                PbCheckQuotaResponse pbCheckAvailableResponse = PbCheckQuotaResponse.parseFrom(message.getPayload());
                return new ControlMessages.CheckQuotaResponse(pbCheckAvailableResponse.getAvailable(), pbCheckAvailableResponse.getReason());
            }
            case 25: {
                PbReportWorkerUnavailable pbReportWorkerUnavailable = PbReportWorkerUnavailable.parseFrom(message.getPayload());
                return new ControlMessages.ReportWorkerUnavailable(new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReportWorkerUnavailable.getUnavailableList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbReportWorkerUnavailable.getRequestId());
            }
            case 55: {
                return PbRemoveWorkersUnavailableInfo.parseFrom(message.getPayload());
            }
            case 26: {
                return PbRegisterWorkerResponse.parseFrom(message.getPayload());
            }
            case 76: {
                return PbWorkerEventRequest.parseFrom(message.getPayload());
            }
            case 77: {
                return PbWorkerEventResponse.parseFrom(message.getPayload());
            }
            case 28: {
                Tuple2 tuple2;
                PbReserveSlots pbReserveSlots = PbReserveSlots.parseFrom(message.getPayload());
                UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbReserveSlots.getUserIdentifier());
                Tuple2 tuple22 = tuple2 = pbReserveSlots.getPrimaryLocationsList().isEmpty() ? PbSerDeUtils$.MODULE$.fromPbPackedPartitionLocationsPair(pbReserveSlots.getPartitionLocationsPair()) : new Tuple2(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getPrimaryLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getReplicaLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                java.util.List primaryLocations = (java.util.List)tuple2._1();
                java.util.List replicateLocations = (java.util.List)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)primaryLocations, (Object)replicateLocations);
                java.util.List primaryLocations2 = (java.util.List)tuple23._1();
                java.util.List replicateLocations2 = (java.util.List)tuple23._2();
                return new ControlMessages.ReserveSlots(pbReserveSlots.getApplicationId(), pbReserveSlots.getShuffleId(), primaryLocations2, replicateLocations2, pbReserveSlots.getSplitThreshold(), Utils$.MODULE$.toShuffleSplitMode(pbReserveSlots.getSplitMode()), Utils$.MODULE$.toPartitionType(pbReserveSlots.getPartitionType()), pbReserveSlots.getRangeReadFilter(), userIdentifier, pbReserveSlots.getPushDataTimeout(), pbReserveSlots.getPartitionSplitEnabled());
            }
            case 29: {
                PbReserveSlotsResponse pbReserveSlotsResponse = PbReserveSlotsResponse.parseFrom(message.getPayload());
                return new ControlMessages.ReserveSlotsResponse(Utils$.MODULE$.toStatusCode(pbReserveSlotsResponse.getStatus()), pbReserveSlotsResponse.getReason());
            }
            case 30: {
                PbCommitFiles pbCommitFiles = PbCommitFiles.parseFrom(message.getPayload());
                return new ControlMessages.CommitFiles(pbCommitFiles.getApplicationId(), pbCommitFiles.getShuffleId(), (java.util.List<String>)pbCommitFiles.getPrimaryIdsList(), (java.util.List<String>)pbCommitFiles.getReplicaIdsList(), (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbCommitFiles.getMapAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()), pbCommitFiles.getEpoch(), pbCommitFiles.getMockFailure());
            }
            case 31: {
                PbCommitFilesResponse pbCommitFilesResponse = PbCommitFilesResponse.parseFrom(message.getPayload());
                HashMap<String, StorageInfo> committedPrimaryStorageInfos = new HashMap<String, StorageInfo>();
                HashMap<String, StorageInfo> committedReplicaStorageInfos = new HashMap<String, StorageInfo>();
                HashMap<String, RoaringBitmap> committedBitMap = new HashMap<String, RoaringBitmap>();
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedPrimaryStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedPrimaryStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedReplicaStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedReplicaStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getMapIdBitmapMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedBitMap.put((String)entry._1(), Utils$.MODULE$.byteStringToRoaringBitmap((ByteString)entry._2())));
                return new ControlMessages.CommitFilesResponse(Utils$.MODULE$.toStatusCode(pbCommitFilesResponse.getStatus()), (java.util.List<String>)pbCommitFilesResponse.getCommittedPrimaryIdsList(), (java.util.List<String>)pbCommitFilesResponse.getCommittedReplicaIdsList(), (java.util.List<String>)pbCommitFilesResponse.getFailedPrimaryIdsList(), (java.util.List<String>)pbCommitFilesResponse.getFailedReplicaIdsList(), committedPrimaryStorageInfos, committedReplicaStorageInfos, committedBitMap, pbCommitFilesResponse.getTotalWritten(), pbCommitFilesResponse.getFileCount());
            }
            case 32: {
                PbDestroyWorkerSlots pbDestroy = PbDestroyWorkerSlots.parseFrom(message.getPayload());
                return new ControlMessages.DestroyWorkerSlots(pbDestroy.getShuffleKey(), (java.util.List<String>)pbDestroy.getPrimaryLocationsList(), (java.util.List<String>)pbDestroy.getReplicaLocationList(), pbDestroy.getMockFailure());
            }
            case 33: {
                PbDestroyWorkerSlotsResponse pbDestroyResponse = PbDestroyWorkerSlotsResponse.parseFrom(message.getPayload());
                return new ControlMessages.DestroyWorkerSlotsResponse(Utils$.MODULE$.toStatusCode(pbDestroyResponse.getStatus()), (java.util.List<String>)pbDestroyResponse.getFailedPrimariesList(), (java.util.List<String>)pbDestroyResponse.getFailedReplicasList());
            }
            case 39: {
                return ControlMessages$RemoveExpiredShuffle$.MODULE$;
            }
            case 40: {
                return ControlMessages$OneWayMessageResponse$.MODULE$;
            }
            case 41: {
                return this.pbCheckForWorkerTimeout();
            }
            case 42: {
                return ControlMessages$CheckForApplicationTimeOut$.MODULE$;
            }
            case 50: {
                return ControlMessages$CheckForHDFSExpiredDirsTimeout$.MODULE$;
            }
            case 43: {
                return PbWorkerLost.parseFrom(message.getPayload());
            }
            case 44: {
                return PbWorkerLostResponse.parseFrom(message.getPayload());
            }
            case 45: {
                PbStageEnd pbStageEnd = PbStageEnd.parseFrom(message.getPayload());
                return new ControlMessages.StageEnd(pbStageEnd.getShuffleId());
            }
            case 47: {
                return PbPartitionSplit.parseFrom(message.getPayload());
            }
            case 46: {
                PbStageEndResponse pbStageEndResponse = PbStageEndResponse.parseFrom(message.getPayload());
                return new ControlMessages.StageEndResponse(Utils$.MODULE$.toStatusCode(pbStageEndResponse.getStatus()));
            }
            case 53: {
                return PbCheckWorkersAvailable.parseFrom(message.getPayload());
            }
            case 54: {
                return PbCheckWorkersAvailableResponse.parseFrom(message.getPayload());
            }
            case 78: {
                return PbApplicationMeta.parseFrom(message.getPayload());
            }
            case 79: {
                return PbApplicationMetaRequest.parseFrom(message.getPayload());
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
    }

    private ControlMessages$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ZERO_UUID = new UUID(0L, 0L).toString();
        this.pbCheckForWorkerTimeout = PbCheckForWorkerTimeout.newBuilder().build();
    }
}

