/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.CompositeByteBuf;

public class ShuffleBlockInfoUtils {
    public static List<Long> getChunkOffsetsFromShuffleBlockInfos(int startMapIndex, int endMapIndex, long fetchChunkSize, Map<Integer, List<ShuffleBlockInfo>> indexMap, boolean isInMemory) {
        ArrayList<Long> sortedChunkOffset = new ArrayList<Long>();
        ShuffleBlockInfo lastBlock = null;
        int maxMapIndex = endMapIndex;
        if (endMapIndex == Integer.MAX_VALUE) {
            maxMapIndex = (Integer)indexMap.keySet().stream().max(Integer::compareTo).get() + 1;
        }
        if (isInMemory) {
            long currentChunkOffset = 0L;
            long lastChunkOffset = 0L;
            sortedChunkOffset.add(0L);
            for (int i = startMapIndex; i < maxMapIndex; ++i) {
                List<ShuffleBlockInfo> blockInfos = indexMap.get(i);
                if (blockInfos == null) continue;
                for (ShuffleBlockInfo info : blockInfos) {
                    if ((currentChunkOffset += info.length) - lastChunkOffset <= fetchChunkSize) continue;
                    lastChunkOffset = currentChunkOffset;
                    sortedChunkOffset.add(currentChunkOffset);
                }
            }
            if (lastChunkOffset != currentChunkOffset) {
                sortedChunkOffset.add(currentChunkOffset);
            }
        } else {
            long endChunkOffset;
            for (int i = startMapIndex; i < maxMapIndex; ++i) {
                List<ShuffleBlockInfo> blockInfos = indexMap.get(i);
                if (blockInfos == null) continue;
                for (ShuffleBlockInfo info : blockInfos) {
                    if (sortedChunkOffset.size() == 0) {
                        sortedChunkOffset.add(info.offset);
                    }
                    if (info.offset - (Long)sortedChunkOffset.get(sortedChunkOffset.size() - 1) >= fetchChunkSize) {
                        sortedChunkOffset.add(info.offset);
                    }
                    lastBlock = info;
                }
            }
            if (lastBlock != null && !sortedChunkOffset.contains(endChunkOffset = lastBlock.length + lastBlock.offset)) {
                sortedChunkOffset.add(endChunkOffset);
            }
        }
        return sortedChunkOffset;
    }

    public static Map<Integer, List<ShuffleBlockInfo>> parseShuffleBlockInfosFromByteBuffer(byte[] buffer) {
        return ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer(ByteBuffer.wrap(buffer));
    }

    public static Map<Integer, List<ShuffleBlockInfo>> parseShuffleBlockInfosFromByteBuffer(ByteBuffer buffer) {
        HashMap<Integer, List<ShuffleBlockInfo>> indexMap = new HashMap<Integer, List<ShuffleBlockInfo>>();
        while (buffer.hasRemaining()) {
            int mapId = buffer.getInt();
            int count = buffer.getInt();
            ArrayList<ShuffleBlockInfo> blockInfos = new ArrayList<ShuffleBlockInfo>();
            for (int i = 0; i < count; ++i) {
                long offset = buffer.getLong();
                long length = buffer.getLong();
                ShuffleBlockInfo info = new ShuffleBlockInfo();
                info.offset = offset;
                info.length = length;
                blockInfos.add(info);
            }
            indexMap.put(mapId, blockInfos);
        }
        return indexMap;
    }

    public static void sliceSortedBufferByMapRange(int startMapIndex, int endMapIndex, Map<Integer, List<ShuffleBlockInfo>> indexMap, CompositeByteBuf sortedByteBuf, CompositeByteBuf targetByteBuf) {
        for (int i = startMapIndex; i < endMapIndex; ++i) {
            List<ShuffleBlockInfo> blockInfos = indexMap.get(i);
            if (blockInfos == null) continue;
            for (ShuffleBlockInfo blockInfo : blockInfos) {
                ByteBuf slice = sortedByteBuf.slice((int)blockInfo.offset, (int)blockInfo.length);
                targetByteBuf.addComponent(slice);
            }
        }
    }

    public static class ShuffleBlockInfo {
        public long offset;
        public long length;
    }
}

