/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;

public class FileChunkReader
implements Closeable {
    private final FileInfo info;
    private final Path relativePath;
    private final InputStream in;
    private final MessageDigest digester;
    private long offset = 0L;
    private int chunkIndex = 0;

    public FileChunkReader(FileInfo info, Path relativePath) throws IOException {
        this.info = info;
        this.relativePath = relativePath;
        File f = info.getPath().toFile();
        if (info.getFileDigest() == null) {
            this.digester = MD5Hash.getDigester();
            this.in = new DigestInputStream(new FileInputStream(f), this.digester);
        } else {
            this.digester = null;
            this.in = new FileInputStream(f);
        }
    }

    public RaftProtos.FileChunkProto readFileChunk(int chunkMaxSize) throws IOException {
        boolean isDone;
        long remaining = this.info.getFileSize() - this.offset;
        int chunkLength = remaining < (long)chunkMaxSize ? (int)remaining : chunkMaxSize;
        byte[] chunkBuffer = new byte[chunkLength];
        IOUtils.readFully((InputStream)this.in, (byte[])chunkBuffer, (int)0, (int)chunkBuffer.length);
        ByteString data = UnsafeByteOperations.unsafeWrap((byte[])chunkBuffer);
        boolean bl = isDone = this.offset + (long)chunkLength == this.info.getFileSize();
        ByteString fileDigest = this.digester != null ? (isDone ? ByteString.copyFrom((byte[])this.digester.digest()) : ByteString.EMPTY) : ByteString.copyFrom((byte[])this.info.getFileDigest().getDigest());
        RaftProtos.FileChunkProto proto = RaftProtos.FileChunkProto.newBuilder().setFilename(this.relativePath.toString()).setOffset(this.offset).setChunkIndex(this.chunkIndex).setDone(isDone).setData(data).setFileDigest(fileDigest).build();
        ++this.chunkIndex;
        this.offset += (long)chunkLength;
        return proto;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "{chunkIndex=" + this.chunkIndex + ", offset=" + this.offset + ", " + this.info + '}';
    }
}

