/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.NativeCodeLoader;

class NativeCrc32 {
    private static final boolean isSparc = System.getProperty("os.arch").toLowerCase().startsWith("sparc");
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;

    NativeCrc32() {
    }

    public static boolean isAvailable() {
        if (isSparc) {
            return false;
        }
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static void verifyChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.nativeComputeChunkedSums(bytesPerSum, checksumType, sums, sums.position(), data, data.position(), data.remaining(), fileName, basePos, true);
    }

    public static void verifyChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.nativeComputeChunkedSumsByteArray(bytesPerSum, checksumType, sums, sumsOffset, data, dataOffset, dataLength, fileName, basePos, true);
    }

    public static void calculateChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data) {
        NativeCrc32.nativeComputeChunkedSums(bytesPerSum, checksumType, sums, sums.position(), data, data.position(), data.remaining(), "", 0L, false);
    }

    public static void calculateChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength) {
        NativeCrc32.nativeComputeChunkedSumsByteArray(bytesPerSum, checksumType, sums, sumsOffset, data, dataOffset, dataLength, "", 0L, false);
    }

    @Deprecated
    @VisibleForTesting
    static native void nativeVerifyChunkedSums(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, String var7, long var8) throws ChecksumException;

    private static native void nativeComputeChunkedSums(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, String var7, long var8, boolean var10);

    private static native void nativeComputeChunkedSumsByteArray(int var0, int var1, byte[] var2, int var3, byte[] var4, int var5, int var6, String var7, long var8, boolean var10);
}

