/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.compress.Lz4Trait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lz4Decompressor
extends Lz4Trait
implements Decompressor {
    private static final Logger logger = LoggerFactory.getLogger(Lz4Decompressor.class);
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private final Checksum checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum();

    @Override
    public int getOriginalLen(byte[] src) {
        return this.readIntLE(src, MAGIC_LENGTH + 5);
    }

    @Override
    public int decompress(byte[] src, byte[] dst, int dstOff) {
        int compressionMethod = src[MAGIC_LENGTH] & 0xFF;
        int compressedLen = this.readIntLE(src, MAGIC_LENGTH + 1);
        int originalLen = this.readIntLE(src, MAGIC_LENGTH + 5);
        int check = this.readIntLE(src, MAGIC_LENGTH + 9);
        switch (compressionMethod) {
            case 16: {
                System.arraycopy(src, HEADER_LENGTH, dst, dstOff, originalLen);
                break;
            }
            case 32: {
                int compressedLen2 = this.decompressor.decompress(src, HEADER_LENGTH, dst, dstOff, originalLen);
                if (compressedLen == compressedLen2) break;
                logger.error("Compressed length corrupted! expected: {}, actual: {}.", (Object)compressedLen, (Object)compressedLen2);
                return -1;
            }
        }
        this.checksum.reset();
        this.checksum.update(dst, dstOff, originalLen);
        if ((int)this.checksum.getValue() != check) {
            logger.error("Checksum not equal! expected: {}, actual: {}.", (Object)check, (Object)this.checksum.getValue());
            return -1;
        }
        return originalLen;
    }
}

