/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.imps;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.shaded.org.apache.curator.RetrySleeper;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;

class OperationAndData<T>
implements Delayed,
RetrySleeper {
    private static final AtomicLong nextOrdinal = new AtomicLong();
    private final BackgroundOperation<T> operation;
    private final T data;
    private final BackgroundCallback callback;
    private final long startTimeMs = System.currentTimeMillis();
    private final ErrorCallback<T> errorCallback;
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final AtomicLong sleepUntilTimeMs = new AtomicLong(0L);
    private final AtomicLong ordinal = new AtomicLong();
    private final Object context;

    OperationAndData(BackgroundOperation<T> operation, T data, BackgroundCallback callback, ErrorCallback<T> errorCallback, Object context) {
        this.operation = operation;
        this.data = data;
        this.callback = callback;
        this.errorCallback = errorCallback;
        this.context = context;
        this.reset();
    }

    void reset() {
        this.retryCount.set(0);
        this.ordinal.set(nextOrdinal.getAndIncrement());
    }

    Object getContext() {
        return this.context;
    }

    void callPerformBackgroundOperation() throws Exception {
        this.operation.performBackgroundOperation(this);
    }

    T getData() {
        return this.data;
    }

    long getElapsedTimeMs() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    int getThenIncrementRetryCount() {
        return this.retryCount.getAndIncrement();
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    ErrorCallback<T> getErrorCallback() {
        return this.errorCallback;
    }

    @VisibleForTesting
    BackgroundOperation<T> getOperation() {
        return this.operation;
    }

    @Override
    public void sleepFor(long time, TimeUnit unit) throws InterruptedException {
        this.sleepUntilTimeMs.set(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.sleepUntilTimeMs.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == this) {
            return 0;
        }
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (diff == 0L && o instanceof OperationAndData) {
            diff = this.ordinal.get() - ((OperationAndData)o).ordinal.get();
        }
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    static interface ErrorCallback<T> {
        public void retriesExhausted(OperationAndData<T> var1);
    }
}

