/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import java.util.HashMap;
import java.util.Map;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.identity.UserIdentifier$;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;

public class MetaUtil {
    private MetaUtil() {
    }

    public static WorkerInfo addrToInfo(ResourceProtos.WorkerAddress address) {
        return new WorkerInfo(address.getHost(), address.getRpcPort(), address.getPushPort(), address.getFetchPort(), address.getReplicatePort());
    }

    public static ResourceProtos.WorkerAddress infoToAddr(WorkerInfo info) {
        return ResourceProtos.WorkerAddress.newBuilder().setHost(info.host()).setRpcPort(info.rpcPort()).setPushPort(info.pushPort()).setFetchPort(info.fetchPort()).setReplicatePort(info.replicatePort()).build();
    }

    public static Map<String, DiskInfo> fromPbDiskInfos(Map<String, ResourceProtos.DiskInfo> diskInfos) {
        HashMap<String, DiskInfo> map = new HashMap<String, DiskInfo>();
        diskInfos.forEach((k, v) -> {
            DiskInfo diskInfo = new DiskInfo(v.getMountPoint(), v.getUsableSpace(), v.getAvgFlushTime(), v.getAvgFetchTime(), v.getUsedSlots());
            diskInfo.setStatus(Utils.toDiskStatus((int)v.getStatus()));
            map.put((String)k, diskInfo);
        });
        return map;
    }

    public static Map<String, ResourceProtos.DiskInfo> toPbDiskInfos(Map<String, DiskInfo> diskInfos) {
        HashMap<String, ResourceProtos.DiskInfo> map = new HashMap<String, ResourceProtos.DiskInfo>();
        diskInfos.forEach((k, v) -> map.put((String)k, ResourceProtos.DiskInfo.newBuilder().setMountPoint(v.mountPoint()).setUsableSpace(v.actualUsableSpace()).setAvgFlushTime(v.avgFlushTime()).setAvgFetchTime(v.avgFetchTime()).setUsedSlots(v.activeSlots()).setStatus(v.status().getValue()).build()));
        return map;
    }

    public static Map<UserIdentifier, ResourceConsumption> fromPbUserResourceConsumption(Map<String, ResourceProtos.ResourceConsumption> pbUserResourceConsumption) {
        HashMap<UserIdentifier, ResourceConsumption> map = new HashMap<UserIdentifier, ResourceConsumption>();
        pbUserResourceConsumption.forEach((k, v) -> {
            ResourceConsumption resourceConsumption = new ResourceConsumption(v.getDiskBytesWritten(), v.getDiskFileCount(), v.getHdfsBytesWritten(), v.getHdfsFileCount());
            map.put(UserIdentifier$.MODULE$.apply(k), resourceConsumption);
        });
        return map;
    }

    public static Map<String, ResourceProtos.ResourceConsumption> toPbUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        HashMap<String, ResourceProtos.ResourceConsumption> map = new HashMap<String, ResourceProtos.ResourceConsumption>();
        userResourceConsumption.forEach((k, v) -> map.put(k.toString(), ResourceProtos.ResourceConsumption.newBuilder().setDiskBytesWritten(v.diskBytesWritten()).setDiskFileCount(v.diskFileCount()).setHdfsBytesWritten(v.hdfsBytesWritten()).setHdfsFileCount(v.hdfsFileCount()).build()));
        return map;
    }
}

