/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.util.ScopeConfig;

public abstract class ControlIssuer
extends FocusAdapter
implements ActionListener {
    public static final int ISSUE_NO_CONTROL = 0;
    public static final String ISSUE_NO_CONTROL_STRING = "never";
    public static final int ISSUE_CONTROL_ON_ENTER_KEY = 1;
    public static final String ISSUE_CONTROL_ON_ENTER_KEY_STRING = "onEnter";
    public static final int ISSUE_CONTROL_ON_LOST_FOCUS = 2;
    public static final String ISSUE_CONTROL_ON_LOST_FOCUS_STRING = "onLostFocus";
    public static final int ISSUE_CONTROL_ONLY_ON_CHANGE = 4;
    public static final String ISSUE_CONTROL_ONLY_ON_CHANGE_STRING = "onlyOnChange";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$ControlIssuer == null ? (class$org$scopemvc$view$swing$ControlIssuer = ControlIssuer.class$("org.scopemvc.view.swing.ControlIssuer")) : class$org$scopemvc$view$swing$ControlIssuer);
    private Object previousValue;
    private int controlSettings = 7;
    static /* synthetic */ Class class$org$scopemvc$view$swing$ControlIssuer;

    public ControlIssuer(String string) {
        String string2;
        String string3 = ScopeConfig.getString("org.scopemvc.view.swing.SFields.control_on_lost_focus");
        if (string3 != null && !"true".equals(string3)) {
            LOG.warn("Deprecated configuration key: org.scopemvc.view.swing.SFields.control_on_lost_focus, use org.scopemvc.view.swing." + string + ".control_settings instead");
            this.controlSettings = 1;
        }
        if ((string2 = ScopeConfig.getString("org.scopemvc.view.swing." + string + ".control_settings")) != null) {
            this.controlSettings = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (ISSUE_NO_CONTROL_STRING.equals(string4)) {
                    this.controlSettings = 0;
                    break;
                }
                if (ISSUE_CONTROL_ON_ENTER_KEY_STRING.equals(string4)) {
                    this.controlSettings |= 1;
                    continue;
                }
                if (ISSUE_CONTROL_ON_LOST_FOCUS_STRING.equals(string4)) {
                    this.controlSettings |= 2;
                    continue;
                }
                if (!ISSUE_CONTROL_ONLY_ON_CHANGE_STRING.equals(string4)) continue;
                this.controlSettings |= 4;
            }
        }
    }

    public final int getControlSettings() {
        return this.controlSettings;
    }

    public final void setControlSettings(int n) {
        this.controlSettings = n;
    }

    public void reset() {
        this.previousValue = null;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.previousValue = this.getComponentValue();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.doViewChanged();
            if (this.needIssueControl(2)) {
                this.doIssueControl();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doViewChanged();
        if (this.needIssueControl(1)) {
            this.doIssueControl();
            this.previousValue = this.getComponentValue();
        }
    }

    protected abstract Object getComponentValue();

    protected abstract void doIssueControl();

    protected abstract void doViewChanged();

    private boolean needIssueControl(int n) {
        boolean bl;
        boolean bl2 = bl = (this.controlSettings & n) > 0;
        if ((this.controlSettings & 4) > 0) {
            boolean bl3 = this.previousValue == null || !this.previousValue.equals(this.getComponentValue());
            return bl3 && bl;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

