/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.BreadthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;
import org.objectstyle.ashwood.util.MapAttribute;

public class BoxTreeLayout
extends DigraphLayout {
    private Object root;

    public void setRoot(Object root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public void doLayout() {
        Rectangle2D box;
        Point2D.Double leftUpperCorner = new Point2D.Double(this.areaBounds.getMinX(), this.areaBounds.getMinY());
        HashMap<Object, Rectangle2D.Double> boxMap = new HashMap<Object, Rectangle2D.Double>();
        DepthFirstStampSearch sizeTraversal = new DepthFirstStampSearch(this.digraph, this.root);
        while (sizeTraversal.hasNext()) {
            Object vertex = sizeTraversal.next();
            int stamp = sizeTraversal.getStamp();
            if (stamp == 3) {
                RectangularShape leafShape = (RectangularShape)this.vertexShape.get(vertex);
                box = new Rectangle2D.Double(0.0, 0.0, leafShape.getWidth(), leafShape.getHeight());
                boxMap.put(vertex, (Rectangle2D.Double)box);
                continue;
            }
            if (stamp != 2) continue;
            RectangularShape shape = (RectangularShape)this.vertexShape.get(vertex);
            double boxWidth = -this.horizontalSpacing;
            double boxHeight = 0.0;
            ArcIterator i = this.digraph.outgoingIterator(vertex);
            while (i.hasNext()) {
                i.next();
                Object child = i.getDestination();
                Rectangle2D childBox = (Rectangle2D)boxMap.get(child);
                boxWidth += childBox.getWidth() + this.horizontalSpacing;
                boxHeight = Math.max(boxHeight, childBox.getHeight());
            }
            boxWidth = Math.max(boxWidth, shape.getWidth());
            Rectangle2D.Double box2 = new Rectangle2D.Double(0.0, 0.0, boxWidth, boxHeight += shape.getHeight() + this.verticalSpacing);
            boxMap.put(vertex, box2);
        }
        Rectangle2D rootBox = (Rectangle2D)boxMap.get(this.root);
        rootBox.setFrame(((Point2D)leftUpperCorner).getX(), ((Point2D)leftUpperCorner).getY(), rootBox.getWidth(), rootBox.getHeight());
        this.areaBounds.setFrame(rootBox.getBounds2D());
        BreadthFirstSearch placeTraversal = new BreadthFirstSearch((DigraphIteration)this.digraph, this.root);
        while (placeTraversal.hasNext()) {
            Object vertex = placeTraversal.next();
            box = (Rectangle2D)boxMap.get(vertex);
            RectangularShape shape = (RectangularShape)this.vertexShape.get(vertex);
            double childBoxX = box.getMinX();
            double childBoxY = box.getMinY() + shape.getHeight() + this.verticalSpacing;
            ArcIterator i = this.digraph.outgoingIterator(vertex);
            while (i.hasNext()) {
                i.next();
                Object child = i.getDestination();
                Rectangle2D childBox = (Rectangle2D)boxMap.get(child);
                childBox.setFrame(childBoxX, childBoxY, childBox.getWidth(), childBox.getHeight());
                childBoxX += childBox.getWidth() + this.horizontalSpacing;
            }
        }
        DepthFirstStampSearch vertexLocationTraversal = new DepthFirstStampSearch(this.digraph, this.root);
        while (vertexLocationTraversal.hasNext()) {
            Object vertex = vertexLocationTraversal.next();
            int stamp = vertexLocationTraversal.getStamp();
            if (stamp == 3) {
                RectangularShape leafShape = (RectangularShape)this.vertexShape.get(vertex);
                Rectangle2D leafBox = (Rectangle2D)boxMap.get(vertex);
                leafShape.setFrame(leafBox.getMinX(), leafBox.getMinY(), leafShape.getWidth(), leafShape.getHeight());
                continue;
            }
            if (stamp != 2) continue;
            RectangularShape shape = (RectangularShape)this.vertexShape.get(vertex);
            Rectangle2D box3 = (Rectangle2D)boxMap.get(vertex);
            double centerX = 0.0;
            int childCount = 0;
            ArcIterator i = this.digraph.outgoingIterator(vertex);
            while (i.hasNext()) {
                i.next();
                ++childCount;
                Object child = i.getDestination();
                RectangularShape childShape = (RectangularShape)this.vertexShape.get(child);
                centerX += childShape.getCenterX();
            }
            shape.setFrame((centerX /= (double)childCount) - shape.getWidth() / 2.0, box3.getMinY(), shape.getWidth(), shape.getHeight());
        }
    }

    public static void main(String[] args) {
        MapDigraph digraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        Random randomizer = new Random(100L);
        GraphUtils.randomizeTree(digraph, 3, 4, randomizer);
        HashMap vertexShapeMap = new HashMap();
        Point2D.Double leftUpperCorner = new Point2D.Double(30.0, 30.0);
        Rectangle2D.Double shapePattern = new Rectangle2D.Double(0.0, 0.0, 15.0, 10.0);
        double horizontalSpacing = 5.0;
        double verticalSpacing = 5.0;
        Object root = null;
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            vertexShapeMap.put(vertex, shapePattern.clone());
            if (root != null || digraph.incomingSize(vertex) != 0) continue;
            root = vertex;
        }
        MapAttribute vertexShape = new MapAttribute(vertexShapeMap);
        BoxTreeLayout boxTreeLayout = new BoxTreeLayout();
        boxTreeLayout.setDigraph(digraph);
        boxTreeLayout.setRoot(root);
        boxTreeLayout.setVertexShape(vertexShape);
        boxTreeLayout.setHorizontalSpacing(horizontalSpacing);
        boxTreeLayout.setVerticalSpacing(verticalSpacing);
        boxTreeLayout.setAreaBounds(new Rectangle2D.Double(30.0, 30.0, 1000.0, 1000.0));
        boxTreeLayout.doLayout();
        System.out.println("Tree");
        System.out.println("Tree bounds: " + boxTreeLayout.getAreaBounds());
        RectangularShape shape = (RectangularShape)vertexShape.get(root);
        System.out.println(root + "[" + shape.getCenterX() + "," + shape.getMinY() + "]");
        BreadthFirstSearch printTraversal = new BreadthFirstSearch((DigraphIteration)digraph, (Object)root);
        while (printTraversal.hasNext()) {
            Object vertex = printTraversal.next();
            ArcIterator i2 = digraph.outgoingIterator(vertex);
            while (i2.hasNext()) {
                i2.next();
                Object child = i2.getDestination();
                shape = (RectangularShape)vertexShape.get(child);
                System.out.print("(" + vertex + "->" + child + ")[" + shape.getCenterX() + "," + shape.getMinY() + "]");
            }
            if (digraph.outgoingSize(vertex) == 0) continue;
            System.out.println();
        }
        System.out.println("Bye-bye!");
    }
}

