/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.gen.MapClassGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.tools.NamePatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassGenerator
extends MapClassGenerator {
    private static final String WILDCARD = "*";
    protected File destDir;
    protected boolean overwrite;
    protected boolean usePkgPath = true;
    protected boolean makePairs = true;
    protected String template;
    protected String superTemplate;
    protected long timestamp = System.currentTimeMillis();
    protected String outputPattern = "*.java";
    protected String encoding;

    public DefaultClassGenerator() {
    }

    public DefaultClassGenerator(DataMap dataMap) {
        this(dataMap, new ArrayList<ObjEntity>(dataMap.getObjEntities()));
    }

    public DefaultClassGenerator(DataMap dataMap, List<ObjEntity> selectedObjEntities) {
        super(dataMap, selectedObjEntities);
    }

    public void execute() throws Exception {
        this.validateAttributes();
        if (this.makePairs) {
            String t = this.getTemplateForPairs();
            String st = this.getSupertemplateForPairs();
            this.generateClassPairs(t, st, "_");
        } else {
            this.generateSingleClasses(this.getTemplateForSingles(), "_");
        }
    }

    public void validateAttributes() throws Exception {
        if (this.destDir == null) {
            throw new Exception("'destDir' attribute is missing.");
        }
        if (!this.destDir.isDirectory()) {
            throw new Exception("'destDir' is not a directory.");
        }
        if (!this.destDir.canWrite()) {
            throw new Exception("Do not have write permissions for " + this.destDir);
        }
        if (!"1.1".equals(this.versionString) && !"1.2".equals(this.versionString)) {
            throw new Exception("'version' must be '1.1' or '1.2'.");
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOverwrite(boolean overwrite2) {
        this.overwrite = overwrite2;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    @Override
    public void closeWriter(Writer out) throws Exception {
        out.close();
    }

    @Override
    public Writer openWriter(ObjEntity entity, String pkgName, String className) throws Exception {
        File outFile;
        File file = outFile = className.startsWith("_") ? this.fileForSuperclass(pkgName, className) : this.fileForClass(pkgName, className);
        if (outFile == null) {
            return null;
        }
        FileOutputStream out = new FileOutputStream(outFile);
        return this.getEncoding() != null ? new OutputStreamWriter((OutputStream)out, this.getEncoding()) : new OutputStreamWriter(out);
    }

    protected File fileForSuperclass(String pkgName, String className) throws Exception {
        String filename = NamePatternMatcher.replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, pkgName), filename);
        if (dest.exists() && !this.isOld(dest)) {
            if (this.superTemplate == null) {
                return null;
            }
            File superTemplateFile = new File(this.superTemplate);
            if (superTemplateFile.lastModified() < dest.lastModified()) {
                return null;
            }
        }
        return dest;
    }

    protected File fileForClass(String pkgName, String className) throws Exception {
        String filename = NamePatternMatcher.replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, pkgName), filename);
        if (dest.exists()) {
            if (this.makePairs) {
                return null;
            }
            if (!this.overwrite) {
                return null;
            }
            if (!this.isOld(dest)) {
                if (this.template == null) {
                    return null;
                }
                File templateFile = new File(this.template);
                if (templateFile.lastModified() < dest.lastModified()) {
                    return null;
                }
            }
        }
        return dest;
    }

    protected boolean isOld(File file) {
        return file.lastModified() <= this.getTimestamp();
    }

    protected File mkpath(File dest, String pkgName) throws Exception {
        if (!this.usePkgPath || pkgName == null) {
            return dest;
        }
        String path = pkgName.replace('.', File.separatorChar);
        File fullPath = new File(dest, path);
        if (!fullPath.isDirectory() && !fullPath.mkdirs()) {
            throw new Exception("Error making path: " + fullPath);
        }
        return fullPath;
    }

    protected String getTemplateForSingles() throws IOException {
        return this.template != null ? this.template : this.defaultSingleClassTemplate();
    }

    protected String getTemplateForPairs() throws IOException {
        return this.template != null ? this.template : this.defaultSubclassTemplate();
    }

    protected String getSupertemplateForPairs() throws IOException {
        return this.superTemplate != null ? this.superTemplate : this.defaultSuperclassTemplate();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

