/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.ConfigSaverDelegate;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configuration {
    private static Log logObj = LogFactory.getLog(Configuration.class);
    public static final String DEFAULT_DOMAIN_FILE = "cayenne.xml";
    public static final Class<DefaultConfiguration> DEFAULT_CONFIGURATION_CLASS = DefaultConfiguration.class;
    protected static Configuration sharedConfiguration;
    protected SortedMap<String, DataDomain> dataDomains = new TreeMap<String, DataDomain>();
    protected DataSourceFactory overrideFactory;
    protected SchemaUpdateStrategy overrideStrategy;
    protected ConfigStatus loadStatus = new ConfigStatus();
    protected String domainConfigurationName = "cayenne.xml";
    protected boolean ignoringLoadFailures;
    protected ConfigLoaderDelegate loaderDelegate;
    protected ConfigSaverDelegate saverDelegate;
    protected ConfigurationShutdownHook configurationShutdownHook;
    protected Map<String, String> dataViewLocations = new HashMap<String, String>();
    protected String projectVersion;
    protected EventManager eventManager;

    public static synchronized Configuration getSharedConfiguration() {
        if (sharedConfiguration == null) {
            Configuration.initializeSharedConfiguration();
        }
        return sharedConfiguration;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public static void initializeSharedConfiguration() {
        Configuration.initializeSharedConfiguration(DEFAULT_CONFIGURATION_CLASS);
    }

    public static void initializeSharedConfiguration(Class<? extends Configuration> configurationClass) {
        Configuration conf = null;
        try {
            conf = configurationClass.newInstance();
        }
        catch (Exception ex) {
            logObj.error((Object)"Error creating shared Configuration: ", (Throwable)ex);
            throw new ConfigurationException("Error creating shared Configuration." + ex.getMessage(), ex);
        }
        Configuration.initializeSharedConfiguration(conf);
    }

    public static void initializeSharedConfiguration(Configuration conf) {
        if (!conf.canInitialize()) {
            throw new ConfigurationException("Configuration of class " + conf.getClass().getName() + " refused to be initialized.");
        }
        try {
            conf.initialize();
            conf.didInitialize();
            sharedConfiguration = conf;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Error during Configuration initialization. " + ex.getMessage(), ex);
        }
    }

    protected Configuration() {
        this(DEFAULT_DOMAIN_FILE);
    }

    protected Configuration(String domainConfigurationName) {
        this.setDomainConfigurationName(domainConfigurationName);
        this.eventManager = new EventManager();
    }

    public boolean canInitialize() {
        return true;
    }

    public abstract void initialize() throws Exception;

    public void didInitialize() {
    }

    protected ResourceLocator getResourceLocator() {
        ResourceFinder finder = this.getResourceFinder();
        if (finder == null) {
            return null;
        }
        if (finder instanceof ResourceLocator) {
            return (ResourceLocator)finder;
        }
        throw new IllegalStateException("ResourceFinder is not a ResourceLocator: " + finder);
    }

    protected abstract ResourceFinder getResourceFinder();

    protected InputStream getDomainConfiguration() {
        URL url = this.getResourceFinder().getResource(this.getDomainConfigurationName());
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            throw new ConfigurationException("Can't open config file URL: " + url, e);
        }
    }

    protected InputStream getMapConfiguration(String name) {
        URL url = this.getResourceFinder().getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            throw new ConfigurationException("Can't open config file URL: " + url, e);
        }
    }

    protected InputStream getViewConfiguration(String location) {
        URL url = this.getResourceFinder().getResource(location);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            throw new ConfigurationException("Can't open config file URL: " + url, e);
        }
    }

    public String getDomainConfigurationName() {
        return this.domainConfigurationName;
    }

    protected void setDomainConfigurationName(String domainConfigurationName) {
        this.domainConfigurationName = domainConfigurationName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public DataSourceFactory getDataSourceFactory(String userFactoryName) {
        return this.getDataSourceFactory();
    }

    public SchemaUpdateStrategy getSchemaUpdateStrategy() {
        return this.overrideStrategy;
    }

    public void setSchemaUpdateStrategy(SchemaUpdateStrategy overrideStrategy) {
        this.overrideStrategy = overrideStrategy;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.overrideFactory;
    }

    public void setDataSourceFactory(DataSourceFactory overrideFactory) {
        this.overrideFactory = overrideFactory;
    }

    public void addDomain(DataDomain domain) {
        if (domain == null) {
            throw new NullPointerException("Attempt to work with a null DataDomain.");
        }
        if (domain.getName() == null) {
            throw new NullPointerException("Attempt to add DataDomain with no name.");
        }
        DataDomain old = this.dataDomains.put(domain.getName(), domain);
        if (old != null && old != domain) {
            this.dataDomains.put(domain.getName(), old);
            throw new IllegalArgumentException("Attempt to overwrite domain with name " + domain.getName());
        }
        domain.setEventManager(this.getEventManager());
        logObj.debug((Object)("added domain: " + domain.getName()));
    }

    public DataDomain getDomain(String name) {
        return (DataDomain)this.dataDomains.get(name);
    }

    public DataDomain getDomain() {
        int size = this.dataDomains.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return this.dataDomains.values().iterator().next();
        }
        throw new CayenneRuntimeException("More than one domain is configured; use 'getDomain(String name)' instead.");
    }

    public void removeDomain(String name) {
        DataDomain domain = (DataDomain)this.dataDomains.remove(name);
        if (domain != null) {
            domain.setEventManager(null);
        }
    }

    public Collection<DataDomain> getDomains() {
        return Collections.unmodifiableCollection(this.dataDomains.values());
    }

    public boolean isIgnoringLoadFailures() {
        return this.ignoringLoadFailures;
    }

    protected void setIgnoringLoadFailures(boolean ignoringLoadFailures) {
        this.ignoringLoadFailures = ignoringLoadFailures;
    }

    public ConfigStatus getLoadStatus() {
        return this.loadStatus;
    }

    protected void setLoadStatus(ConfigStatus status) {
        this.loadStatus = status;
    }

    public ConfigLoaderDelegate getLoaderDelegate() {
        return this.loaderDelegate;
    }

    public void setLoaderDelegate(ConfigLoaderDelegate loaderDelegate) {
        this.loaderDelegate = loaderDelegate;
    }

    public ConfigSaverDelegate getSaverDelegate() {
        return this.saverDelegate;
    }

    public void setSaverDelegate(ConfigSaverDelegate saverDelegate) {
        this.saverDelegate = saverDelegate;
    }

    public void setDataViewLocations(Map<String, String> dataViewLocations) {
        this.dataViewLocations = dataViewLocations == null ? new HashMap<String, String>() : dataViewLocations;
    }

    public Map<String, String> getDataViewLocations() {
        return this.dataViewLocations;
    }

    public void shutdown() {
        for (DataDomain domain : this.getDomains()) {
            domain.shutdown();
        }
        if (this.eventManager != null) {
            this.eventManager.shutdown();
        }
    }

    public void installConfigurationShutdownHook() {
        this.uninstallConfigurationShutdownHook();
        if (this.configurationShutdownHook == null) {
            this.configurationShutdownHook = new ConfigurationShutdownHook();
        }
        Runtime.getRuntime().addShutdownHook(this.configurationShutdownHook);
    }

    public void uninstallConfigurationShutdownHook() {
        if (this.configurationShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.configurationShutdownHook);
        }
    }

    private class ConfigurationShutdownHook
    extends Thread {
        private ConfigurationShutdownHook() {
        }

        public void run() {
            Configuration.this.shutdown();
        }
    }
}

