/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.rowio.RowOutputInterface;

public class Row
implements CachedObject {
    int tableId;
    int iPos;
    protected Object[] oData;
    protected Node nPrimaryNode;

    protected Row() {
    }

    Row(Table table, Object[] objectArray) throws HsqlException {
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, table);
        }
        this.tableId = table.getId();
        this.oData = objectArray;
    }

    Node getNode(int n) {
        Node node = this.nPrimaryNode;
        while (n-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNextNode(Node node) {
        node = node == null ? this.nPrimaryNode : node.nNext;
        return node;
    }

    Row getUpdatedRow() throws HsqlException {
        return this;
    }

    public Object[] getData() {
        return this.oData;
    }

    void delete() throws HsqlException {
        ++JavaSystem.memoryRecords;
        this.nPrimaryNode = null;
    }

    void clearNodeLinks() {
        Node node = this.nPrimaryNode;
        while (node.nNext != null) {
            Node node2 = node.nNext;
            node.nNext = null;
            node = node2;
        }
        this.nPrimaryNode = null;
    }

    boolean isCascadeDeleted() {
        return this.nPrimaryNode == null;
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 0;
    }

    public void setStorageSize(int n) {
    }

    public int getStorageSize() {
        return 0;
    }

    public long getId() {
        return ((long)this.tableId << 32) + (long)this.iPos;
    }

    public static long getId(Table table, int n) {
        return ((long)table.getId() << 32) + (long)n;
    }

    public int getPos() {
        return this.iPos;
    }

    public void setPos(int n) {
        this.iPos = n;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean isKeepInMemory() {
        return true;
    }

    public void keepInMemory(boolean bl) {
    }

    public boolean isInMemory() {
        return true;
    }

    public void setInMemory(boolean bl) {
    }

    public void write(RowOutputInterface rowOutputInterface) {
    }

    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Row) {
            return ((Row)object).iPos == this.iPos;
        }
        return false;
    }

    public int hashCode() {
        return this.iPos;
    }
}

