/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.sql.Connection;
import org.apache.cayenne.access.trans.ProcedureTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ProcedureQuery;

class PostgresProcedureAction
extends SQLServerProcedureAction {
    PostgresProcedureAction(ProcedureQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    protected ProcedureTranslator createTranslator(Connection connection) {
        PostgresProcedureTranslator translator = new PostgresProcedureTranslator();
        translator.setAdapter(this.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    static class PostgresProcedureTranslator
    extends ProcedureTranslator {
        PostgresProcedureTranslator() {
        }

        protected String createSqlString() {
            String sql = super.createSqlString();
            if (sql.endsWith("}") && !sql.endsWith(")}")) {
                sql = sql.substring(0, sql.length() - 1) + "()}";
            }
            return sql;
        }
    }
}

