/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.HashMap;
import java.util.Map;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.layout.RankFunction;

public class TopologicalRankFunction
implements RankFunction {
    private int maxRank = -1;
    private Map vertexRankMap;

    public TopologicalRankFunction(Digraph digraph) {
        this.init(digraph);
    }

    private void init(Digraph digraph) {
        this.vertexRankMap = new HashMap(digraph.order());
        IndegreeTopologicalSort traversal = new IndegreeTopologicalSort(digraph);
        while (traversal.hasNext()) {
            Object vertex = traversal.next();
            int rank = -1;
            ArcIterator i = digraph.incomingIterator(vertex);
            while (i.hasNext()) {
                i.next();
                Object predecessor = i.getOrigin();
                int predRank = this.intValue(predecessor);
                if (predRank < 0) {
                    throw new ArithmeticException("Ranking failed.");
                }
                rank = Math.max(rank, predRank);
            }
            this.assignRank(vertex, ++rank);
        }
    }

    public void assignRank(Object vertex, int rank) {
        this.vertexRankMap.put(vertex, new Integer(rank));
        this.maxRank = Math.max(this.maxRank, rank);
    }

    public int maxRank() {
        return this.maxRank;
    }

    public int intValue(Object vertex) {
        Number rank = (Number)this.vertexRankMap.get(vertex);
        return rank != null ? rank.intValue() : Integer.MIN_VALUE;
    }
}

