/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.Validator;

public class ValidateAction
extends CayenneAction {
    public static String getActionName() {
        return "Validate Project";
    }

    public ValidateAction(Application application) {
        super(ValidateAction.getActionName(), application);
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    }

    public void performAction(ActionEvent e) {
        Validator val = this.getCurrentProject().getValidator();
        int validationCode = val.validate();
        if (validationCode >= 1) {
            ValidatorDialog.showDialog(Application.getFrame(), val);
        } else {
            ValidatorDialog.showValidationSuccess(Application.getFrame(), val);
        }
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Project project = (Project)path.firstInstanceOf(Project.class);
        return project != null;
    }
}

