/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.ProjectOpener;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.swing.control.FileMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenProjectAction
extends ProjectAction {
    private static Log logObj = LogFactory.getLog(OpenProjectAction.class);
    protected ProjectOpener fileChooser = new ProjectOpener();

    public static String getActionName() {
        return "Open Project";
    }

    public OpenProjectAction(Application application) {
        super(OpenProjectAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-open.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void performAction(ActionEvent e) {
        if (this.getProjectController() != null && !this.checkSaveOnClose()) {
            return;
        }
        File f = null;
        if (e.getSource() instanceof FileMenuItem) {
            FileMenuItem menu = (FileMenuItem)e.getSource();
            f = menu.getFile();
        } else if (e.getSource() instanceof File) {
            f = (File)e.getSource();
        }
        if (f == null) {
            try {
                f = this.fileChooser.openProjectFile(Application.getFrame());
            }
            catch (Exception ex) {
                logObj.warn((Object)"Error loading project file.", (Throwable)ex);
            }
        }
        if (f != null) {
            if (this.getProjectController() != null && !this.closeProject(false)) {
                return;
            }
            this.openProject(f);
        }
        this.application.getUndoManager().discardAllEdits();
    }

    public void openProject(File file) {
        try {
            if (!file.exists()) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - file \"" + file.getPath() + "\" does not exist", "Can't Open Project", 0);
                return;
            }
            this.getApplication().getFrameController().addToLastProjListAction(file.getAbsolutePath());
            Configuration config = this.buildProjectConfiguration(file);
            ApplicationProject project = new ApplicationProject(file, config);
            this.getProjectController().setProject((Project)project);
            int upgradeStatus = project.getUpgradeStatus();
            if (upgradeStatus > 0) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - it was created using a newer version of the Modeler", "Can't Open Project", 0);
                this.closeProject(false);
            } else if (upgradeStatus < 0) {
                if (this.processUpgrades((Project)project)) {
                    this.getApplication().getFrameController().projectOpenedAction((Project)project);
                } else {
                    this.closeProject(false);
                }
            } else {
                this.getApplication().getFrameController().projectOpenedAction((Project)project);
            }
        }
        catch (Exception ex) {
            logObj.warn((Object)"Error loading project file.", (Throwable)ex);
            ErrorDebugDialog.guiWarning(ex, "Error loading project");
        }
    }

    protected boolean processUpgrades(Project project) throws ProjectException {
        String msg = (String)project.getUpgradeMessages().get(0);
        int returnCode = JOptionPane.showConfirmDialog(Application.getFrame(), "Project needs an upgrade to a newer version. " + msg + ". Upgrade?", "Upgrade Needed", 0);
        if (returnCode == 1) {
            return false;
        }
        logObj.info((Object)("Will upgrade project " + project.getMainFile()));
        this.getProjectController().getProjectWatcher().pauseWatching();
        project.upgrade();
        this.getProjectController().getProjectWatcher().reconfigure();
        return true;
    }
}

