/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.VelocityTokenMaker;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextScrollPane;

public class TemplateEditorView
extends JFrame {
    protected RSyntaxTextArea editingTemplatePane;
    protected RSyntaxTextArea classPreviewPane;
    private static final String VELOCITY_KEY = "text/velocity";
    private static final ImageIcon modelerIcon = ModelerUtil.buildIcon("CayenneModeler.png");
    private static final Icon saveIcon = ModelerUtil.buildIcon("icon-save.png");
    private static final Icon resetToDefaultIcon = ModelerUtil.buildIcon("icon-undo.png");
    private static final Icon findIcon = ModelerUtil.buildIcon("icon-query.png");
    private static final Icon findAndReplaceIcon = ModelerUtil.buildIcon("icon-find_and_replace.png");
    private static final Icon previewIcon = ModelerUtil.buildIcon("icon-edit.png");
    protected JButton previewButton;
    protected JButton saveButton;
    protected JButton findButton;
    protected JButton findAndReplaceButton;
    protected JButton resetToDefaultButton;
    protected JComboBox<String> entityComboBox;
    private JSplitPane split;
    private JToolBar toolBar;
    private JPanel topPanel;

    public TemplateEditorView(List<String> entityNames) {
        this.setIconImage(modelerIcon.getImage());
        this.editingTemplatePane = new TextEditorPane();
        this.classPreviewPane = new RSyntaxTextArea();
        this.initToolBoxComponents(entityNames);
        this.mapVelocityTokenMaker();
        this.buildView();
        this.bindGeometry();
    }

    private void initToolBoxComponents(List<String> entityNames) {
        this.saveButton = new JButton(saveIcon);
        this.saveButton.setToolTipText("Save");
        this.resetToDefaultButton = new JButton(resetToDefaultIcon);
        this.resetToDefaultButton.setToolTipText("Reset to default template");
        this.findButton = new JButton(findIcon);
        this.findButton.setToolTipText("Find");
        this.findAndReplaceButton = new JButton(findAndReplaceIcon);
        this.findAndReplaceButton.setToolTipText("Find and replace");
        this.previewButton = new JButton(previewIcon);
        this.previewButton.setToolTipText("Generate preview");
        this.entityComboBox = new JComboBox<String>(entityNames.toArray(new String[0]));
        this.entityComboBox.setToolTipText("Select an entity for the test");
    }

    private void buildView() {
        this.initSplitPanel();
        this.initToolBar();
        this.initTopPanel();
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.split, "Center");
    }

    private void initSplitPanel() {
        this.editingTemplatePane.setSyntaxEditingStyle(VELOCITY_KEY);
        this.editingTemplatePane.setMarkOccurrences(true);
        RTextScrollPane leftPanel = new RTextScrollPane(this.editingTemplatePane);
        this.classPreviewPane.setSyntaxEditingStyle("text/java");
        this.classPreviewPane.setEnabled(false);
        RTextScrollPane rightPanel = new RTextScrollPane(this.classPreviewPane);
        this.split = new JSplitPane(1, leftPanel, rightPanel);
        this.split.setPreferredSize(new Dimension(1200, 700));
        this.split.setDividerSize(6);
        this.split.setDividerLocation(1.0);
    }

    private void initToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setBorder(BorderFactory.createEmptyBorder());
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.saveButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.findButton);
        this.toolBar.add(this.findAndReplaceButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.previewButton);
        this.toolBar.add(this.entityComboBox);
        this.toolBar.addSeparator();
        this.toolBar.add(this.resetToDefaultButton);
    }

    private void initTopPanel() {
        CellConstraints constraintsTop = new CellConstraints();
        PanelBuilder topPanelBuilder = new PanelBuilder(new FormLayout("left:pref:grow, right:pref", "p, 3dlu, p, 3dlu, p"));
        topPanelBuilder.setDefaultDialogBorder();
        topPanelBuilder.add((Component)this.toolBar, constraintsTop.xy(1, 1));
        topPanelBuilder.addSeparator("", constraintsTop.xyw(1, 3, 2));
        topPanelBuilder.addLabel("Editing  template", constraintsTop.xy(1, 5));
        topPanelBuilder.addLabel("Class preview", constraintsTop.xy(2, 5));
        this.topPanel = topPanelBuilder.getPanel();
    }

    private void bindGeometry() {
        ComponentGeometry geometry = new ComponentGeometry(this.getClass(), "split/divider");
        geometry.bindIntProperty(this.split, "dividerLocation", 600);
        geometry.bind(this, 1200, 700, 0);
    }

    private void mapVelocityTokenMaker() {
        AbstractTokenMakerFactory tokenMakerFactory = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        tokenMakerFactory.putMapping(VELOCITY_KEY, VelocityTokenMaker.class.getName());
    }

    public String getSelectedArtifactName() {
        Object selectedItem = this.entityComboBox.getSelectedItem();
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return null;
    }

    public JButton getPreviewButton() {
        return this.previewButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getFindButton() {
        return this.findButton;
    }

    public JButton getFindAndReplaceButton() {
        return this.findAndReplaceButton;
    }

    public JButton getResetToDefaultButton() {
        return this.resetToDefaultButton;
    }

    public String getTemplateText() {
        return this.editingTemplatePane.getText();
    }

    public RSyntaxTextArea getEditingTemplatePane() {
        return this.editingTemplatePane;
    }

    public RSyntaxTextArea getClassPreviewPane() {
        return this.classPreviewPane;
    }
}

