/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorView;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorTemplateLoader {
    private static final Logger logger = LoggerFactory.getLogger(EditorTemplateLoader.class);
    private final CgenConfiguration cgenConfiguration;
    private final JFrame view;

    public EditorTemplateLoader(CgenConfiguration configuration, TemplateEditorView view) {
        this.cgenConfiguration = configuration;
        this.view = view;
    }

    public String load(TemplateType type, Boolean isTemplateDefault) {
        if (isTemplateDefault.booleanValue()) {
            return this.getDefaultTemplateText(type);
        }
        return this.cgenConfiguration.getTemplateByType(type).getData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultTemplateText(TemplateType type) {
        TemplateType templateType = this.cgenConfiguration.isMakePairs() ? type : this.switchTypeToSingle(type);
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(templateType.pathFromSourceRoot());){
            if (stream == null) return null;
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | ResourceNotFoundException e) {
            JOptionPane.showMessageDialog(this.view, "File reading error \n" + templateType.pathFromSourceRoot(), "Error", 2);
            logger.warn("File reading error {}", (Object)templateType.pathFromSourceRoot());
        }
        return null;
    }

    private TemplateType switchTypeToSingle(TemplateType type) {
        switch (type) {
            case ENTITY_SUBCLASS: {
                return TemplateType.ENTITY_SINGLE_CLASS;
            }
            case EMBEDDABLE_SUBCLASS: {
                return TemplateType.EMBEDDABLE_SINGLE_CLASS;
            }
            case DATAMAP_SUBCLASS: {
                return TemplateType.DATAMAP_SINGLE_CLASS;
            }
        }
        throw new IllegalStateException("Illegal template type for singleClass " + String.valueOf((Object)type));
    }
}

