/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntityToSuperEntityAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfo;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.DbRelationshipPathComboBoxEditor;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjEntityRelationshipPanel
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjRelationshipListener {
    private static Logger logObj = LoggerFactory.getLogger(ObjEntityRelationshipPanel.class);
    private static final ImageIcon INHERITANCE_ICON = ModelerUtil.buildIcon("icon-inheritance.png");
    private static final Object[] DELETE_RULES = new Object[]{DeleteRule.deleteRuleName(0), DeleteRule.deleteRuleName(1), DeleteRule.deleteRuleName(2), DeleteRule.deleteRuleName(3)};
    private ProjectController mediator;
    private CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private ActionListener resolver;
    private ObjEntityAttributeRelationshipTab parentPanel;
    private boolean enabledResolve;
    private JMenuItem resolveMenu;

    public ObjEntityRelationshipPanel(ProjectController mediator, ObjEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.init();
        this.initController();
    }

    public CayenneTable getTable() {
        return this.table;
    }

    public void setTable(CayenneTable table) {
        this.table = table;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new StringRenderer());
        this.table.setDefaultRenderer(ObjEntity.class, new EntityRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjRelationshipTableModel.class, "objEntity/relationshipTable");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = ObjEntityRelationshipPanel.this.table.rowAtPoint(e.getPoint());
                int col = ObjEntityRelationshipPanel.this.table.columnAtPoint(e.getPoint());
                ObjRelationshipTableModel tableModel = (ObjRelationshipTableModel)ObjEntityRelationshipPanel.this.table.getModel();
                ObjRelationship relationship = tableModel.getRelationship(row);
                int columnFromModel = ObjEntityRelationshipPanel.this.table.getColumnModel().getColumn(col).getModelIndex();
                if (row >= 0 && columnFromModel == 0 && relationship.getSourceEntity() != tableModel.getEntity()) {
                    TableCellRenderer renderer = ObjEntityRelationshipPanel.this.table.getCellRenderer(row, col);
                    Rectangle rectangle = ObjEntityRelationshipPanel.this.table.getCellRect(row, col, false);
                    ((StringRenderer)renderer).mouseClicked(e, rectangle.x);
                }
            }
        });
        ImageIcon ico = ModelerUtil.buildIcon("icon-edit.png");
        this.resolveMenu = new CayenneAction.CayenneMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjRelationshipListener(this);
        this.resolver = e -> {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
            new ObjRelationshipInfo(this.mediator).modifyRelationship(model.getRelationship(row)).startupAction();
            this.table.cancelEditing();
            this.table.getSelectionModel().clearSelection();
            this.table.select(row);
            this.enabledResolve = false;
        };
        this.resolveMenu.addActionListener(this.resolver);
        this.table.getSelectionModel().addListSelectionListener(new ObjRelationshipListSelectionListener());
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    public void selectRelationships(ObjRelationship[] rels) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        List listRels = model.getObjectList();
        int[] newSel = new int[rels.length];
        this.parentPanel.updateActions(rels);
        for (int i = 0; i < rels.length; ++i) {
            newSel[i] = listRels.indexOf(rels[i]);
        }
        this.table.select(newSel);
        this.parentPanel.getResolve().removeActionListener(this.getResolver());
        this.parentPanel.getResolve().addActionListener(this.getResolver());
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        ObjEntity objEntity;
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
        if ((objEntity = (ObjEntity)e.getEntity()).getSuperEntity() != null) {
            this.parentPanel.getToolBar().getComponentAtIndex(2).setEnabled(false);
        } else {
            this.parentPanel.getToolBar().getComponentAtIndex(2).setEnabled(true);
        }
    }

    private Object[] createObjEntityComboModel() {
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            logObj.warn("createObjEntityComboModel:: Null DataMap.");
            return new Object[0];
        }
        if (map.getNamespace() == null) {
            logObj.warn("createObjEntityComboModel:: Null DataMap namespace - " + String.valueOf(map));
            return new Object[0];
        }
        return map.getNamespace().getObjEntities().stream().sorted(Comparators.getDataMapChildrenComparator()).toArray();
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    @Override
    public void objRelationshipChanged(RelationshipEvent e) {
        this.table.select(e.getRelationship());
    }

    @Override
    public void objRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    @Override
    public void objRelationshipRemoved(RelationshipEvent e) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getRelationship());
        model.removeRow((ObjRelationship)e.getRelationship());
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() != this) {
            return;
        }
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        if (entity == e.getEntity() || entity == null) {
            return;
        }
        TableColumn col = this.table.getColumnModel().getColumn(1);
        DefaultCellEditor editor = (DefaultCellEditor)col.getCellEditor();
        JComboBox combo = (JComboBox)editor.getComponent();
        combo.setRenderer(CellRenderers.entityListRendererWithIcons(entity.getDataMap()));
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
    }

    protected void rebuildTable(ObjEntity entity) {
        ObjRelationshipTableModel model = new ObjRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(e -> {
            if (this.table.getSelectedRow() >= 0) {
                ObjRelationship rel = model.getRelationship(this.table.getSelectedRow());
                this.enabledResolve = rel.getSourceEntity().getDbEntity() != null;
                this.resolveMenu.setEnabled(this.enabledResolve);
            }
        });
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(2);
        col.setCellEditor(new DbRelationshipPathComboBoxEditor());
        col.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                this.setToolTipText("To choose relationship press enter two times.To choose next relationship press dot.");
                return this;
            }
        });
        col = this.table.getColumnModel().getColumn(4);
        JComboBox<Object> deleteRulesCombo = Application.getWidgetFactory().createComboBox(DELETE_RULES, false);
        deleteRulesCombo.setFocusable(false);
        deleteRulesCombo.setEditable(true);
        ((JComponent)deleteRulesCombo.getEditor().getEditorComponent()).setBorder(null);
        deleteRulesCombo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        deleteRulesCombo.setSelectedIndex(0);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(deleteRulesCombo));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    public boolean isEnabledResolve() {
        return this.enabledResolve;
    }

    public ActionListener getResolver() {
        return this.resolver;
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int align = column == 3 ? 0 : 2;
            super.setHorizontalAlignment(align);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)table.getModel();
            ObjRelationship relationship = model.getRelationship(row);
            this.setIcon(null);
            column = table.getColumnModel().getColumn(column).getModelIndex();
            if (relationship != null && relationship.getSourceEntity() != model.getEntity()) {
                this.setForeground(isSelected ? new Color(0xEEEEEE) : Color.GRAY);
                if (column == 0) {
                    this.setIcon(INHERITANCE_ICON);
                }
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setFont(UIManager.getFont("Label.font"));
            return this;
        }

        public void mouseClicked(MouseEvent event, int x) {
            Point point = event.getPoint();
            if (point.x - x <= INHERITANCE_ICON.getIconWidth()) {
                ActionManager actionManager = Application.getInstance().getActionManager();
                actionManager.getAction(ObjEntityToSuperEntityAction.class).performAction(null);
            }
        }
    }

    class EntityRenderer
    extends StringRenderer {
        EntityRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object oldValue = value;
            value = CellRenderers.asString(value);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = CellRenderers.iconForObject(oldValue);
            if (isSelected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class ObjRelationshipListSelectionListener
    implements ListSelectionListener {
        private ObjRelationshipListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] rels = new ObjRelationship[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ObjEntityRelationshipPanel.this.parentPanel.getAttributePanel().getTable().getSelectionModel().clearSelection();
                if (ObjEntityRelationshipPanel.this.parentPanel.getAttributePanel().getTable().getCellEditor() != null) {
                    ObjEntityRelationshipPanel.this.parentPanel.getAttributePanel().getTable().getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().removeActionListener(ObjEntityRelationshipPanel.this.parentPanel.getAttributePanel().getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().removeActionListener(ObjEntityRelationshipPanel.this.getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().addActionListener(ObjEntityRelationshipPanel.this.getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().setToolTipText("Edit Relationship");
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().setEnabled(true);
                if (ObjEntityRelationshipPanel.this.table.getSelectedRow() >= 0) {
                    ObjRelationshipTableModel model = (ObjRelationshipTableModel)ObjEntityRelationshipPanel.this.table.getModel();
                    int[] sel = ObjEntityRelationshipPanel.this.table.getSelectedRows();
                    rels = new ObjRelationship[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        rels[i] = model.getRelationship(sel[i]);
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(ObjEntityRelationshipPanel.this.table);
                    }
                    ObjEntityRelationshipPanel.this.enabledResolve = true;
                } else {
                    ObjEntityRelationshipPanel.this.enabledResolve = false;
                }
                ObjEntityRelationshipPanel.this.resolveMenu.setEnabled(ObjEntityRelationshipPanel.this.enabledResolve);
            }
            ObjEntityRelationshipPanel.this.mediator.setCurrentObjRelationships((ObjRelationship[])rels);
            ObjEntityRelationshipPanel.this.parentPanel.updateActions(rels);
        }
    }
}

