/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.validator;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.DisableValidationInspectionAction;
import org.apache.cayenne.modeler.action.ShowValidationOptionAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.dialog.validator.ValidationDisplayHandler;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ProjectValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;

public class ValidatorDialog
extends CayenneDialog {
    protected static ValidatorDialog instance;
    public static final Color WARNING_COLOR;
    public static final Color ERROR_COLOR;
    protected JTable problemsTable;
    protected JButton closeButton;
    protected JButton refreshButton;
    protected List<ValidationFailure> validationObjects = Collections.emptyList();

    public static void showDialog(CayenneModelerFrame frame, List<ValidationFailure> list) {
        if (instance == null) {
            instance = new ValidatorDialog(frame);
            instance.centerWindow();
        }
        instance.refreshFromModel(list);
        instance.setVisible(true);
    }

    public static void showValidationSuccess(CayenneModelerFrame editor) {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
        JOptionPane.showMessageDialog(editor, "Cayenne project is valid.");
    }

    protected ValidatorDialog(CayenneModelerFrame editor) {
        super(editor, "Validation Problems", false);
        this.initView();
        this.initController();
    }

    private void initView() {
        this.refreshButton = new JButton("Refresh");
        this.closeButton = new JButton("Close");
        this.problemsTable = new JTable();
        this.problemsTable.setRowHeight(25);
        this.problemsTable.setRowMargin(3);
        this.problemsTable.setCellSelectionEnabled(false);
        this.problemsTable.setRowSelectionAllowed(true);
        this.problemsTable.setTableHeader(null);
        this.problemsTable.setDefaultRenderer(ValidationFailure.class, new ValidationRenderer());
        ActionManager actionManager = Application.getInstance().getActionManager();
        JPopupMenu popup = new JPopupMenu();
        popup.add(actionManager.getAction(ShowValidationOptionAction.class).buildMenu());
        popup.add(actionManager.getAction(DisableValidationInspectionAction.class).buildMenu());
        TablePopupHandler.install(this.problemsTable, popup);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:200dlu:grow", "pref, 3dlu, fill:40dlu:grow"));
        builder.setDefaultDialogBorder();
        builder.addLabel("Click on any row below to go to the object that has a validation problem:", cc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.problemsTable), cc.xy(1, 3));
        this.getRootPane().setDefaultButton(this.refreshButton);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.closeButton);
        buttons.add(this.refreshButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setSize(450, 350);
    }

    private void initController() {
        this.setDefaultCloseOperation(2);
        this.problemsTable.getSelectionModel().setSelectionMode(0);
        this.problemsTable.getSelectionModel().addListSelectionListener(e -> this.showFailedObject());
        this.problemsTable.getSelectionModel().addListSelectionListener(new ContextMenuSelectionListener());
        this.closeButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        this.refreshButton.addActionListener(e -> Application.getInstance().getActionManager().getAction(ValidateAction.class).actionPerformed(e));
    }

    protected void refreshFromModel(List<ValidationFailure> list) {
        this.validationObjects = list;
        this.problemsTable.setModel(new ValidatorTableModel());
    }

    private void showFailedObject() {
        if (this.problemsTable.getSelectedRow() < 0) {
            return;
        }
        ValidationFailure failure = (ValidationFailure)this.problemsTable.getModel().getValueAt(this.problemsTable.getSelectedRow(), 0);
        ValidationDisplayHandler.getErrorMsg(failure).displayField(this.getMediator(), super.getParentEditor());
    }

    static {
        WARNING_COLOR = new Color(245, 194, 194);
        ERROR_COLOR = new Color(237, 121, 121);
    }

    static class ValidationRenderer
    extends DefaultTableCellRenderer {
        ValidationRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean error = false;
            if (value != null) {
                ValidationFailure info = (ValidationFailure)value;
                value = info.getDescription();
                this.setToolTipText(info.getDescription());
            }
            this.setBackground(error ? ERROR_COLOR : WARNING_COLOR);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ContextMenuSelectionListener
    implements ListSelectionListener {
        ContextMenuSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = ValidatorDialog.this.problemsTable.getSelectedRow();
            if (e.getValueIsAdjusting() || index < 0) {
                this.setActionsFor(null);
                return;
            }
            ValidationFailure failure = (ValidationFailure)ValidatorDialog.this.problemsTable.getModel().getValueAt(index, 0);
            Inspection inspection = failure instanceof ProjectValidationFailure ? ((ProjectValidationFailure)failure).getInspection() : null;
            this.setActionsFor(inspection);
        }

        private void setActionsFor(Inspection inspection) {
            ActionManager actionManager = Application.getInstance().getActionManager();
            actionManager.getAction(DisableValidationInspectionAction.class).putInspection(inspection).setEnabled(inspection != null);
            actionManager.getAction(ShowValidationOptionAction.class).putInspection(inspection);
        }
    }

    class ValidatorTableModel
    extends AbstractTableModel {
        ValidatorTableModel() {
        }

        @Override
        public int getRowCount() {
            return ValidatorDialog.this.validationObjects.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ValidatorDialog.this.validationObjects.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ValidationFailure.class;
        }
    }
}

