/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.property.CollectionProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;

public class ListProperty<V extends Persistent>
extends CollectionProperty<V, List<V>> {
    protected ListProperty(CayennePath path, Expression expression, Class<V> entityType) {
        super(path, expression, List.class, entityType);
    }

    @Override
    public ListProperty<V> alias(String alias) {
        ASTPath exp = PropertyUtils.createPathExp(this.getPath(), alias, this.getExpression().getPathAliases());
        return PropertyFactory.createList(exp.getPath(), (Expression)exp, this.getEntityType());
    }

    @Override
    public ListProperty<V> outer() {
        CayennePathSegment last = this.getPath().last();
        if (last.isOuterJoin()) {
            return this;
        }
        CayennePath outerPath = this.getPath().parent().dot(last.outer());
        return PropertyFactory.createList(outerPath, this.getEntityType());
    }

    @Override
    public ListProperty<V> enclosing() {
        return PropertyFactory.createList(CayennePath.EMPTY_PATH, ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getEntityType());
    }
}

