/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.CayenneMapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTObjPath
extends ASTPath {
    private static final long serialVersionUID = -3574281576491705706L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ASTObjPath.class);
    public static final String OBJ_PREFIX = "obj:";

    ASTObjPath(int id) {
        super(id);
    }

    public ASTObjPath() {
        super(60);
    }

    public ASTObjPath(String value) {
        super(60);
        this.setPath(value);
    }

    public ASTObjPath(CayennePath path) {
        super(60);
        this.setPath(path);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        return o instanceof Persistent ? ((Persistent)o).readNestedProperty(this.path) : (o instanceof Entity ? this.evaluateEntityNode((Entity)o) : PropertyUtils.getProperty(o, this.path));
    }

    @Override
    public Expression shallowCopy() {
        ASTObjPath copy = new ASTObjPath(this.id);
        copy.path = this.path;
        copy.setPathAliases(this.pathAliases);
        return copy;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append(rootId);
        out.append('.');
        out.append(this.path.value());
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append(this.path.value());
    }

    @Override
    public int getType() {
        return 26;
    }

    void injectValue(Object source, Object value) {
        if (this.getPath().length() == 1) {
            try {
                String firstSegment = this.getPath().first().value();
                if (source instanceof Persistent) {
                    Persistent persistent = (Persistent)source;
                    persistent.writeProperty(firstSegment, this.dynamicCastValue(persistent, value));
                } else {
                    PropertyUtils.setProperty(source, firstSegment, value);
                }
            }
            catch (CayenneRuntimeException ex) {
                LOGGER.warn("Failed to inject value " + String.valueOf(value) + " on path " + String.valueOf(this.getPath()) + " to " + String.valueOf(source), ex);
            }
        }
    }

    private Object dynamicCastValue(Persistent source, Object value) {
        Class<?> javaClass = this.getDataTypeForObject(source);
        if (javaClass == null) {
            return value;
        }
        if (javaClass.isEnum()) {
            Object enumValue = Enum.valueOf(javaClass, value.toString());
            return enumValue;
        }
        return value;
    }

    private Class<?> getDataTypeForObject(Persistent source) {
        ObjectContext context = source.getObjectContext();
        ObjectId objectId = source.getObjectId();
        if (context == null || objectId == null) {
            return null;
        }
        ObjEntity entity = context.getEntityResolver().getObjEntity(objectId.getEntityName());
        CayenneMapEntry entry = this.evaluateEntityNode(entity);
        if (!(entry instanceof ObjAttribute)) {
            return null;
        }
        return ((ObjAttribute)entry).getJavaClass();
    }
}

