/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.access.CollectingNamePropertyVisitor;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataContextDeleteAction;
import org.apache.cayenne.access.DataContextMergeHandler;
import org.apache.cayenne.access.DataContextObjectCreator;
import org.apache.cayenne.access.DataContextQueryAction;
import org.apache.cayenne.access.DataContextSnapshotBuilder;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.NoopDelegate;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.ObjectsFromDataRowsQuery;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.ChildDiffLoader;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IteratedQueryDecorator;
import org.apache.cayenne.query.MappedExec;
import org.apache.cayenne.query.MappedSelect;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.runtime.CayenneRuntime;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ObjectContextGraphAction;
import org.apache.cayenne.util.Util;

public class DataContext
implements ObjectContext {
    protected static final ThreadLocal<ObjectContext> threadObjectContext = new ThreadLocal();
    private DataContextDelegate delegate;
    protected boolean usingSharedSnapshotCache;
    protected ObjectStore objectStore;
    protected ObjectContextGraphAction graphAction = new ObjectContextGraphAction(this);
    protected volatile Map<String, Object> userProperties;
    protected transient DataChannel channel;
    protected transient QueryCache queryCache;
    protected transient EntityResolver entityResolver;
    @Deprecated
    protected transient TransactionFactory transactionFactory;
    protected transient DataContextMergeHandler mergeHandler;
    protected boolean validatingObjectsOnCommit = true;
    protected transient DataContextObjectCreator objectCreator = new DataContextObjectCreator(this);

    public static ObjectContext getThreadObjectContext() throws IllegalStateException {
        ObjectContext context = threadObjectContext.get();
        if (context == null) {
            throw new IllegalStateException("Current thread has no bound ObjectContext.");
        }
        return context;
    }

    public static void bindThreadObjectContext(ObjectContext context) {
        threadObjectContext.set(context);
    }

    public DataContext() {
        this(null, null);
    }

    public DataContext(DataChannel channel, ObjectStore objectStore) {
        if (objectStore != null) {
            this.objectStore = objectStore;
            objectStore.setContext(this);
        }
        if (channel != null) {
            this.attachToChannel(channel);
        }
        if (objectStore != null) {
            DataDomain domain = this.getParentDataDomain();
            this.usingSharedSnapshotCache = domain != null && objectStore.getDataRowCache() == domain.getSharedSnapshotCache();
        }
    }

    protected boolean attachToRuntimeIfNeeded() {
        if (this.channel != null) {
            return false;
        }
        Injector injector = CayenneRuntime.getThreadInjector();
        if (injector == null) {
            throw new CayenneRuntimeException("Can't attach to Cayenne runtime. Null injector returned from CayenneRuntime.getThreadInjector()", new Object[0]);
        }
        this.attachToRuntime(injector);
        return true;
    }

    protected void attachToRuntime(Injector injector) {
        this.attachToChannel(injector.getInstance(DataChannel.class));
        this.setQueryCache(new NestedQueryCache(injector.getInstance(QueryCache.class)));
        this.transactionFactory = injector.getInstance(TransactionFactory.class);
    }

    protected void attachToChannel(DataChannel channel) {
        DataRowStore cache;
        EventManager eventManager;
        if (channel == null) {
            throw new NullPointerException("Null channel");
        }
        this.setChannel(channel);
        this.setEntityResolver(channel.getEntityResolver());
        if (this.mergeHandler != null) {
            this.mergeHandler.setActive(false);
            this.mergeHandler = null;
        }
        if ((eventManager = channel.getEventManager()) != null) {
            this.mergeHandler = new DataContextMergeHandler(this);
            EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
        }
        if (!this.usingSharedSnapshotCache && this.getObjectStore() != null && (cache = this.getObjectStore().getDataRowCache()) != null) {
            cache.setEventManager(eventManager);
        }
    }

    @Override
    public DataChannel getChannel() {
        this.attachToRuntimeIfNeeded();
        return this.channel;
    }

    public void setChannel(DataChannel channel) {
        this.channel = channel;
    }

    @Override
    public EntityResolver getEntityResolver() {
        this.attachToRuntimeIfNeeded();
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public DataDomain getParentDataDomain() {
        this.attachToRuntimeIfNeeded();
        if (this.channel == null) {
            return null;
        }
        if (this.channel instanceof DataDomain) {
            return (DataDomain)this.channel;
        }
        List<?> response = this.channel.onQuery(this, new DataDomainQuery()).firstList();
        if (response != null && response.size() > 0 && response.get(0) instanceof DataDomain) {
            return (DataDomain)response.get(0);
        }
        return null;
    }

    public void setDelegate(DataContextDelegate delegate) {
        this.delegate = delegate;
    }

    public DataContextDelegate getDelegate() {
        return this.delegate;
    }

    DataContextDelegate nonNullDelegate() {
        return this.delegate != null ? this.delegate : NoopDelegate.noopDelegate;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public boolean hasChanges() {
        return this.getObjectStore().hasChanges();
    }

    @Override
    public Collection<?> newObjects() {
        return this.getObjectStore().objectsInState(2);
    }

    @Override
    public Collection<?> deletedObjects() {
        return this.getObjectStore().objectsInState(6);
    }

    @Override
    public void deleteObject(Object object) throws DeleteDenyException {
        this.deleteObjects(object);
    }

    @Override
    public <T> void deleteObjects(T ... objects) throws DeleteDenyException {
        if (objects == null || objects.length == 0) {
            return;
        }
        DataContextDeleteAction action = new DataContextDeleteAction(this);
        for (T object : objects) {
            action.performDelete((Persistent)object);
        }
    }

    @Override
    public void deleteObjects(Collection<?> objects) throws DeleteDenyException {
        if (objects.isEmpty()) {
            return;
        }
        DataContextDeleteAction action = new DataContextDeleteAction(this);
        for (Object object : List.copyOf(objects)) {
            action.performDelete((Persistent)object);
        }
    }

    @Override
    public Collection<?> modifiedObjects() {
        return this.getObjectStore().objectsInState(4);
    }

    @Override
    public Collection<?> uncommittedObjects() {
        int len = this.getObjectStore().registeredObjectsCount();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Persistent> objects = new ArrayList<Persistent>(len > 100 ? len / 2 : len);
        Iterator<Persistent> it = this.getObjectStore().getObjectIterator();
        while (it.hasNext()) {
            Persistent object = it.next();
            int state = object.getPersistenceState();
            if (state != 4 && state != 2 && state != 6) continue;
            objects.add(object);
        }
        return objects;
    }

    public QueryCache getQueryCache() {
        this.attachToRuntimeIfNeeded();
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @Override
    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    protected void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    protected void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistent> T localObject(T objectFromAnotherContext) {
        if (objectFromAnotherContext == null) {
            throw new NullPointerException("Null object argument");
        }
        ObjectId id = objectFromAnotherContext.getObjectId();
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            Persistent localObject = (Persistent)this.getGraphManager().getNode(id);
            if (localObject != null) {
                return (T)localObject;
            }
            ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
            Persistent persistent = (Persistent)descriptor.createObject();
            persistent.setObjectContext(this);
            persistent.setObjectId(id);
            persistent.setPersistenceState(5);
            this.getGraphManager().registerNode(id, persistent);
            return (T)persistent;
        }
    }

    public DataRow currentSnapshot(Persistent object) {
        return new DataContextSnapshotBuilder(this.getEntityResolver(), this.getObjectStore(), object).build();
    }

    @Override
    public void prepareForAccess(Persistent object, String property, boolean lazyFaulting) {
        if (object.getPersistenceState() == 5) {
            ObjectId oid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(oid, false, 1));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for ObjectId: " + String.valueOf(oid), new Object[0]);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for ObjectId: " + String.valueOf(oid), new Object[0]);
            }
        }
        if (lazyFaulting && property != null) {
            ClassDescriptor classDescriptor = this.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
            PropertyDescriptor propertyDescriptor = classDescriptor.getProperty(property);
            if (propertyDescriptor == null) {
                List<String> properties = new CollectingNamePropertyVisitor().allProperties(classDescriptor);
                String errorMessage = String.format("Property '%s' is not declared for entity '%s'.", property, object.getObjectId().getEntityName()) + " Declared properties are: '" + String.join((CharSequence)"', '", properties) + "'.";
                throw new CayenneRuntimeException(errorMessage, new Object[0]);
            }
            propertyDescriptor.readProperty(object);
        }
    }

    public List objectsFromDataRows(ClassDescriptor descriptor, List<? extends DataRow> dataRows) {
        if (this.getObjectStore().getDataRowCache() == null) {
            return this.objectsFromDataRowsFromParentContext(descriptor, dataRows);
        }
        return new ObjectResolver(this, descriptor, true).synchronizedObjectsFromDataRows(dataRows);
    }

    private List<?> objectsFromDataRowsFromParentContext(ClassDescriptor descriptor, List<? extends DataRow> dataRows) {
        return this.getChannel().onQuery(this, new ObjectsFromDataRowsQuery(descriptor, dataRows)).firstList();
    }

    public <T extends Persistent> T objectFromDataRow(Class<T> objectClass, DataRow dataRow) {
        ObjEntity entity = this.getEntityResolver().getObjEntity(objectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped Java class: %s", objectClass);
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        List list = this.objectsFromDataRows(descriptor, Collections.singletonList(dataRow));
        return (T)((Persistent)list.get(0));
    }

    public Persistent objectFromDataRow(String entityName, DataRow dataRow) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entityName);
        List list = this.objectsFromDataRows(descriptor, Collections.singletonList(dataRow));
        return (Persistent)list.get(0);
    }

    @Override
    public <T> T newObject(Class<T> persistentClass) {
        return this.objectCreator.newObject(persistentClass);
    }

    public Persistent newObject(String entityName) {
        return this.objectCreator.newObject(entityName);
    }

    @Override
    public void registerNewObject(Object object) {
        this.objectCreator.registerNewObject(object);
    }

    public void unregisterObjects(Collection<?> objects) {
        this.getObjectStore().objectsUnregistered(objects);
    }

    @Override
    public void invalidateObjects(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("Null collection of objects to invalidate");
        }
        if (!objects.isEmpty()) {
            this.performGenericQuery(new RefreshQuery(objects));
        }
    }

    @Override
    public <T> void invalidateObjects(T ... objects) {
        if (objects != null && objects.length > 0) {
            this.performGenericQuery(new RefreshQuery(Arrays.asList(objects)));
        }
    }

    @Override
    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    @Override
    public void rollbackChangesLocally() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        }
    }

    @Override
    public void rollbackChanges() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            if (this.channel != null) {
                this.channel.onSync(this, diff, 3);
            }
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        } else if (this.channel != null) {
            this.channel.onSync(this, new CompoundDiff(), 3);
        }
    }

    @Override
    public void commitChangesToParent() {
        this.flushToParent(false);
    }

    @Override
    public void commitChanges() throws CayenneRuntimeException {
        this.flushToParent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        boolean childContext = this != originatingContext && changes != null;
        try {
            if (childContext) {
                this.getObjectStore().childContextSyncStarted();
                changes.apply(new ChildDiffLoader(this));
                this.fireDataChannelChanged(originatingContext, changes);
            }
            GraphDiff graphDiff = cascade ? this.flushToParent(true) : new CompoundDiff();
            return graphDiff;
        }
        finally {
            if (childContext) {
                this.getObjectStore().childContextSyncStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff flushToParent(boolean cascade) {
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Cannot commit changes - channel is not set.", new Object[0]);
        }
        int syncType = cascade ? 2 : 1;
        ObjectStore objectStore = this.getObjectStore();
        GraphDiff parentChanges = null;
        ObjectStore objectStore2 = objectStore;
        synchronized (objectStore2) {
            boolean noop;
            ObjectStoreGraphDiff changes = objectStore.getChanges();
            boolean bl = noop = this.isValidatingObjectsOnCommit() ? changes.validateAndCheckNoop() : changes.isNoop();
            if (noop) {
                objectStore.postprocessAfterPhantomCommit();
            } else {
                try {
                    parentChanges = this.getChannel().onSync(this, changes, syncType);
                    if (objectStore.hasChanges()) {
                        objectStore.postprocessAfterCommit(parentChanges);
                    }
                    this.fireDataChannelCommitted(this, changes);
                }
                catch (CayenneRuntimeException ex) {
                    Throwable unwound = Util.unwindException(ex);
                    if (unwound instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)unwound;
                    }
                    throw new CayenneRuntimeException("Commit Exception", unwound, new Object[0]);
                }
            }
            CompoundDiff diff = new CompoundDiff();
            diff.addAll(objectStore.getLifecycleEventInducedChanges());
            if (parentChanges != null) {
                diff.add(parentChanges);
            }
            if (!diff.isNoop()) {
                this.fireDataChannelCommitted(this.getChannel(), diff);
            }
            return diff;
        }
    }

    @Override
    public <T> List<T> select(Select<T> query) {
        return this.performQuery(query);
    }

    @Override
    public <T> T selectOne(Select<T> query) {
        List<T> objects = this.select(query);
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: %d", objects.size());
        }
        return objects.get(0);
    }

    @Override
    public <T> T selectFirst(Select<T> query) {
        List<T> objects = this.select(query);
        return objects == null || objects.isEmpty() ? null : (T)objects.get(0);
    }

    @Override
    public <T> void iterate(Select<T> query, ResultIteratorCallback<T> callback) {
        try (ResultIterator<T> it = this.iterator(query);){
            for (Object t : it) {
                callback.next(t);
            }
        }
    }

    @Override
    public <T> ResultIterator<T> iterator(Select<T> query) {
        return this.performIteratedQueryInternal(query, false);
    }

    public ResultIterator performIteratedQuery(Query query) {
        return this.performIteratedQueryInternal(query, true);
    }

    private <T> ResultIterator<T> performIteratedQueryInternal(Query query, boolean fetchDataRows) {
        IteratedQueryDecorator queryDecorator = new IteratedQueryDecorator(query, fetchDataRows);
        Query queryToRun = this.nonNullDelegate().willPerformQuery(this, queryDecorator);
        QueryResponse queryResponse = this.onQuery(this, queryToRun);
        return queryResponse.firstIterator();
    }

    @Override
    public QueryResponse performGenericQuery(Query query) {
        query = this.nonNullDelegate().willPerformGenericQuery(this, query);
        if (query == null) {
            return new GenericResponse();
        }
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Can't run query - parent DataChannel is not set.", new Object[0]);
        }
        return this.onQuery(this, query);
    }

    @Override
    public List performQuery(Query query) {
        query = this.nonNullDelegate().willPerformQuery(this, query);
        if (query == null) {
            return new ArrayList(1);
        }
        ArrayList result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    @Override
    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new DataContextQueryAction(this, context, query).execute();
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback();
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: %d", syncType);
    }

    GraphDiff onContextRollback() {
        this.rollbackChanges();
        return new CompoundDiff();
    }

    public int[] performNonSelectingQuery(Query query) {
        int[] count = this.performGenericQuery(query).firstUpdateCount();
        return count != null ? count : new int[]{};
    }

    public int[] performNonSelectingQuery(String queryName) {
        return this.performNonSelectingQuery(MappedExec.query(queryName));
    }

    public int[] performNonSelectingQuery(String queryName, Map<String, ?> parameters) {
        return this.performNonSelectingQuery(MappedExec.query(queryName).params((Map)parameters));
    }

    public List<?> performQuery(String queryName, boolean expireCachedLists) {
        return this.performQuery(queryName, Collections.emptyMap(), expireCachedLists);
    }

    public List<?> performQuery(String queryName, Map<String, ?> parameters, boolean expireCachedLists) {
        return this.performQuery(expireCachedLists ? ((MappedSelect)MappedSelect.query(queryName).params((Map)parameters)).forceNoCache() : MappedSelect.query(queryName).params((Map)parameters));
    }

    public boolean isUsingSharedSnapshotCache() {
        return this.usingSharedSnapshotCache;
    }

    public void setUsingSharedSnapshotCache(boolean flag) {
        this.usingSharedSnapshotCache = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            out.defaultWriteObject();
        }
        if (!this.isUsingSharedSnapshotCache()) {
            out.writeObject(this.objectStore.getDataRowCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isUsingSharedSnapshotCache()) {
            DataRowStore cache = (DataRowStore)in.readObject();
            this.objectStore.setDataRowCache(cache);
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            Iterator<Persistent> it = this.objectStore.getObjectIterator();
            while (it.hasNext()) {
                Persistent object = it.next();
                object.setObjectContext(this);
            }
        }
        this.objectCreator = new DataContextObjectCreator(this);
    }

    @Override
    public GraphManager getGraphManager() {
        return this.objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Persistent findOrCreateObject(ObjectId id) {
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
            if (cachedObject != null) {
                int state = cachedObject.getPersistenceState();
                if (state != 4 && state != 6) {
                    ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
                    descriptor.injectValueHolders(cachedObject);
                }
                return cachedObject;
            }
            ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
            Persistent localObject = (Persistent)descriptor.createObject();
            localObject.setObjectContext(this);
            localObject.setObjectId(id);
            this.getGraphManager().registerNode(id, localObject);
            localObject.setPersistenceState(5);
            return localObject;
        }
    }

    protected void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    TransactionFactory getTransactionFactory() {
        this.attachToRuntimeIfNeeded();
        return this.transactionFactory;
    }

    @Deprecated
    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    @Override
    public <T> ResultBatchIterator<T> batchIterator(Select<T> query, int size) {
        return new ResultBatchIterator<T>(this.iterator(query), size);
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getUserProperties() {
        if (this.userProperties == null) {
            DataContext dataContext = this;
            synchronized (dataContext) {
                if (this.userProperties == null) {
                    this.userProperties = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.userProperties;
    }

    @Override
    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    @Override
    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }

    @Override
    public void removeUserProperty(String key) {
        this.getUserProperties().remove(key);
    }

    @Override
    public void clearUserProperties() {
        this.getUserProperties().clear();
    }
}

