/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.property;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.gen.PropertyDescriptor;
import org.apache.cayenne.gen.property.PropertyDescriptorCreator;

public class NumericPropertyDescriptorCreator
implements PropertyDescriptorCreator {
    private static final List<Class<?>> PRIMITIVE_NUM_TYPES = Arrays.asList(Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE);
    private static final String FACTORY_METHOD = "PropertyFactory.createNumeric";

    @Override
    public Optional<PropertyDescriptor> apply(Class<?> aClass) {
        if (PRIMITIVE_NUM_TYPES.contains(aClass) || Number.class.isAssignableFrom(aClass)) {
            return Optional.of(new PropertyDescriptor(NumericProperty.class.getName(), FACTORY_METHOD));
        }
        return Optional.empty();
    }
}

