/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.PropertyException;

public class FieldEmbeddableDescriptor
implements EmbeddableDescriptor {
    protected Class<?> embeddableClass;
    protected Embeddable embeddable;
    protected Accessor ownerAccessor;
    protected Accessor embeddedPropertyAccessor;

    public FieldEmbeddableDescriptor(AdhocObjectFactory objectFactory, Embeddable embeddable, String ownerProperty, String embeddedPropertyProperty) {
        this.embeddable = embeddable;
        this.embeddableClass = objectFactory.getJavaClass(embeddable.getClassName());
        this.ownerAccessor = new FieldAccessor(this.embeddableClass, ownerProperty, Persistent.class);
        this.embeddedPropertyAccessor = new FieldAccessor(this.embeddableClass, embeddedPropertyProperty, String.class);
    }

    @Override
    public Object createObject(Object owner, String embeddedProperty) {
        Object embeddable;
        try {
            embeddable = this.embeddableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new PropertyException("Error creating embeddable object of class '" + this.embeddableClass.getName() + "'", e, new Object[0]);
        }
        this.ownerAccessor.setValue(embeddable, owner);
        this.embeddedPropertyAccessor.setValue(embeddable, embeddedProperty);
        return embeddable;
    }

    @Override
    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.embeddableClass;
    }
}

