/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cayenne.gen.CgenConfiguration;

public class CgenConfigList {
    public static final String DEFAULT_CONFIG_NAME = "Default";
    private final List<CgenConfiguration> configurations = new ArrayList<CgenConfiguration>();

    public CgenConfiguration getByName(String name) {
        return this.configurations.stream().filter(config -> config.getName().equals(name)).findFirst().orElse(null);
    }

    public void removeByName(String name) {
        this.configurations.removeIf(configuration -> configuration.getName().equals(name));
    }

    public void add(CgenConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public List<String> getNames() {
        return this.configurations.stream().map(CgenConfiguration::getName).collect(Collectors.toList());
    }

    public List<CgenConfiguration> getAll() {
        return this.configurations;
    }

    public boolean isExist(String name) {
        return this.configurations.stream().anyMatch(c -> name.equals(c.getName()));
    }
}

