/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;
import org.apache.cayenne.exp.property.StringProperty;

public interface PathProperty<E>
extends Property<E> {
    default public BaseProperty<Object> dot(String property) {
        CayennePath path = this.getPath().dot(property);
        return PropertyFactory.createBase(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), null);
    }

    default public <T> BaseProperty<T> dot(BaseProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createBase(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T extends Number> NumericProperty<T> dot(NumericProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createNumeric(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T extends CharSequence> StringProperty<T> dot(StringProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createString(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T> DateProperty<T> dot(DateProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createDate(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }
}

