/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceBuilder;

public class DataSourceBuilder {
    private String userName;
    private String password;
    private String driverClassName;
    private Driver driver;
    private String url;

    public static DataSourceBuilder url(String url) {
        return new DataSourceBuilder(url);
    }

    private DataSourceBuilder(String url) {
        this.url = url;
    }

    public DataSourceBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public DataSourceBuilder password(String password) {
        this.password = password;
        return this;
    }

    public DataSourceBuilder driver(String driver) {
        this.driver = null;
        this.driverClassName = driver;
        return this;
    }

    public DataSourceBuilder driver(Driver driver) {
        this.driver = driver;
        this.driverClassName = null;
        return this;
    }

    public PoolingDataSourceBuilder pool(int minConnection, int maxConnections) {
        return new PoolingDataSourceBuilder(this).minConnections(minConnection).maxConnections(maxConnections);
    }

    public DataSource build() {
        Driver driver = this.loadDriver();
        return new DriverDataSource(driver, this.url, this.userName, this.password);
    }

    private Driver loadDriver() {
        Class<?> driverClass;
        if (this.driver != null) {
            return this.driver;
        }
        try {
            driverClass = Class.forName(this.driverClassName);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can not load JDBC driver named '%s': %s", this.driverClassName, ex.getMessage());
        }
        try {
            return (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating driver '%s': %s", this.driverClassName, ex.getMessage());
        }
    }
}

