/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTCustomFunction
extends ASTFunctionCall {
    private boolean isNameSet;

    ASTCustomFunction(int id) {
        super(id, "");
    }

    public ASTCustomFunction(String name, Object ... arguments) {
        super(35, name, arguments);
    }

    @Override
    protected Object evaluateSubNode(Object o, Object[] evaluatedChildren) throws Exception {
        throw new UnsupportedOperationException("Can't evaluate custom function in memory");
    }

    @Override
    protected int getRequiredChildrenCount() {
        return 0;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTCustomFunction(this.getFunctionName(), new Object[0]);
    }

    @Override
    protected void setFunctionName(String functionName) {
        super.setFunctionName(functionName);
        if (!functionName.isEmpty()) {
            this.isNameSet = true;
        }
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (!this.isNameSet && i == 0) {
            if (!(n instanceof ASTScalar)) {
                throw new IllegalArgumentException("ASTScalar expected, got " + n);
            }
            this.setFunctionName(((ASTScalar)n).getValue().toString());
            return;
        }
        super.jjtAddChild(n, this.isNameSet ? i : --i);
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append("fn").append('(').append('\"').append(this.functionName).append('\"');
        if (this.children != null) {
            for (Node child : this.children) {
                out.append(", ");
                if (child == null) {
                    out.append("null");
                    continue;
                }
                ((SimpleNode)child).appendAsString(out);
            }
        }
        out.append(')');
    }
}

