/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataSourceDescriptor;
import org.apache.cayenne.configuration.runtime.XMLPoolingDataSourceFactory;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DataNodeDescriptor
implements ConfigurationNode,
XMLSerializable,
Serializable,
Comparable<DataNodeDescriptor> {
    protected String name;
    protected Collection<String> dataMapNames = new ArrayList<String>();
    protected String parameters;
    protected String adapterType;
    protected String dataSourceFactoryType;
    protected String schemaUpdateStrategyType;
    protected DataSourceDescriptor dataSourceDescriptor;
    protected transient Resource configurationSource;
    protected DataChannelDescriptor dataChannelDescriptor;

    public DataNodeDescriptor() {
        this(null);
    }

    public DataNodeDescriptor(String name) {
        this.name = name;
    }

    public DataChannelDescriptor getDataChannelDescriptor() {
        return this.dataChannelDescriptor;
    }

    public void setDataChannelDescriptor(DataChannelDescriptor dataChannelDescriptor) {
        this.dataChannelDescriptor = dataChannelDescriptor;
    }

    @Override
    public int compareTo(DataNodeDescriptor o) {
        String o1 = this.getName();
        String o2 = o.getName();
        if (o1 == null) {
            return o2 != null ? -1 : 0;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDataNodeDescriptor(this);
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("node").attribute("name", this.name, false).attribute("adapter", this.adapterType, true).attribute("factory", this.dataSourceFactoryType, true);
        if (!XMLPoolingDataSourceFactory.class.getName().equals(this.dataSourceFactoryType)) {
            encoder.attribute("parameters", this.parameters);
        }
        encoder.attribute("schema-update-strategy", this.schemaUpdateStrategyType, true);
        if (!this.dataMapNames.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(this.dataMapNames);
            Collections.sort(names);
            for (String mapName : names) {
                encoder.start("map-ref").attribute("name", mapName).end();
            }
        }
        if (this.dataSourceDescriptor != null && XMLPoolingDataSourceFactory.class.getName().equals(this.dataSourceFactoryType)) {
            this.dataSourceDescriptor.encodeAsXML(encoder, delegate);
        }
        delegate.visitDataNodeDescriptor(this);
        encoder.end();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<String> getDataMapNames() {
        return this.dataMapNames;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(String adapter) {
        this.adapterType = adapter;
    }

    public String getDataSourceFactoryType() {
        return this.dataSourceFactoryType;
    }

    public void setDataSourceFactoryType(String dataSourceFactory) {
        this.dataSourceFactoryType = dataSourceFactory;
    }

    public String getSchemaUpdateStrategyType() {
        return this.schemaUpdateStrategyType;
    }

    public void setSchemaUpdateStrategyType(String schemaUpdateStrategyClass) {
        this.schemaUpdateStrategyType = schemaUpdateStrategyClass;
    }

    public DataSourceDescriptor getDataSourceDescriptor() {
        return this.dataSourceDescriptor;
    }

    public void setDataSourceDescriptor(DataSourceDescriptor dataSourceDescriptor) {
        this.dataSourceDescriptor = dataSourceDescriptor;
    }

    public Resource getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(Resource configurationResource) {
        this.configurationSource = configurationResource;
    }
}

