/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;
import org.apache.cayenne.exp.property.StringProperty;

public interface PathProperty<E>
extends Property<E> {
    default public BaseProperty<Object> dot(String property) {
        String path = this.getName() + "." + property;
        return PropertyFactory.createBase(path, PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), null);
    }

    default public <T> BaseProperty<T> dot(BaseProperty<T> property) {
        String path = this.getName() + "." + property.getName();
        return PropertyFactory.createBase(path, PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T extends Number> NumericProperty<T> dot(NumericProperty<T> property) {
        String path = this.getName() + "." + property.getName();
        return PropertyFactory.createNumeric(path, PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T extends CharSequence> StringProperty<T> dot(StringProperty<T> property) {
        String path = this.getName() + "." + property.getName();
        return PropertyFactory.createString(path, PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public <T> DateProperty<T> dot(DateProperty<T> property) {
        String path = this.getName() + "." + property.getName();
        return PropertyFactory.createDate(path, PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }
}

