/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.simple;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Rectangle2D;

public class SimpleGridLayout
implements JGraphLayout {
    protected int numCellsPerRow = 0;
    protected int heightSpacing = 20;
    protected int widthSpacing;
    protected int offsetX = this.widthSpacing = 20;
    protected int offsetY = this.heightSpacing;
    protected boolean actOnUnconnectedVerticesOnly = true;
    protected boolean ordered = false;

    public void run(JGraphFacade jGraphFacade) {
        int n;
        Object[] objectArray = null;
        objectArray = this.actOnUnconnectedVerticesOnly ? jGraphFacade.getUnconnectedVertices(this.ordered).toArray() : jGraphFacade.getVertices().toArray();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n2 = this.numCellsPerRow;
        if (this.numCellsPerRow == 0) {
            n2 = (int)Math.sqrt(objectArray.length);
        }
        if (n2 == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < objectArray.length; ++n) {
            Rectangle2D rectangle2D = jGraphFacade.getBounds(objectArray[n]);
            if (rectangle2D.getWidth() > d) {
                d = rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() > d2)) continue;
            d2 = rectangle2D.getHeight();
        }
        n = objectArray.length;
        int n3 = this.offsetX;
        int n4 = this.offsetY;
        int n5 = n / n2;
        if (n % n2 > 0) {
            ++n5;
        }
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n2 && j + i * n2 < n; ++j) {
                jGraphFacade.setLocation(objectArray[j + i * n2], n3, n4);
                n3 = (int)((double)n3 + (d + (double)this.widthSpacing));
            }
            n3 = this.widthSpacing;
            n4 = (int)((double)n4 + (d2 + (double)this.heightSpacing));
        }
    }

    public int getNumCellsPerRow() {
        return this.numCellsPerRow;
    }

    public void setNumCellsPerRow(int n) {
        this.numCellsPerRow = n;
    }

    public boolean isActOnUnconnectedVerticesOnly() {
        return this.actOnUnconnectedVerticesOnly;
    }

    public void setActOnUnconnectedVerticesOnly(boolean bl) {
        this.actOnUnconnectedVerticesOnly = bl;
    }

    public int getHeightSpacing() {
        return this.heightSpacing;
    }

    public void setHeightSpacing(int n) {
        this.heightSpacing = n;
    }

    public int getWidthSpacing() {
        return this.widthSpacing;
    }

    public void setWidthSpacing(int n) {
        this.widthSpacing = n;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int n) {
        this.offsetY = n;
    }
}

