/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.cayenne.swing.ActionBinding;
import org.apache.cayenne.swing.BeanActionBinding;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.swing.BindingExpression;
import org.apache.cayenne.swing.BoundComponent;
import org.apache.cayenne.swing.CheckBoxBinding;
import org.apache.cayenne.swing.ComboSelectionBinding;
import org.apache.cayenne.swing.ItemEventBinding;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.PropertyBinding;
import org.apache.cayenne.swing.TableBinding;
import org.apache.cayenne.swing.TextBinding;

public class BindingFactory {
    protected boolean usingNullForEmptyStrings = true;
    protected boolean checkingForValueChange = true;

    public ObjectBinding bindToTable(JTable table, String listBinding, String[] headers, BindingExpression[] columns, Class[] columnClass, boolean[] editableState, Object[] sampleLongValues) {
        TableBinding binding = new TableBinding(table, listBinding, headers, columns, columnClass, editableState, sampleLongValues);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToProperty(BoundComponent component, String property, String boundProperty) {
        PropertyBinding binding = new PropertyBinding(component, property, boundProperty);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToStateChange(AbstractButton button, String property) {
        ItemEventBinding binding = new ItemEventBinding(button, property);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToAction(AbstractButton button, String action) {
        ActionBinding binding = new ActionBinding(button, action);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToAction(Component component, String action) {
        BeanActionBinding binding = new BeanActionBinding(component, action);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToAction(BoundComponent component, String action, String boundExpression) {
        ActionBinding binding = new ActionBinding(component, action, boundExpression);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToComboSelection(JComboBox component, String property, String noSelectionValue) {
        ComboSelectionBinding binding = new ComboSelectionBinding(component, property, noSelectionValue);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToTextArea(JTextArea component, String property) {
        TextBinding binding = new TextBinding(component, property);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToTextField(JTextField component, String property) {
        TextBinding binding = new TextBinding(component, property);
        return this.prepareBinding(binding);
    }

    public ObjectBinding bindToCheckBox(JCheckBox component, String property) {
        CheckBoxBinding binding = new CheckBoxBinding(component, property);
        return this.prepareBinding(binding);
    }

    protected ObjectBinding prepareBinding(BindingBase binding) {
        binding.setUsingNullForEmptyStrings(this.isUsingNullForEmptyStrings());
        binding.setCheckingForValueChange(this.isCheckingForValueChange());
        return binding;
    }

    public boolean isCheckingForValueChange() {
        return this.checkingForValueChange;
    }

    public void setCheckingForValueChange(boolean callingSetForEqual) {
        this.checkingForValueChange = callingSetForEqual;
    }

    public boolean isUsingNullForEmptyStrings() {
        return this.usingNullForEmptyStrings;
    }

    public void setUsingNullForEmptyStrings(boolean usingNullForEmptyStrings) {
        this.usingNullForEmptyStrings = usingNullForEmptyStrings;
    }
}

