/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBConnectionAwareAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.merge.MergerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateAction
extends DBConnectionAwareAction {
    private static Logger LOGGER = LoggerFactory.getLogger(MigrateAction.class);
    private boolean dialogShown;

    public MigrateAction(Application application) {
        super(MigrateAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Migrate Database Schema";
    }

    @Override
    public void performAction(ActionEvent e) {
        DataSourceWizard connectWizard = this.getDataSourceWizard("Migrate DB Schema: Connect to Database");
        if (connectWizard == null) {
            return;
        }
        DataMap map = this.getProjectController().getCurrentDataMap();
        if (map == null) {
            throw new IllegalStateException("No current DataMap selected.");
        }
        this.dialogShown = false;
        DbActionOptionsDialog optionsDialog = this.loaderOptionDialog(connectWizard);
        if (this.dialogShown && optionsDialog == null) {
            return;
        }
        String selectedCatalog = optionsDialog == null ? null : optionsDialog.getSelectedCatalog();
        String selectedSchema = optionsDialog == null ? null : optionsDialog.getSelectedSchema();
        MergerTokenFactoryProvider mergerTokenFactoryProvider = this.getApplication().getInjector().getInstance(MergerTokenFactoryProvider.class);
        new MergerOptions(this.getProjectController(), "Migrate DB Schema: Options", connectWizard.getConnectionInfo(), map, selectedCatalog, selectedSchema, mergerTokenFactoryProvider).startupAction();
    }

    protected DbActionOptionsDialog createDialog(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema, int command) {
        this.dialogShown = true;
        if (command == 1) {
            return new DbActionOptionsDialog(Application.getFrame(), "Migrate DB Schema: Select Catalog and Schema", catalogs, schemas, currentCatalog, currentSchema);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DbActionOptionsDialog loaderOptionDialog(DataSourceWizard connectWizard) {
        String currentCatalog;
        List<String> schemas;
        List<String> catalogs;
        String currentSchema = null;
        try (Connection connection = connectWizard.getDataSource().getConnection();){
            catalogs = this.getCatalogs(connectWizard, connection);
            schemas = this.getSchemas(connection);
            if (catalogs.isEmpty() && schemas.isEmpty()) {
                DbActionOptionsDialog dbActionOptionsDialog = null;
                return dbActionOptionsDialog;
            }
            currentCatalog = connection.getCatalog();
            try {
                currentSchema = connection.getSchema();
            }
            catch (Throwable th) {
                LOGGER.warn("Error getting schema.", th);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
            return null;
        }
        DbActionOptionsDialog optionsDialog = this.getStartDialog(catalogs, schemas, currentCatalog, currentSchema);
        optionsDialog.setVisible(true);
        while (optionsDialog.getChoice() != 0) {
            if (optionsDialog.getChoice() == 1) {
                return optionsDialog;
            }
            optionsDialog = this.createDialog(catalogs, schemas, currentCatalog, currentSchema, optionsDialog.getChoice());
            optionsDialog.setVisible(true);
        }
        return null;
    }

    private DbActionOptionsDialog getStartDialog(List<String> catalogs, List<String> schemas, String currentCatalog, String currentSchema) {
        int command = 1;
        return this.createDialog(catalogs, schemas, currentCatalog, currentSchema, command);
    }

    private List<String> getCatalogs(DataSourceWizard connectWizard, Connection connection) throws Exception {
        if (!connectWizard.getAdapter().supportsCatalogsOnReverseEngineering()) {
            return Collections.EMPTY_LIST;
        }
        return DbLoader.loadCatalogs(connection);
    }

    private List<String> getSchemas(Connection connection) throws Exception {
        return DbLoader.loadSchemas(connection);
    }
}

