/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelQueryFilterChain;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationship;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationshipBatchFaultingStrategy;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationshipFaultingStrategy;
import org.apache.cayenne.query.Query;

public class ObjectIdRelationshipFilter
implements DataChannelQueryFilter {
    private ObjectIdRelationshipFaultingStrategy faultingStrategy = this.createFaultingStrategy();

    protected ObjectIdRelationshipFaultingStrategy createFaultingStrategy() {
        return new ObjectIdRelationshipBatchFaultingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResponse onQuery(ObjectContext context, Query query, DataChannelQueryFilterChain chain) {
        try {
            QueryResponse queryResponse = chain.onQuery(context, query);
            return queryResponse;
        }
        finally {
            this.faultingStrategy.afterQuery();
        }
    }

    @PostUpdate(entityAnnotations={ObjectIdRelationship.class})
    @PostPersist(entityAnnotations={ObjectIdRelationship.class})
    void postCommit(DataObject object) {
        object.getObjectContext().invalidateObjects((Object[])new DataObject[]{object});
    }

    @PostLoad(entityAnnotations={ObjectIdRelationship.class})
    void postLoad(DataObject object) {
        this.faultingStrategy.afterObjectLoaded(object);
    }
}

